/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.OntStatementImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntAnnotation;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public class OntAnnotationImpl
extends OntObjectImpl
implements OntAnnotation {
    public static final Set<Property> REQUIRED_PROPERTIES = Stream.of(OWL.annotatedSource, OWL.annotatedProperty, OWL.annotatedTarget).collect(Iter.toUnmodifiableSet());
    private static final Set<Node> REQUIRED_PROPERTY_NODES = REQUIRED_PROPERTIES.stream().map(FrontsNode::asNode).collect(Iter.toUnmodifiableSet());
    private static final Node AXIOM = OWL.Axiom.asNode();
    private static final Node ANNOTATION = OWL.Annotation.asNode();
    public static final Set<Property> SPEC = Stream.concat(Stream.of(RDF.type), REQUIRED_PROPERTIES.stream()).collect(Iter.toUnmodifiableSet());
    public static final Set<Resource> EXTRA_ROOT_TYPES = Stream.of(OWL.AllDisjointClasses, OWL.AllDisjointProperties, OWL.AllDifferent, OWL.NegativePropertyAssertion).collect(Iter.toUnmodifiableSet());
    public static final List<Resource> ROOT_TYPES = Stream.concat(Stream.of(OWL.Axiom, OWL.Annotation), EXTRA_ROOT_TYPES.stream()).collect(Iter.toUnmodifiableList());
    public static final Set<Node> EXTRA_ROOT_TYPES_AS_NODES = EXTRA_ROOT_TYPES.stream().map(FrontsNode::asNode).collect(Iter.toUnmodifiableSet());
    public static OntObjectFactory annotationFactory = new CommonOntObjectFactory(new OntMaker.Default(OntAnnotationImpl.class), OntAnnotationImpl::listRootAnnotations, OntAnnotationImpl::testAnnotation, new OntFilter[0]);
    public static final Comparator<OntAnnotation> DEFAULT_ANNOTATION_COMPARATOR = (left, right) -> {
        Set leftSet = OntAnnotationImpl.listRelatedStatements(left).toSet();
        Set rightSet = OntAnnotationImpl.listRelatedStatements(right).toSet();
        int res = Integer.compare(leftSet.size(), rightSet.size());
        while (res == 0) {
            OntStatement s1 = (OntStatement)OntAnnotationImpl.removeMin(leftSet, Models.STATEMENT_COMPARATOR_IGNORE_BLANK);
            OntStatement s2 = (OntStatement)OntAnnotationImpl.removeMin(rightSet, Models.STATEMENT_COMPARATOR_IGNORE_BLANK);
            res = Models.STATEMENT_COMPARATOR_IGNORE_BLANK.compare(s1, s2);
            if (!leftSet.isEmpty() && !rightSet.isEmpty()) continue;
            break;
        }
        return -res;
    };

    public OntAnnotationImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntAnnotation createAnnotation(Model model, Statement base, Resource type) {
        Resource res = Objects.requireNonNull(model).createResource();
        if (!model.contains(Objects.requireNonNull(base))) {
            throw new OntJenaException.IllegalArgument("Can't find " + Models.toString(base));
        }
        res.addProperty(RDF.type, (RDFNode)type);
        res.addProperty(OWL.annotatedSource, (RDFNode)base.getSubject());
        res.addProperty(OWL.annotatedProperty, (RDFNode)base.getPredicate());
        res.addProperty(OWL.annotatedTarget, base.getObject());
        return (OntAnnotation)res.as(OntAnnotation.class);
    }

    @Override
    public Stream<OntStatement> spec() {
        return Iter.asStream(this.listStatements().filterKeep(s -> SPEC.contains(s.getPredicate()) || s.isAnnotation()));
    }

    @Override
    public OntStatement getBase() {
        Resource s = this.getRequiredObject(OWL.annotatedSource, Resource.class);
        Property p = this.getRequiredObject(OWL.annotatedProperty, Property.class);
        RDFNode o = this.getRequiredObject(OWL.annotatedTarget, RDFNode.class);
        return this.getModel().statements(s, p, o).findAny().orElseThrow(() -> new OntJenaException("Can't find triple [" + s + ", " + p + ", " + o + "]"));
    }

    @Override
    public ExtendedIterator<OntStatement> listAssertions() {
        return this.listStatements().filterKeep(s -> !SPEC.contains(s.getPredicate()) && s.isAnnotation());
    }

    @Override
    public Stream<OntStatement> annotations() {
        return this.assertions();
    }

    @Override
    public Stream<OntAnnotation> descendants() {
        return Iter.asStream(this.listDescendants());
    }

    public ExtendedIterator<OntAnnotation> listDescendants() {
        OntGraphModelImpl m = this.getModel();
        return this.listAnnotatedSources().mapWith(s -> m.findNodeAs(((OntStatementImpl)s).getSubjectNode(), OntAnnotation.class)).filterDrop(Objects::isNull);
    }

    protected ExtendedIterator<OntStatement> listAnnotatedSources() {
        return this.getModel().listOntStatements(null, OWL.annotatedSource, (RDFNode)this);
    }

    @Override
    public OntStatement addAnnotation(OntNAP property, RDFNode value) {
        OntGraphModelImpl model = this.getModel();
        model.add(this, property, value);
        return model.createStatement(this, property, value);
    }

    @Override
    public Class<? extends OntObject> getActualClass() {
        return OntAnnotation.class;
    }

    public static ExtendedIterator<Node> listRootAnnotations(EnhGraph eg) {
        return Iter.flatMap(Iter.of(OWL.Axiom.asNode()).andThen(EXTRA_ROOT_TYPES_AS_NODES.iterator()), t -> eg.asGraph().find(Node.ANY, RDF.Nodes.type, t)).mapWith(Triple::getSubject);
    }

    public static boolean testAnnotation(Node node, EnhGraph graph) {
        return OntAnnotationImpl.testAnnotation(node, graph.asGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testAnnotation(Node node, Graph graph) {
        if (!node.isBlank()) {
            return false;
        }
        try (ExtendedIterator types = graph.find(node, RDF.Nodes.type, Node.ANY).mapWith(Triple::getObject);){
            while (types.hasNext()) {
                Node t = (Node)types.next();
                if (AXIOM.equals((Object)t) || ANNOTATION.equals((Object)t)) {
                    Set props = graph.find(node, Node.ANY, Node.ANY).mapWith(Triple::getPredicate).toSet();
                    boolean bl = props.containsAll(REQUIRED_PROPERTY_NODES);
                    return bl;
                }
                if (!EXTRA_ROOT_TYPES_AS_NODES.contains(t)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static <S> S removeMin(Set<S> notEmptySet, Comparator<? super S> comparator) throws IllegalStateException {
        S res = notEmptySet.stream().min(comparator).orElseThrow(IllegalStateException::new);
        if (!notEmptySet.remove(res)) {
            throw new IllegalStateException();
        }
        return res;
    }

    public static ExtendedIterator<OntStatement> listRelatedStatements(OntAnnotation annotation) {
        OntAnnotationImpl a = (OntAnnotationImpl)annotation;
        return a.listAssertions().andThen((Iterator)a.listDescendants().mapWith(OntObject::getRoot));
    }
}

