/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.Entities;
import ru.avicomp.ontapi.jena.impl.OntCEImpl;
import ru.avicomp.ontapi.jena.impl.OntListImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntClass;
import ru.avicomp.ontapi.jena.model.OntDOP;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public class OntClassImpl
extends OntObjectImpl
implements OntClass {
    public OntClassImpl(Node n, EnhGraph eg) {
        super(OntObjectImpl.checkNamed(n), eg);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntClassImpl.getOptionalRootStatement(this, OWL.Class);
    }

    @Override
    public boolean isBuiltIn() {
        return Entities.CLASS.builtInURIs().contains(this);
    }

    public Class<OntClass> getActualClass() {
        return OntClass.class;
    }

    @Override
    public OntIndividual.Anonymous createIndividual() {
        return OntCEImpl.createAnonymousIndividual(this.getModel(), this);
    }

    @Override
    public OntIndividual.Named createIndividual(String uri) {
        return OntCEImpl.createNamedIndividual(this.getModel(), this, uri);
    }

    @Override
    public void removeHasKey() {
        this.clearAll(OWL.hasKey);
    }

    @Override
    public OntList<OntDOP> createHasKey(Collection<OntOPE> ope, Collection<OntNDP> dpe) {
        return OntCEImpl.createHasKey(this.getModel(), this, Stream.of(ope, dpe).flatMap(Collection::stream));
    }

    @Override
    public OntStatement addHasKey(OntDOP ... properties) {
        return OntCEImpl.createHasKey(this.getModel(), this, Arrays.stream(properties)).getRoot();
    }

    @Override
    public Optional<OntList<OntDOP>> findHasKey(RDFNode list) {
        return OntCEImpl.findHasKey(this, list);
    }

    @Override
    public Stream<OntList<OntDOP>> listHasKeys() {
        return OntCEImpl.listHasKeys(this.getModel(), this);
    }

    @Override
    public void removeHasKey(RDFNode list) throws OntJenaException.IllegalArgument {
        OntCEImpl.removeHasKey(this, list);
    }

    @Override
    public OntList<OntCE> createDisjointUnion(Collection<OntCE> classes) {
        return OntListImpl.create(this.getModel(), this, OWL.disjointUnionOf, OntCE.class, Objects.requireNonNull(classes).stream().distinct().iterator());
    }

    @Override
    public Stream<OntList<OntCE>> listDisjointUnions() {
        return OntListImpl.stream(this.getModel(), this, OWL.disjointUnionOf, OntCE.class);
    }

    @Override
    public void removeDisjointUnion(RDFNode rdfList) throws OntJenaException.IllegalArgument {
        this.remove(OWL.disjointUnionOf, (RDFNode)((OntList)this.findDisjointUnion(rdfList).orElseThrow(() -> new OntJenaException.IllegalArgument("Can't find list " + rdfList))).clearAnnotations().clear());
    }

    @Override
    public void removeDisjointUnionOf() {
        this.clearAll(OWL.disjointUnionOf);
    }
}

