/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDFS;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.Entities;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntListImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.Configurable;
import ru.avicomp.ontapi.jena.impl.conf.MultiOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntFR;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public class OntDRImpl
extends OntObjectImpl
implements OntDR {
    private static final OntFinder DR_FINDER = new OntFinder.ByType(RDFS.Datatype);
    private static final OntFilter DR_FILTER = OntFilter.BLANK.and(new OntFilter.HasType(RDFS.Datatype));
    public static OntObjectFactory oneOfDRFactory = new CommonOntObjectFactory(new OntMaker.Default(OneOfImpl.class), DR_FINDER, DR_FILTER.and(new OntFilter.HasPredicate(OWL.oneOf)), new OntFilter[0]);
    public static OntObjectFactory restrictionDRFactory = new CommonOntObjectFactory(new OntMaker.Default(RestrictionImpl.class), DR_FINDER, DR_FILTER.and(new OntFilter.HasPredicate(OWL.onDatatype)).and(new OntFilter.HasPredicate(OWL.withRestrictions)), new OntFilter[0]);
    public static OntObjectFactory complementOfDRFactory = new CommonOntObjectFactory(new OntMaker.Default(ComplementOfImpl.class), DR_FINDER, DR_FILTER.and(new OntFilter.HasPredicate(OWL.datatypeComplementOf)), new OntFilter[0]);
    public static OntObjectFactory unionOfDRFactory = new CommonOntObjectFactory(new OntMaker.Default(UnionOfImpl.class), DR_FINDER, DR_FILTER.and(new OntFilter.HasPredicate(OWL.unionOf)), new OntFilter[0]);
    public static OntObjectFactory intersectionOfDRFactory = new CommonOntObjectFactory(new OntMaker.Default(IntersectionOfImpl.class), DR_FINDER, DR_FILTER.and(new OntFilter.HasPredicate(OWL.intersectionOf)), new OntFilter[0]);
    public static OntObjectFactory abstractComponentsDRFactory = new MultiOntObjectFactory(DR_FINDER, null, oneOfDRFactory, restrictionDRFactory, unionOfDRFactory, intersectionOfDRFactory);
    public static OntObjectFactory abstractAnonDRFactory = new MultiOntObjectFactory(DR_FINDER, null, oneOfDRFactory, restrictionDRFactory, complementOfDRFactory, unionOfDRFactory, intersectionOfDRFactory);
    public static Configurable<OntObjectFactory> abstractDRFactory = OntDRImpl.buildMultiFactory(DR_FINDER, null, Entities.DATATYPE, abstractAnonDRFactory);

    public OntDRImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntDRImpl.getRequiredRootStatement(this, RDFS.Datatype);
    }

    private static Resource create(OntGraphModelImpl model) {
        Resource res = model.createResource();
        model.add(res, RDF.type, (RDFNode)RDFS.Datatype);
        return res;
    }

    public static OntDR.OneOf createOneOf(OntGraphModelImpl model, Stream<Literal> values) {
        OntJenaException.notNull(values, "Null values stream.");
        Resource res = OntDRImpl.create(model);
        model.add(res, OWL.oneOf, (RDFNode)model.createList(values.iterator()));
        return model.getNodeAs(res.asNode(), OntDR.OneOf.class);
    }

    public static OntDR.Restriction createRestriction(OntGraphModelImpl model, OntDT dataType, Stream<OntFR> values) {
        OntJenaException.notNull(dataType, "Null data-type.");
        OntJenaException.notNull(values, "Null values stream.");
        Resource res = OntDRImpl.create(model);
        model.add(res, OWL.onDatatype, (RDFNode)dataType);
        model.add(res, OWL.withRestrictions, (RDFNode)model.createList(values.iterator()));
        return model.getNodeAs(res.asNode(), OntDR.Restriction.class);
    }

    public static OntDR.ComplementOf createComplementOf(OntGraphModelImpl model, OntDR other) {
        OntJenaException.notNull(other, "Null data range.");
        Resource res = OntDRImpl.create(model);
        model.add(res, OWL.datatypeComplementOf, (RDFNode)other);
        return model.getNodeAs(res.asNode(), OntDR.ComplementOf.class);
    }

    public static OntDR.UnionOf createUnionOf(OntGraphModelImpl model, Stream<OntDR> values) {
        OntJenaException.notNull(values, "Null values stream.");
        Resource res = OntDRImpl.create(model);
        model.add(res, OWL.unionOf, (RDFNode)model.createList(values.iterator()));
        return model.getNodeAs(res.asNode(), OntDR.UnionOf.class);
    }

    public static OntDR.IntersectionOf createIntersectionOf(OntGraphModelImpl model, Stream<OntDR> values) {
        OntJenaException.notNull(values, "Null values stream.");
        Resource res = OntDRImpl.create(model);
        model.add(res, OWL.intersectionOf, (RDFNode)model.createList(values.iterator()));
        return model.getNodeAs(res.asNode(), OntDR.IntersectionOf.class);
    }

    protected static abstract class ComponentsDRImpl<N extends RDFNode>
    extends OntDRImpl
    implements OntDR.ComponentsDR<N> {
        protected final Property predicate;
        protected final Class<N> type;

        protected ComponentsDRImpl(Node n, EnhGraph m, Property predicate, Class<N> type) {
            super(n, m);
            this.predicate = OntJenaException.notNull(predicate, "Null predicate.");
            this.type = OntJenaException.notNull(type, "Null view.");
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.concat(this.declaration(), this.getList().content());
        }

        public Stream<OntStatement> declaration() {
            return super.spec();
        }

        @Override
        public OntList<N> getList() {
            return OntListImpl.asSafeOntList(this.getRequiredObject(this.predicate, RDFList.class), this.getModel(), this, this.predicate, null, this.type);
        }
    }

    public static class IntersectionOfImpl
    extends ComponentsDRImpl<OntDR>
    implements OntDR.IntersectionOf {
        public IntersectionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.intersectionOf, OntDR.class);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDR.IntersectionOf.class;
        }
    }

    public static class UnionOfImpl
    extends ComponentsDRImpl<OntDR>
    implements OntDR.UnionOf {
        public UnionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.unionOf, OntDR.class);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDR.UnionOf.class;
        }
    }

    public static class RestrictionImpl
    extends ComponentsDRImpl<OntFR>
    implements OntDR.Restriction {
        public RestrictionImpl(Node n, EnhGraph m) {
            super(n, m, OWL.withRestrictions, OntFR.class);
        }

        public Class<OntDR.Restriction> getActualClass() {
            return OntDR.Restriction.class;
        }

        @Override
        public OntDT getDatatype() {
            return this.getRequiredObject(OWL.onDatatype, OntDT.class);
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.of(this.declaration(), this.required(OWL.onDatatype), this.withRestrictionsSpec()).flatMap(Function.identity());
        }

        public Stream<OntStatement> withRestrictionsSpec() {
            return this.getList().content().flatMap(s -> {
                if (!s.getObject().canAs(OntFR.class)) {
                    return Stream.of(s);
                }
                return Stream.of(s, ((OntFR)s.getObject().as(OntFR.class)).getRoot());
            });
        }
    }

    public static class OneOfImpl
    extends ComponentsDRImpl<Literal>
    implements OntDR.OneOf {
        public OneOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL.oneOf, Literal.class);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDR.OneOf.class;
        }
    }

    public static class ComplementOfImpl
    extends OntDRImpl
    implements OntDR.ComplementOf {
        public ComplementOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntDR getDataRange() {
            return this.getRequiredObject(OWL.datatypeComplementOf, OntDR.class);
        }

        @Override
        public Stream<OntStatement> spec() {
            return Stream.concat(super.spec(), this.required(OWL.datatypeComplementOf));
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntDR.ComplementOf.class;
        }
    }
}

