/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.MultiOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNPA;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntPE;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public abstract class OntNPAImpl<P extends OntPE, T extends RDFNode>
extends OntObjectImpl
implements OntNPA<P, T> {
    private static OntFinder NPA_FINDER = new OntFinder.ByType(OWL.NegativePropertyAssertion);
    private static OntFilter NPA_FILTER = OntFilter.BLANK.and(new OntFilter.HasPredicate(OWL.sourceIndividual)).and(new OntFilter.HasPredicate(OWL.assertionProperty));
    public static OntObjectFactory objectNPAFactory = new CommonOntObjectFactory(new OntMaker.Default(ObjectAssertionImpl.class), NPA_FINDER, NPA_FILTER, new OntFilter.HasPredicate(OWL.targetIndividual));
    public static OntObjectFactory dataNPAFactory = new CommonOntObjectFactory(new OntMaker.Default(DataAssertionImpl.class), NPA_FINDER, NPA_FILTER, new OntFilter.HasPredicate(OWL.targetValue));
    public static OntObjectFactory abstractNPAFactory = new MultiOntObjectFactory(NPA_FINDER, null, objectNPAFactory, dataNPAFactory);

    public OntNPAImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntNPA.DataAssertion create(OntGraphModelImpl model, OntIndividual source, OntNDP property, Literal target) {
        Resource res = OntNPAImpl.create(model, source).addProperty(OWL.assertionProperty, (RDFNode)property).addProperty(OWL.targetValue, (RDFNode)target);
        return model.getNodeAs(res.asNode(), OntNPA.DataAssertion.class);
    }

    public static OntNPA.ObjectAssertion create(OntGraphModelImpl model, OntIndividual source, OntOPE property, OntIndividual target) {
        Resource res = OntNPAImpl.create(model, source).addProperty(OWL.assertionProperty, (RDFNode)property).addProperty(OWL.targetIndividual, (RDFNode)target);
        return model.getNodeAs(res.asNode(), OntNPA.ObjectAssertion.class);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntNPAImpl.getRequiredRootStatement(this, OWL.NegativePropertyAssertion);
    }

    @Override
    public Stream<OntStatement> spec() {
        return Stream.concat(super.spec(), this.required(OWL.sourceIndividual, OWL.assertionProperty, this.targetPredicate()));
    }

    abstract Class<P> propertyClass();

    abstract Property targetPredicate();

    @Override
    public OntIndividual getSource() {
        return this.getRequiredObject(OWL.sourceIndividual, OntIndividual.class);
    }

    @Override
    public P getProperty() {
        return (P)((OntPE)this.getRequiredObject(OWL.assertionProperty, this.propertyClass()));
    }

    private static Resource create(OntGraphModel model, OntIndividual source) {
        Resource res = model.createResource();
        res.addProperty(RDF.type, (RDFNode)OWL.NegativePropertyAssertion);
        res.addProperty(OWL.sourceIndividual, (RDFNode)source);
        return res;
    }

    public static class DataAssertionImpl
    extends OntNPAImpl<OntNDP, Literal>
    implements OntNPA.DataAssertion {
        public DataAssertionImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        Class<OntNDP> propertyClass() {
            return OntNDP.class;
        }

        @Override
        Property targetPredicate() {
            return OWL.targetValue;
        }

        public Class<OntNPA.DataAssertion> getActualClass() {
            return OntNPA.DataAssertion.class;
        }

        @Override
        public Literal getTarget() {
            return this.getRequiredObject(this.targetPredicate(), Literal.class);
        }
    }

    public static class ObjectAssertionImpl
    extends OntNPAImpl<OntOPE, OntIndividual>
    implements OntNPA.ObjectAssertion {
        public ObjectAssertionImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        Class<OntOPE> propertyClass() {
            return OntOPE.class;
        }

        @Override
        Property targetPredicate() {
            return OWL.targetIndividual;
        }

        public Class<OntNPA.ObjectAssertion> getActualClass() {
            return OntNPA.ObjectAssertion.class;
        }

        @Override
        public OntIndividual getTarget() {
            return this.getRequiredObject(this.targetPredicate(), OntIndividual.class);
        }
    }
}

