/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.UnsupportedPolymorphismException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.OntAnnotationImpl;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntStatementImpl;
import ru.avicomp.ontapi.jena.impl.conf.CommonOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.Configurable;
import ru.avicomp.ontapi.jena.impl.conf.MultiOntObjectFactory;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntMaker;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public class OntObjectImpl
extends ResourceImpl
implements OntObject {
    public static OntObjectFactory objectFactory = new CommonOntObjectFactory(new OntMaker.Default(OntObjectImpl.class), OntFinder.ANY_SUBJECT, OntFilter.URI.or(OntFilter.BLANK), new OntFilter[0]);

    public OntObjectImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    protected static Optional<OntStatement> getRequiredRootStatement(OntObjectImpl subject, Resource type) throws OntJenaException.IllegalState {
        Optional<OntStatement> res = OntObjectImpl.getOptionalRootStatement(subject, type);
        if (!res.isPresent()) {
            throw new OntJenaException.IllegalState("Can't find " + subject.getModel().shortForm(type.getURI()) + " declaration for " + subject);
        }
        return res;
    }

    protected static Optional<OntStatement> getOptionalRootStatement(OntObjectImpl subject, Resource type) {
        if (!subject.hasProperty(RDF.type, (RDFNode)OntObjectImpl.checkNamed(type))) {
            return Optional.empty();
        }
        return Optional.of(subject.getModel().createStatement(subject, RDF.type, (RDFNode)type).asRootStatement());
    }

    static String viewAsString(Class<? extends RDFNode> view) {
        return view.getName().replace(OntObject.class.getPackage().getName() + ".", "");
    }

    public static Node checkNamed(Node res) {
        if (OntJenaException.notNull(res, "Null node").isURI()) {
            return res;
        }
        throw new OntJenaException("Not uri node " + res);
    }

    public static Resource checkNamed(Resource res) {
        if (OntJenaException.notNull(res, "Null resource").isURIResource()) {
            return res;
        }
        throw new OntJenaException("Not uri resource " + res);
    }

    protected static Configurable<OntObjectFactory> buildMultiFactory(OntFinder finder, OntFilter filter, Configurable<? extends OntObjectFactory> configurable, OntObjectFactory ... other) {
        return mode -> new MultiOntObjectFactory(finder, filter, (OntObjectFactory[])Stream.concat(Stream.of(configurable.get(mode)), Arrays.stream(other)).toArray(OntObjectFactory[]::new));
    }

    protected static Configurable<OntObjectFactory> concatFactories(OntFinder finder, Configurable<? extends OntObjectFactory> ... factories) {
        return mode -> new MultiOntObjectFactory(finder, null, (OntObjectFactory[])Stream.of(factories).map(c -> (OntObjectFactory)((Object)((Object)((Object)c.get(mode))))).toArray(OntObjectFactory[]::new));
    }

    public static boolean canAs(Class<? extends RDFNode> view, Node node, EnhGraph graph) {
        return ((OntGraphModelImpl)graph).fetchNodeAs(node, view) != null;
    }

    @Override
    public boolean isLocal() {
        return this.findRootStatement().map(OntStatement::isLocal).orElse(false);
    }

    @Override
    public final OntStatement getRoot() {
        return this.findRootStatement().orElse(null);
    }

    @Override
    public Stream<OntStatement> spec() {
        return this.findRootStatement().map(Stream::of).orElse(Stream.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<OntStatement> findRootStatement() {
        OntGraphModelImpl m = this.getModel();
        try (ExtendedIterator<RDFNode> res = this.listObjects(RDF.type);){
            Optional<OntStatement> optional = res.hasNext() ? Optional.of(res.next()).map(o -> m.createStatement(this, RDF.type, (RDFNode)o).asRootStatement()) : Optional.empty();
            return optional;
        }
    }

    @Override
    public Stream<OntStatement> content() {
        return Stream.concat(this.spec(), this.statements().filter(x -> !x.isAnnotation()).collect(Collectors.toSet()).stream()).distinct();
    }

    protected void changeRDFType(Resource type, boolean add) {
        if (add) {
            this.addRDFType(type);
        } else {
            this.removeRDFType(type);
        }
    }

    protected OntStatement addRDFType(Resource type) {
        return this.addStatement(RDF.type, (RDFNode)OntJenaException.notNull(type, "Null rdf:type"));
    }

    protected void removeRDFType(Resource type) {
        this.remove(RDF.type, (RDFNode)type);
    }

    @Override
    public Optional<OntStatement> statement(Property property) {
        try (Stream<OntStatement> res = this.statements(property);){
            Optional<OntStatement> optional = res.findFirst();
            return optional;
        }
    }

    @Override
    public Optional<OntStatement> statement(Property property, RDFNode value) {
        try (Stream<OntStatement> res = this.getModel().statements(this, property, value);){
            Optional<OntStatement> optional = res.findFirst();
            return optional;
        }
    }

    @Override
    public OntStatement getRequiredProperty(Property property) throws PropertyNotFoundException {
        return this.statement(property).orElseThrow(() -> new PropertyNotFoundException(property));
    }

    protected Stream<OntStatement> required(Property ... properties) {
        return Arrays.stream(properties).map(this::getRequiredProperty);
    }

    @Override
    public OntStatement addStatement(Property property, RDFNode value) {
        OntStatementImpl res = this.getModel().createStatement(this, OntJenaException.notNull(property, "Null property."), OntJenaException.notNull(value, "Null value."));
        this.getModel().add(res);
        return res;
    }

    @Override
    public OntObjectImpl remove(Property property, RDFNode value) {
        this.getModel().removeAll(this, OntJenaException.notNull(property, "Null property."), OntJenaException.notNull(value, "Null value."));
        return this;
    }

    @Override
    public Stream<OntStatement> statements(Property property) {
        return Iter.asStream(this.listStatements(property));
    }

    @Override
    public Stream<OntStatement> statements() {
        return Iter.asStream(this.listStatements());
    }

    public StmtIterator listProperties() {
        return this.listProperties(null);
    }

    public ExtendedIterator<OntStatement> listStatements() {
        return this.listStatements(null);
    }

    public StmtIterator listProperties(Property p) {
        return Iter.createStmtIterator((ExtendedIterator<Triple>)this.getModel().getGraph().find(this.asNode(), OntGraphModelImpl.asNode((RDFNode)p), Node.ANY), t -> this.createOntStatement(p, (Triple)t));
    }

    public ExtendedIterator<OntStatement> listStatements(Property p) {
        return WrappedIterator.create((Iterator)this.getModel().getGraph().find(this.asNode(), OntGraphModelImpl.asNode((RDFNode)p), Node.ANY).mapWith(t -> this.createOntStatement(p, (Triple)t)));
    }

    protected OntStatementImpl createOntStatement(Property p, Triple t) {
        OntGraphModelImpl m = this.getModel();
        Property property = p == null ? m.getNodeAs(t.getPredicate(), Property.class) : p;
        RDFNode object = m.getNodeAs(t.getObject(), RDFNode.class);
        return OntStatementImpl.createOntStatementImpl((Resource)this, property, object, this.getModel());
    }

    @Override
    public Stream<OntStatement> annotations() {
        return Iter.asStream(this.listAnnotations());
    }

    public ExtendedIterator<OntStatement> listAnnotations() {
        ExtendedIterator<OntStatement> res = this.listAssertions();
        Optional<OntStatement> main = this.findRootStatement();
        if (!main.isPresent()) {
            return res;
        }
        OntStatementImpl s = (OntStatementImpl)main.get();
        return res.andThen(Iter.flatMap(s.listAnnotationResources(), a -> ((OntAnnotationImpl)a).listAssertions()));
    }

    public Stream<OntStatement> assertions() {
        return Iter.asStream(this.listAssertions());
    }

    public ExtendedIterator<OntStatement> listAssertions() {
        return this.listStatements().filterKeep(OntStatement::isAnnotation);
    }

    @Override
    public OntStatement addAnnotation(OntNAP property, RDFNode value) {
        return this.findRootStatement().map(r -> r.addAnnotation(property, value)).orElseGet(() -> this.getModel().createStatement(this.addProperty(property, value), property, value));
    }

    @Override
    public OntObjectImpl clearAnnotations() {
        this.assertions().peek(OntStatement::clearAnnotations).collect(Collectors.toSet()).forEach(a -> this.getModel().remove((Statement)a));
        this.findRootStatement().ifPresent(OntStatement::clearAnnotations);
        return this;
    }

    public Literal asLiteral() throws UnsupportedPolymorphismException {
        return (Literal)this.as(Literal.class);
    }

    public void clearAll(Property predicate) {
        this.listProperties(predicate).mapWith(Statement::getObject).filterKeep(n -> n.canAs(RDFList.class)).mapWith(n -> (RDFList)n.as(RDFList.class)).forEachRemaining(RDFList::removeList);
        this.removeAll(predicate);
    }

    public <T extends RDFNode> T getRequiredObject(Property predicate, Class<T> view) {
        return (T)((RDFNode)this.object(predicate, view).orElseThrow(() -> new OntJenaException(String.format("Can't find required object [%s @%s %s]", this, predicate, OntObjectImpl.viewAsString(view)))));
    }

    public <T extends RDFNode> Optional<T> object(Property predicate, Class<T> type) {
        try (Stream<T> objects = this.objects(predicate, type);){
            Optional<T> optional = objects.findFirst();
            return optional;
        }
    }

    @Override
    public <O extends RDFNode> Stream<O> objects(Property predicate, Class<O> type) {
        return Iter.asStream(this.listObjects(predicate, type));
    }

    public <O extends RDFNode> ExtendedIterator<O> listObjects(Property predicate, Class<O> type) {
        OntGraphModelImpl m = this.getModel();
        return this.listProperties(predicate).mapWith(s -> m.findNodeAs(s.getObject().asNode(), type)).filterDrop(Objects::isNull);
    }

    public Stream<RDFNode> objects(Property predicate) {
        return Iter.asStream(this.listObjects(predicate));
    }

    public ExtendedIterator<RDFNode> listObjects(Property predicate) {
        return this.listProperties(predicate).mapWith(Statement::getObject);
    }

    @Override
    public OntGraphModelImpl getModel() {
        return (OntGraphModelImpl)super.getModel();
    }

    public Class<? extends OntObject> getActualClass() {
        return OntObjectImpl.findActualClass(this);
    }

    public static Class<? extends OntObject> findActualClass(OntObject o) {
        return Arrays.stream(o.getClass().getInterfaces()).filter(OntObject.class::isAssignableFrom).map(c -> c).findFirst().orElse(null);
    }

    public String toString() {
        Class<? extends OntObject> view = this.getActualClass();
        return view == null ? super.toString() : String.format("[%s]%s", OntObjectImpl.viewAsString(view), this.asNode());
    }
}

