/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.CachedStatementImpl;
import ru.avicomp.ontapi.jena.impl.OntAnnotationImpl;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.OntObjectImpl;
import ru.avicomp.ontapi.jena.model.OntAnnotation;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public class OntStatementImpl
extends StatementImpl
implements OntStatement {
    public OntStatementImpl(Statement statement) throws ClassCastException, NullPointerException {
        this(statement.getSubject(), statement.getPredicate(), statement.getObject(), (OntGraphModel)statement.getModel());
    }

    public OntStatementImpl(Resource subject, Property predicate, RDFNode object, OntGraphModel model) {
        super(subject, predicate, object, (ModelCom)model);
    }

    public static OntStatementImpl createOntStatementImpl(Triple t, OntGraphModelImpl m) {
        return OntStatementImpl.createOntStatementImpl((Resource)new OntObjectImpl(t.getSubject(), (EnhGraph)m), t.getPredicate(), t.getObject(), m);
    }

    public static OntStatementImpl createOntStatementImpl(Resource s, Node p, Node o, OntGraphModelImpl m) {
        return OntStatementImpl.createOntStatementImpl(s, (Property)new PropertyImpl(p, (EnhGraph)m), o, m);
    }

    public static OntStatementImpl createOntStatementImpl(Resource s, Property p, Node o, OntGraphModelImpl m) {
        return OntStatementImpl.createOntStatementImpl(s, p, OntStatementImpl.createObject((Node)o, (EnhGraph)m), m);
    }

    public static OntStatementImpl createOntStatementImpl(Resource s, Property p, RDFNode o, OntGraphModelImpl m) {
        return new OntStatementImpl(s, p, o, m);
    }

    public static CachedStatementImpl createCachedOntStatementImpl(OntStatement delegate) {
        return delegate instanceof CachedStatementImpl ? (CachedStatementImpl)delegate : new CachedStatementImpl(delegate);
    }

    public static OntStatementImpl createNotAnnotatedOntStatementImpl(Resource s, Property p, RDFNode o, final OntGraphModelImpl m) {
        return new OntStatementImpl(s, p, o, m){

            @Override
            public OntStatement addAnnotation(OntNAP property, RDFNode value) {
                throw new OntJenaException.Unsupported("Sub-annotations are not supported (attempt to annotate " + Models.toString(this) + " with predicate " + m.shortForm(property.getURI()) + " and value " + value + ")");
            }
        };
    }

    @Override
    public OntGraphModelImpl getModel() {
        return (OntGraphModelImpl)super.getModel();
    }

    @Override
    public boolean isRoot() {
        return this.isRootStatement();
    }

    public boolean isRootStatement() {
        return false;
    }

    public OntStatement asRootStatement() {
        return this.isRootStatement() ? this : new OntStatementImpl(this.getSubject(), this.getPredicate(), this.getObject(), this.getModel()){

            @Override
            public boolean isRootStatement() {
                return true;
            }
        };
    }

    @Override
    public boolean isLocal() {
        return !this.getModel().getGraph().getUnderlying().hasSubGraphs() || this.getModel().isLocal(this);
    }

    public boolean isAnnotationRootStatement() {
        return this.subject.isAnon() && RDF.type.equals(this.predicate) && (OWL.Axiom.equals((Object)this.object) || OWL.Annotation.equals((Object)this.object));
    }

    @Override
    public OntObject getSubject() {
        return this.subject instanceof OntObject ? (OntObject)this.subject : (OntObject)this.subject.as(OntObject.class);
    }

    public Node getSubjectNode() {
        return this.subject.asNode();
    }

    @Override
    public <N extends RDFNode> N getSubject(Class<N> type) {
        return (N)this.subject.as(type);
    }

    @Override
    public boolean isBulkAnnotation() {
        return this.subject.isAnon() && this.getModel().findNodeAs(this.subject.asNode(), OntAnnotation.class) != null;
    }

    @Override
    public OntStatement addAnnotation(OntNAP property, RDFNode value) {
        OntJenaException.notNull(property, "Null property.");
        OntJenaException.notNull(value, "Null value.");
        if (this.isRootStatement()) {
            this.model.add((Resource)this.getSubject(), (Property)OntJenaException.notNull(property, "Null property."), OntJenaException.notNull(value, "Null value."));
            return this.getModel().createStatement(this.getSubject(), property, value);
        }
        return this.asAnnotationResource().orElseGet(() -> OntAnnotationImpl.createAnnotation(this.getModel(), this, this.getAnnotationResourceType())).addAnnotation(property, value);
    }

    @Override
    public Stream<OntStatement> annotations() {
        return Iter.asStream(this.listAnnotations());
    }

    @Override
    public boolean hasAnnotations() {
        try (ExtendedIterator<OntStatement> res = this.listAnnotations();){
            boolean bl = res.hasNext();
            return bl;
        }
    }

    public ExtendedIterator<OntStatement> listAnnotations() {
        ExtendedIterator res = Iter.flatMap(this.listAnnotationResources(), a -> ((OntAnnotationImpl)a).listAssertions());
        if (this.isRootStatement()) {
            return this.listSubjectAssertions().andThen(res);
        }
        return res;
    }

    protected ExtendedIterator<OntStatement> listSubjectAssertions() {
        return ((OntObjectImpl)this.getSubject()).listAssertions();
    }

    @Override
    public OntStatementImpl deleteAnnotation(OntNAP property, RDFNode value) {
        Set candidates;
        OntJenaException.notNull(property, "Null property.");
        OntJenaException.notNull(value, "Null value.");
        OntGraphModelImpl model = this.getModel();
        if (this.isRootStatement()) {
            Set<OntStatement> assertions = model.statements(this.getSubject(), property, value).collect(Collectors.toSet());
            if (this.isAnnotationRootStatement()) {
                throw new OntJenaException("Direct removing assertions from Annotation resource is prohibited");
            }
            assertions.forEach(arg_0 -> ((OntGraphModelImpl)model).remove(arg_0));
        }
        if ((candidates = this.annotationResources().flatMap(OntAnnotation::assertions).filter(s -> Objects.equals(property, s.getPredicate())).filter(s -> Objects.equals(value, s.getObject())).collect(Collectors.toSet())).isEmpty()) {
            return this;
        }
        Set<OntStatement> delete = candidates.stream().filter(s -> !s.hasAnnotations()).collect(Collectors.toSet());
        if (delete.isEmpty()) {
            throw new OntJenaException("Can't delete [*, " + property + ", " + value + "]: candidates have their own annotations which should be deleted first.");
        }
        delete.forEach(arg_0 -> ((OntGraphModelImpl)model).remove(arg_0));
        Set<OntAnnotation> empty = this.annotationResources().filter(f -> Objects.equals(f.listProperties().toSet().size(), OntAnnotationImpl.SPEC.size())).collect(Collectors.toSet());
        empty.forEach(a -> {
            model.removeAll((Resource)a, null, null);
            model.getNodeCache().remove((Object)a.asNode());
        });
        return this;
    }

    @Override
    public Stream<OntAnnotation> annotationResources() {
        return Iter.asStream(this.listAnnotationResources());
    }

    public ExtendedIterator<OntAnnotation> listAnnotationResources() {
        return OntStatementImpl.listAnnotationResources(this.getModel(), this.getAnnotationResourceType(), this).mapWith(this::wrapAsOntAnnotation);
    }

    @Override
    public List<OntAnnotation> getAnnotationList() {
        List<OntAnnotation> res = this.getAnnotationResourcesAsList();
        res.sort(OntAnnotationImpl.DEFAULT_ANNOTATION_COMPARATOR);
        return res;
    }

    protected List<OntAnnotation> getAnnotationResourcesAsList() {
        return this.listAnnotationResources().toList();
    }

    protected Resource getAnnotationResourceType() {
        return OntStatementImpl.detectAnnotationRootType(this.subject);
    }

    public static ExtendedIterator<Resource> listAnnotationResources(Model m, Resource t, Statement s) {
        return OntStatementImpl.listAnnotationResources(m, t, s.getSubject(), s.getPredicate(), s.getObject());
    }

    public static ExtendedIterator<Resource> listAnnotationResources(Model m, Resource t, Resource s, Property p, RDFNode o) {
        return m.listStatements(null, OWL.annotatedSource, (RDFNode)s).filterKeep(x -> OntStatementImpl.hasSpecProperties(x, t, p, o)).mapWith(Statement::getSubject);
    }

    private static boolean hasSpecProperties(Statement s, Resource t, Property p, RDFNode o) {
        Resource r = s.getSubject();
        return r.hasProperty(RDF.type, (RDFNode)t) && r.hasProperty(OWL.annotatedProperty, (RDFNode)p) && r.hasProperty(OWL.annotatedTarget, o);
    }

    protected static Resource detectAnnotationRootType(Resource s) {
        Model m = s.getModel();
        if (s.isAnon() && OntAnnotationImpl.ROOT_TYPES.stream().anyMatch(t -> m.contains(s, RDF.type, (RDFNode)t))) {
            return OWL.Annotation;
        }
        return OWL.Axiom;
    }

    public ExtendedIterator<OntStatement> listSplitStatements() {
        List<OntAnnotation> res = this.getAnnotationList();
        if (res.size() < 2) {
            return Iter.of(this);
        }
        if (this.isRootStatement()) {
            OntStatementImpl first = this.createRootStatement(res.remove(0));
            return Iter.of(first).andThen((Iterator)WrappedIterator.create(res.iterator()).mapWith(OntAnnotation::getBase));
        }
        return WrappedIterator.create(res.iterator()).mapWith(OntAnnotation::getBase);
    }

    protected OntStatementImpl createRootStatement(final OntAnnotation resource) {
        return new OntStatementImpl(this){

            @Override
            public boolean isRootStatement() {
                return true;
            }

            @Override
            public List<OntAnnotation> getAnnotationList() {
                return Collections.singletonList(resource);
            }

            @Override
            public ExtendedIterator<OntAnnotation> listAnnotationResources() {
                return Iter.of(resource);
            }
        };
    }

    protected OntStatementImpl createBaseStatement(final OntAnnotationImpl resource) {
        return new OntStatementImpl(this){

            @Override
            public ExtendedIterator<OntStatement> listAnnotations() {
                return resource.listAssertions();
            }

            @Override
            public List<OntAnnotation> getAnnotationList() {
                return Collections.singletonList(resource);
            }

            @Override
            public ExtendedIterator<OntAnnotation> listAnnotationResources() {
                return Iter.of(resource);
            }
        };
    }

    protected OntAnnotationImpl wrapAsOntAnnotation(Resource annotation) {
        return new OntAnnotationImpl(annotation.asNode(), (EnhGraph)this.getModel()){

            @Override
            public OntStatement getBase() {
                return OntStatementImpl.this.createBaseStatement(this);
            }
        };
    }
}

