/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl.conf;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.impl.conf.OntFinder;
import ru.avicomp.ontapi.jena.impl.conf.OntObjectFactory;

public class MultiOntObjectFactory
extends OntObjectFactory {
    private final List<OntObjectFactory> factories;
    private OntFinder finder;
    private OntFilter fittingFilter;

    public MultiOntObjectFactory(OntFinder finder, OntFilter fittingFilter, OntObjectFactory ... factories) {
        this.finder = finder;
        this.fittingFilter = fittingFilter;
        this.factories = MultiOntObjectFactory.unbend(factories);
    }

    private static List<OntObjectFactory> unbend(OntObjectFactory ... factories) {
        return Arrays.stream(factories).map(f -> f instanceof MultiOntObjectFactory ? ((MultiOntObjectFactory)((Object)f)).factories() : Stream.of(f)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    @Override
    public EnhNode wrap(Node node, EnhGraph eg) {
        EnhNode res = this.doWrap(node, eg);
        if (res != null) {
            return res;
        }
        throw new ConversionException("Can't wrap node " + node + ". Use direct factory.");
    }

    @Override
    public boolean canWrap(Node node, EnhGraph eg) {
        return (this.fittingFilter == null || this.fittingFilter.test(node, eg)) && this.factories().anyMatch(f -> f.canWrap(node, eg));
    }

    @Override
    protected EnhNode doWrap(Node node, EnhGraph eg) {
        if (this.fittingFilter != null && !this.fittingFilter.test(node, eg)) {
            return null;
        }
        return this.factories().filter(f -> f.canWrap(node, eg)).map(f -> f.doWrap(node, eg)).findFirst().orElse(null);
    }

    @Override
    public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
        if (this.finder != null) {
            return this.finder.iterator(eg).mapWith(n -> this.doWrap((Node)n, eg)).filterDrop(Objects::isNull);
        }
        return WrappedIterator.create(this.factories().flatMap(f -> f.find(eg)).distinct().iterator());
    }

    public OntFinder getFinder() {
        return this.finder;
    }

    public OntFilter getFilter() {
        return this.fittingFilter;
    }

    public Stream<? extends OntObjectFactory> factories() {
        return this.factories.stream();
    }
}

