/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl.conf;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.RDF;
import ru.avicomp.ontapi.jena.utils.Iter;

@FunctionalInterface
public interface OntFilter {
    public static final OntFilter TRUE = (n, g) -> true;
    public static final OntFilter FALSE = (n, g) -> false;
    public static final OntFilter URI = (n, g) -> n.isURI();
    public static final OntFilter BLANK = (n, g) -> n.isBlank();

    public boolean test(Node var1, EnhGraph var2);

    default public OntFilter and(OntFilter other) {
        if (Objects.requireNonNull(other, "Null and-filter.").equals(TRUE)) {
            return this;
        }
        if (this.equals(TRUE)) {
            return other;
        }
        if (other.equals(FALSE)) {
            return FALSE;
        }
        if (this.equals(FALSE)) {
            return FALSE;
        }
        return (n, g) -> this.test(n, g) && other.test(n, g);
    }

    default public OntFilter or(OntFilter other) {
        if (Objects.requireNonNull(other, "Null or-filter.").equals(TRUE)) {
            return TRUE;
        }
        if (this.equals(TRUE)) {
            return TRUE;
        }
        if (other.equals(FALSE)) {
            return this;
        }
        if (this.equals(FALSE)) {
            return other;
        }
        return (n, g) -> this.test(n, g) || other.test(n, g);
    }

    default public OntFilter negate() {
        if (this.equals(TRUE)) {
            return FALSE;
        }
        if (this.equals(FALSE)) {
            return TRUE;
        }
        return (n, g) -> !this.test(n, g);
    }

    default public OntFilter accumulate(OntFilter ... filters) {
        OntFilter res = this;
        for (OntFilter o : filters) {
            res = res.and(o);
        }
        return res;
    }

    public static class OneOf
    implements OntFilter {
        protected final Set<Node> nodes;

        public OneOf(Collection<? extends RDFNode> types) {
            this.nodes = Objects.requireNonNull(types).stream().map(FrontsNode::asNode).collect(Iter.toUnmodifiableSet());
        }

        @Override
        public boolean test(Node n, EnhGraph g) {
            return this.nodes.contains(n);
        }

        public boolean equals(Object o) {
            if (this.nodes.isEmpty() && FALSE == o) {
                return true;
            }
            return super.equals(o);
        }
    }

    public static class HasType
    implements OntFilter {
        protected final Node type;

        public HasType(Resource type) {
            this.type = Objects.requireNonNull(type, "Null type.").asNode();
        }

        @Override
        public boolean test(Node node, EnhGraph eg) {
            return eg.asGraph().contains(node, RDF.Nodes.type, this.type);
        }
    }

    public static class HasPredicate
    implements OntFilter {
        protected final Node predicate;

        public HasPredicate(Property predicate) {
            this.predicate = Objects.requireNonNull(predicate, "Null predicate.").asNode();
        }

        @Override
        public boolean test(Node n, EnhGraph g) {
            return g.asGraph().contains(n, this.predicate, Node.ANY);
        }
    }
}

