/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.impl.conf;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.vocabulary.RDF;
import ru.avicomp.ontapi.jena.impl.conf.OntFilter;
import ru.avicomp.ontapi.jena.utils.Graphs;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

@FunctionalInterface
public interface OntFinder {
    public static final OntFinder ANY_SUBJECT = eg -> Graphs.subjects(eg.asGraph());
    public static final OntFinder ANY_SUBJECT_AND_OBJECT = eg -> Graphs.subjectsAndObjects(eg.asGraph());
    public static final OntFinder ANYTHING = eg -> Graphs.all(eg.asGraph());
    public static final OntFinder TYPED = new ByPredicate(RDF.type);

    public ExtendedIterator<Node> iterator(EnhGraph var1);

    default public Stream<Node> find(EnhGraph eg) {
        return Iter.asStream(this.iterator(eg));
    }

    default public OntFinder restrict(OntFilter filter) {
        if (Objects.requireNonNull(filter, "Null restriction filter.").equals(OntFilter.TRUE)) {
            return this;
        }
        if (filter.equals(OntFilter.FALSE)) {
            return eg -> NullIterator.instance();
        }
        return eg -> this.iterator(eg).filterKeep(n -> filter.test((Node)n, eg));
    }

    public static class ByPredicate
    implements OntFinder {
        protected final Node predicate;

        public ByPredicate(Property predicate) {
            this.predicate = Objects.requireNonNull(predicate, "Null predicate.").asNode();
        }

        @Override
        public ExtendedIterator<Node> iterator(EnhGraph eg) {
            return Iter.distinct(eg.asGraph().find(Node.ANY, this.predicate, Node.ANY).mapWith(Triple::getSubject));
        }
    }

    public static class ByType
    implements OntFinder {
        protected final Node type;

        public ByType(Resource type) {
            this.type = Objects.requireNonNull(type, "Null type.").asNode();
        }

        @Override
        public ExtendedIterator<Node> iterator(EnhGraph eg) {
            return eg.asGraph().find(Node.ANY, RDF.Nodes.type, this.type).mapWith(Triple::getSubject);
        }
    }
}

