/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.vocabulary.RDFS;
import ru.avicomp.ontapi.jena.model.OntDOP;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntPE;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public interface OntCE
extends OntObject {
    public OntIndividual.Anonymous createIndividual();

    public OntIndividual.Named createIndividual(String var1);

    default public Stream<OntIndividual> individuals() {
        return this.getModel().statements(null, RDF.type, (RDFNode)this).map(OntStatement::getSubject).map(s -> (OntIndividual)s.as(OntIndividual.class));
    }

    default public Stream<OntPE> properties() {
        return this.getModel().statements(null, RDFS.domain, (RDFNode)this).map(OntStatement::getSubject).filter(s -> s.canAs(OntPE.class)).map(s -> (OntPE)s.as(OntPE.class));
    }

    default public Stream<OntCE> subClassOf() {
        return this.objects(RDFS.subClassOf, OntCE.class);
    }

    default public OntStatement addSubClassOf(OntCE superClass) {
        return this.addStatement(RDFS.subClassOf, (RDFNode)superClass);
    }

    default public void removeSubClassOf(OntCE superClass) {
        this.remove(RDFS.subClassOf, (RDFNode)superClass);
    }

    default public Stream<OntCE> disjointWith() {
        return this.objects(OWL.disjointWith, OntCE.class);
    }

    default public OntStatement addDisjointWith(OntCE other) {
        return this.addStatement(OWL.disjointWith, (RDFNode)other);
    }

    default public void removeDisjointWith(OntCE other) {
        this.remove(OWL.disjointWith, (RDFNode)other);
    }

    default public Stream<OntCE> equivalentClass() {
        return this.objects(OWL.equivalentClass, OntCE.class);
    }

    default public OntStatement addEquivalentClass(OntCE other) {
        return this.addStatement(OWL.equivalentClass, (RDFNode)other);
    }

    default public void removeEquivalentClass(OntCE other) {
        this.remove(OWL.equivalentClass, (RDFNode)other);
    }

    public OntList<OntDOP> createHasKey(Collection<OntOPE> var1, Collection<OntNDP> var2);

    public OntStatement addHasKey(OntDOP ... var1);

    public Optional<OntList<OntDOP>> findHasKey(RDFNode var1);

    public Stream<OntList<OntDOP>> listHasKeys();

    public void removeHasKey(RDFNode var1);

    @Deprecated
    default public Stream<OntPE> hasKey() {
        return this.listHasKeys().flatMap(OntList::members);
    }

    @Deprecated
    default public OntStatement addHasKey(Collection<OntOPE> objectProperties, Collection<OntNDP> dataProperties) {
        return this.createHasKey(objectProperties, dataProperties).getRoot();
    }

    default public void clearHasKeys() {
        this.listHasKeys().collect(Collectors.toSet()).forEach(this::removeHasKey);
    }

    @Deprecated
    public void removeHasKey();

    public static interface Cardinality {
        public int getCardinality();

        public void setCardinality(int var1);

        public boolean isQualified();
    }

    public static interface Value<O extends RDFNode> {
        public O getValue();

        public void setValue(O var1);
    }

    public static interface Components<O extends OntObject> {
        public OntList<O> getList();

        default public Stream<O> components() {
            return this.getList().members();
        }

        default public void setComponents(Collection<O> components) {
            this.getList().clear().addAll(components);
        }
    }

    public static interface ONProperties<P extends OntPE> {
        public OntList<P> getList();

        default public Stream<P> onProperties() {
            return this.getList().members();
        }

        default public void setOnProperties(Collection<P> properties) {
            this.getList().clear().addAll(properties);
        }
    }

    public static interface ONProperty<P extends OntDOP> {
        public P getOnProperty();

        public void setOnProperty(P var1);
    }

    public static interface RestrictionCE
    extends OntCE {
    }

    public static interface NaryRestrictionCE<O extends OntObject, P extends OntDOP>
    extends RestrictionCE,
    ONProperties<P>,
    Value<O> {
    }

    public static interface ComponentRestrictionCE<O extends RDFNode, P extends OntDOP>
    extends RestrictionCE,
    ONProperty<P>,
    Value<O> {
    }

    public static interface CardinalityRestrictionCE<O extends OntObject, P extends OntDOP>
    extends Cardinality,
    ComponentRestrictionCE<O, P> {
    }

    public static interface ComponentsCE<O extends OntObject>
    extends OntCE,
    Components<O> {
    }

    public static interface NaryDataSomeValuesFrom
    extends NaryRestrictionCE<OntDR, OntNDP> {
    }

    public static interface NaryDataAllValuesFrom
    extends NaryRestrictionCE<OntDR, OntNDP> {
    }

    public static interface ComplementOf
    extends OntCE,
    Value<OntCE> {
    }

    public static interface IntersectionOf
    extends ComponentsCE<OntCE> {
    }

    public static interface OneOf
    extends ComponentsCE<OntIndividual> {
    }

    public static interface UnionOf
    extends ComponentsCE<OntCE> {
    }

    public static interface HasSelf
    extends RestrictionCE,
    ONProperty<OntOPE> {
    }

    public static interface DataCardinality
    extends CardinalityRestrictionCE<OntDR, OntNDP> {
    }

    public static interface ObjectCardinality
    extends CardinalityRestrictionCE<OntCE, OntOPE> {
    }

    public static interface DataMaxCardinality
    extends CardinalityRestrictionCE<OntDR, OntNDP> {
    }

    public static interface ObjectMaxCardinality
    extends CardinalityRestrictionCE<OntCE, OntOPE> {
    }

    public static interface DataMinCardinality
    extends CardinalityRestrictionCE<OntDR, OntNDP> {
    }

    public static interface ObjectMinCardinality
    extends CardinalityRestrictionCE<OntCE, OntOPE> {
    }

    public static interface DataHasValue
    extends ComponentRestrictionCE<Literal, OntNDP> {
    }

    public static interface ObjectHasValue
    extends ComponentRestrictionCE<OntIndividual, OntOPE> {
    }

    public static interface DataAllValuesFrom
    extends ComponentRestrictionCE<OntDR, OntNDP> {
    }

    public static interface ObjectAllValuesFrom
    extends ComponentRestrictionCE<OntCE, OntOPE> {
    }

    public static interface DataSomeValuesFrom
    extends ComponentRestrictionCE<OntDR, OntNDP> {
    }

    public static interface ObjectSomeValuesFrom
    extends ComponentRestrictionCE<OntCE, OntOPE> {
    }
}

