/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntResource;
import ru.avicomp.ontapi.jena.model.OntStatement;

public interface OntList<E extends RDFNode>
extends OntResource {
    public boolean isEmpty();

    public Stream<E> members();

    public OntList<E> addLast(E var1);

    public OntList<E> removeLast();

    public OntList<E> addFirst(E var1);

    public OntList<E> removeFirst();

    public OntList<E> clear();

    public OntList<E> get(int var1) throws OntJenaException;

    public Optional<Resource> type();

    public Stream<OntStatement> spec();

    default public Stream<OntStatement> content() {
        return Stream.concat(Stream.of(this.getRoot()), this.spec());
    }

    default public int size() {
        return ((RDFList)this.as(RDFList.class)).size();
    }

    default public OntList<E> add(E e) {
        return this.addLast(e);
    }

    default public OntList<E> remove() {
        return this.removeLast();
    }

    default public Optional<E> first() {
        return this.members().findFirst();
    }

    default public Optional<E> last() {
        return this.members().reduce((f, s) -> s);
    }

    default public OntList<E> addAll(Collection<? extends E> c) {
        c.forEach(this::add);
        return this;
    }

    @Override
    default public boolean isLocal() {
        return this.getRoot().isLocal();
    }

    @Override
    default public OntStatement addAnnotation(OntNAP property, RDFNode value) {
        return this.getRoot().addAnnotation(property, value);
    }

    @Override
    default public OntList<E> clearAnnotations() {
        this.getRoot().clearAnnotations();
        return this;
    }
}

