/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.stream.Stream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.vocabulary.RDFS;
import ru.avicomp.ontapi.jena.model.OntDOP;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNPA;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public interface OntNDP
extends OntDOP,
OntEntity,
Property {
    public OntNPA.DataAssertion addNegativeAssertion(OntIndividual var1, Literal var2);

    default public Stream<OntNPA.DataAssertion> negativeAssertions() {
        return this.getModel().ontObjects(OntNPA.DataAssertion.class).filter(a -> this.equals(a.getProperty()));
    }

    default public Stream<OntNPA.DataAssertion> negativeAssertions(OntIndividual source) {
        return this.negativeAssertions().filter(a -> a.getSource().equals(source));
    }

    default public Stream<OntDR> range() {
        return this.objects(RDFS.range, OntDR.class);
    }

    default public OntStatement addRange(OntDR range) {
        return this.addStatement(RDFS.range, (RDFNode)range);
    }

    default public Stream<OntNDP> subPropertyOf() {
        return this.objects(RDFS.subPropertyOf, OntNDP.class);
    }

    default public OntStatement addSubPropertyOf(OntNDP superProperty) {
        return this.addStatement(RDFS.subPropertyOf, (RDFNode)superProperty);
    }

    default public Stream<OntNDP> disjointWith() {
        return this.objects(OWL.propertyDisjointWith, OntNDP.class);
    }

    default public OntStatement addDisjointWith(OntNDP other) {
        return this.addStatement(OWL.propertyDisjointWith, (RDFNode)other);
    }

    default public void removeDisjointWith(OntNDP other) {
        this.remove(OWL.propertyDisjointWith, (RDFNode)other);
    }

    default public Stream<OntNDP> equivalentProperty() {
        return this.objects(OWL.equivalentProperty, OntNDP.class);
    }

    default public OntStatement addEquivalentProperty(OntNDP other) {
        return this.addStatement(OWL.equivalentProperty, (RDFNode)other);
    }

    default public void removeEquivalentProperty(OntNDP other) {
        this.remove(OWL.equivalentProperty, (RDFNode)other);
    }

    default public boolean isProperty() {
        return true;
    }

    default public int getOrdinal() {
        return ((Property)this.as(Property.class)).getOrdinal();
    }
}

