/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.model;

import java.util.stream.Stream;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntList;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;

public interface OntSWRL
extends OntObject {

    public static interface Atom<P extends RDFNode>
    extends OntSWRL {
        public P getPredicate();

        public static interface Unary<P extends Resource, A extends Arg>
        extends Atom<P> {
            public A getArg();
        }

        public static interface Binary<P extends Resource, F extends Arg, S extends Arg>
        extends Atom<P> {
            public F getFirstArg();

            public S getSecondArg();
        }

        public static interface SameIndividuals
        extends Binary<Property, IArg, IArg> {
        }

        public static interface DifferentIndividuals
        extends Binary<Property, IArg, IArg> {
        }

        public static interface ObjectProperty
        extends Binary<OntOPE, IArg, IArg> {
        }

        public static interface DataProperty
        extends Binary<OntNDP, IArg, DArg> {
        }

        public static interface DataRange
        extends Unary<OntDR, DArg> {
        }

        public static interface OntClass
        extends Unary<OntCE, IArg> {
        }

        public static interface BuiltIn
        extends Atom<Resource> {
            public OntList<DArg> getArgList();

            default public Stream<DArg> arguments() {
                return this.getArgList().members();
            }
        }
    }

    public static interface IArg
    extends Arg {
    }

    public static interface DArg
    extends Arg {
    }

    public static interface Arg
    extends OntObject {
    }

    public static interface Variable
    extends OntSWRL {
    }

    public static interface Imp
    extends OntSWRL {
        public OntList<Atom> getHeadList();

        public OntList<Atom> getBodyList();

        default public Stream<Atom> head() {
            return this.getHeadList().members().distinct();
        }

        default public Stream<Atom> body() {
            return this.getBodyList().members().distinct();
        }
    }
}

