/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;
import ru.avicomp.ontapi.jena.vocabulary.SWRL;
import ru.avicomp.ontapi.jena.vocabulary.XSD;

public class BuiltIn {
    public static final Vocabulary DUMMY = new Empty();
    public static final Vocabulary OWL_VOCABULARY = new OWLVocabulary();
    public static final Vocabulary DC_VOCABULARY = new DCVocabulary();
    public static final Vocabulary SKOS_VOCABULARY = new SKOSVocabulary();
    public static final Vocabulary OWL_SKOS_DC_VOCABULARY;
    protected static Vocabulary defaultVocabulary;

    public static Vocabulary get() {
        return defaultVocabulary;
    }

    public static Vocabulary set(Vocabulary vocabulary) {
        Vocabulary prev = BuiltIn.get();
        defaultVocabulary = OntJenaException.notNull(vocabulary, "Null vocabulary specified.");
        return prev;
    }

    private static Stream<Field> directFields(Class vocabulary, Class<?> type) {
        return Arrays.stream(vocabulary.getDeclaredFields()).filter(field -> Modifier.isPublic(field.getModifiers())).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> type.equals(field.getType()));
    }

    private static Stream<Field> fields(Class vocabulary, Class<?> type) {
        Stream<Field> res = BuiltIn.directFields(vocabulary, type);
        return vocabulary.getSuperclass() != null ? Stream.concat(res, BuiltIn.fields(vocabulary.getSuperclass(), type)) : res;
    }

    private static <T> Stream<T> constants(Class vocabulary, Class<T> type) {
        return BuiltIn.fields(vocabulary, type).map(field -> BuiltIn.getValue(field, type)).filter(Objects::nonNull);
    }

    private static <T> T getValue(Field field, Class<T> type) {
        try {
            return type.cast(field.get(null));
        }
        catch (IllegalAccessException e) {
            throw new OntJenaException(e);
        }
    }

    protected static <T> Set<T> getConstants(Class<T> type, Class ... vocabularies) {
        return Arrays.stream(vocabularies).map(voc -> BuiltIn.constants(voc, type)).flatMap(Function.identity()).collect(Collectors.toSet());
    }

    static {
        defaultVocabulary = OWL_SKOS_DC_VOCABULARY = MultiVocabulary.create(OWL_VOCABULARY, DC_VOCABULARY, SKOS_VOCABULARY);
    }

    public static class MultiVocabulary
    implements Vocabulary {
        protected final List<Vocabulary> vocabularies;
        private Set<Property> annotationProperties;
        private Set<Property> datatypeProperties;
        private Set<Property> objectProperties;
        private Set<Resource> datatypes;
        private Set<Resource> classes;
        private Set<Resource> reservedResources;
        private Set<Property> reservedProperties;

        protected MultiVocabulary(List<Vocabulary> vocabularies) {
            this.vocabularies = vocabularies;
        }

        public static MultiVocabulary create(Vocabulary ... vocabularies) {
            List<Vocabulary> res = Stream.of(vocabularies).distinct().collect(Collectors.toList());
            if (res.isEmpty()) {
                throw new OntJenaException("Empty list specified");
            }
            return new MultiVocabulary(res);
        }

        protected <R extends Resource> Set<R> merge(Function<Vocabulary, Set<R>> map) {
            return this.vocabularies.stream().map(map).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        @Override
        public Set<Property> annotationProperties() {
            return this.annotationProperties == null ? (this.annotationProperties = this.merge(Vocabulary::annotationProperties)) : this.annotationProperties;
        }

        @Override
        public Set<Property> datatypeProperties() {
            return this.datatypeProperties == null ? (this.datatypeProperties = this.merge(Vocabulary::datatypeProperties)) : this.datatypeProperties;
        }

        @Override
        public Set<Property> objectProperties() {
            return this.objectProperties == null ? (this.objectProperties = this.merge(Vocabulary::objectProperties)) : this.objectProperties;
        }

        @Override
        public Set<Resource> datatypes() {
            return this.datatypes == null ? (this.datatypes = this.merge(Vocabulary::datatypes)) : this.datatypes;
        }

        @Override
        public Set<Resource> classes() {
            return this.classes == null ? (this.classes = this.merge(Vocabulary::classes)) : this.classes;
        }

        @Override
        public Set<Resource> reservedResources() {
            return this.reservedResources == null ? (this.reservedResources = this.merge(Vocabulary::reservedResources)) : this.reservedResources;
        }

        @Override
        public Set<Property> reservedProperties() {
            return this.reservedProperties == null ? (this.reservedProperties = this.merge(Vocabulary::reservedProperties)) : this.reservedProperties;
        }
    }

    public static class SKOSVocabulary
    implements Vocabulary {
        public static final Set<Property> ANNOTATION_PROPERTIES = Stream.of(SKOS.altLabel, SKOS.changeNote, SKOS.definition, SKOS.editorialNote, SKOS.example, SKOS.hiddenLabel, SKOS.historyNote, SKOS.note, SKOS.prefLabel, SKOS.scopeNote).collect(Iter.toUnmodifiableSet());
        public static final Set<Property> OBJECT_PROPERTIES = Stream.of(SKOS.broadMatch, SKOS.broader, SKOS.broaderTransitive, SKOS.closeMatch, SKOS.exactMatch, SKOS.hasTopConcept, SKOS.inScheme, SKOS.mappingRelation, SKOS.member, SKOS.memberList, SKOS.narrowMatch, SKOS.narrower, SKOS.narrowerTransitive, SKOS.related, SKOS.relatedMatch, SKOS.semanticRelation, SKOS.topConceptOf).collect(Iter.toUnmodifiableSet());
        public static final Set<Resource> CLASSES = Stream.of(SKOS.Collection, SKOS.Concept, SKOS.ConceptScheme, SKOS.OrderedCollection).collect(Iter.toUnmodifiableSet());

        @Override
        public Set<Property> annotationProperties() {
            return ANNOTATION_PROPERTIES;
        }

        @Override
        public Set<Property> datatypeProperties() {
            return Collections.emptySet();
        }

        @Override
        public Set<Property> objectProperties() {
            return OBJECT_PROPERTIES;
        }

        @Override
        public Set<Resource> datatypes() {
            return Collections.emptySet();
        }

        @Override
        public Set<Resource> classes() {
            return CLASSES;
        }

        @Override
        public Set<Resource> reservedResources() {
            return BuiltIn.getConstants(Resource.class, SKOS.class);
        }

        @Override
        public Set<Property> reservedProperties() {
            return BuiltIn.getConstants(Property.class, SKOS.class);
        }
    }

    public static class Empty
    implements Vocabulary {
        @Override
        public Set<Property> annotationProperties() {
            return Collections.emptySet();
        }

        @Override
        public Set<Property> datatypeProperties() {
            return Collections.emptySet();
        }

        @Override
        public Set<Property> objectProperties() {
            return Collections.emptySet();
        }

        @Override
        public Set<Resource> datatypes() {
            return Collections.emptySet();
        }

        @Override
        public Set<Resource> classes() {
            return Collections.emptySet();
        }

        @Override
        public Set<Resource> reservedResources() {
            return Collections.emptySet();
        }

        @Override
        public Set<Property> reservedProperties() {
            return Collections.emptySet();
        }
    }

    public static class DCVocabulary
    extends Empty {
        @Override
        public Set<Property> annotationProperties() {
            return this.reservedProperties();
        }

        @Override
        public Set<Property> reservedProperties() {
            return BuiltIn.getConstants(Property.class, DC.class);
        }
    }

    public static class OWLVocabulary
    implements Vocabulary {
        public static final Set<Property> ALL_PROPERTIES = BuiltIn.getConstants(Property.class, XSD.class, RDF.class, RDFS.class, OWL.class, SWRL.class);
        public static final Set<Resource> ALL_RESOURCES = BuiltIn.getConstants(Resource.class, XSD.class, RDF.class, RDFS.class, OWL.class, SWRL.class);
        public static final Set<Resource> OWL2_DATATYPES = Stream.of(RDF.xmlLiteral, RDF.PlainLiteral, RDF.langString, RDFS.Literal, OWL.real, OWL.rational, XSD.xstring, XSD.normalizedString, XSD.token, XSD.language, XSD.Name, XSD.NCName, XSD.NMTOKEN, XSD.decimal, XSD.integer, XSD.xdouble, XSD.xfloat, XSD.xboolean, XSD.nonNegativeInteger, XSD.nonPositiveInteger, XSD.positiveInteger, XSD.negativeInteger, XSD.xlong, XSD.xint, XSD.xshort, XSD.xbyte, XSD.unsignedLong, XSD.unsignedInt, XSD.unsignedShort, XSD.unsignedByte, XSD.hexBinary, XSD.base64Binary, XSD.anyURI, XSD.dateTime, XSD.dateTimeStamp).collect(Iter.toUnmodifiableSet());
        public static final Set<RDFDatatype> JENA_RDF_DATATYPE_SET = OWLVocabulary.initBuiltInRDFDatatypes(TypeMapper.getInstance());
        public static final Set<Resource> DATATYPES = JENA_RDF_DATATYPE_SET.stream().map(RDFDatatype::getURI).map(ResourceFactory::createResource).collect(Iter.toUnmodifiableSet());
        public static final Set<Resource> CLASSES = Stream.of(OWL.Nothing, OWL.Thing).collect(Iter.toUnmodifiableSet());
        public static final Set<Property> ANNOTATION_PROPERTIES = Stream.of(RDFS.label, RDFS.comment, RDFS.seeAlso, RDFS.isDefinedBy, OWL.versionInfo, OWL.backwardCompatibleWith, OWL.priorVersion, OWL.incompatibleWith, OWL.deprecated).collect(Iter.toUnmodifiableSet());
        public static final Set<Property> DATA_PROPERTIES = Stream.of(OWL.topDataProperty, OWL.bottomDataProperty).collect(Iter.toUnmodifiableSet());
        public static final Set<Property> OBJECT_PROPERTIES = Stream.of(OWL.topObjectProperty, OWL.bottomObjectProperty).collect(Iter.toUnmodifiableSet());

        private static Set<RDFDatatype> initBuiltInRDFDatatypes(TypeMapper types) {
            Stream.of(OWL.real, OWL.rational).forEach(d -> types.registerDatatype((RDFDatatype)new BaseDatatype(d.getURI())));
            OWL2_DATATYPES.forEach(iri -> types.getSafeTypeByName(iri.getURI()));
            HashSet res = new HashSet();
            types.listTypes().forEachRemaining(res::add);
            return Collections.unmodifiableSet(res);
        }

        @Override
        public Set<Property> annotationProperties() {
            return ANNOTATION_PROPERTIES;
        }

        @Override
        public Set<Property> datatypeProperties() {
            return DATA_PROPERTIES;
        }

        @Override
        public Set<Property> objectProperties() {
            return OBJECT_PROPERTIES;
        }

        @Override
        public Set<Resource> datatypes() {
            return DATATYPES;
        }

        @Override
        public Set<Resource> classes() {
            return CLASSES;
        }

        @Override
        public Set<Resource> reservedResources() {
            return ALL_RESOURCES;
        }

        @Override
        public Set<Property> reservedProperties() {
            return ALL_PROPERTIES;
        }
    }

    public static interface Vocabulary {
        public Set<Property> annotationProperties();

        public Set<Property> datatypeProperties();

        public Set<Property> objectProperties();

        public Set<Resource> datatypes();

        public Set<Resource> classes();

        public Set<Resource> reservedResources();

        public Set<Property> reservedProperties();

        default public Set<Resource> reserved() {
            return Stream.of(this.reservedProperties(), this.reservedResources()).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        default public Set<Property> properties() {
            return Stream.of(this.annotationProperties(), this.datatypeProperties(), this.objectProperties()).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        default public Set<Resource> entities() {
            return Stream.of(this.classes(), this.datatypes(), this.properties()).flatMap(Collection::stream).collect(Collectors.toSet());
        }
    }
}

