/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.jena.utils;

import java.io.StringWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Dyadic;
import org.apache.jena.graph.compose.Polyadic;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import ru.avicomp.ontapi.jena.RWLockedGraph;
import ru.avicomp.ontapi.jena.UnionGraph;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;

public class Graphs {
    public static Stream<Graph> subGraphs(Graph graph) {
        return graph instanceof UnionGraph ? ((UnionGraph)graph).getUnderlying().graphs() : (graph instanceof Polyadic ? ((Polyadic)graph).getSubGraphs().stream() : (graph instanceof Dyadic ? Stream.of((Graph)((Dyadic)graph).getR()) : Stream.empty()));
    }

    public static Graph getBase(Graph graph) {
        if (graph instanceof GraphWrapper) {
            return Graphs.getBase(((GraphWrapper)graph).get());
        }
        if (graph instanceof RWLockedGraph) {
            return Graphs.getBase(((RWLockedGraph)graph).get());
        }
        if (graph instanceof UnionGraph) {
            return Graphs.getBase(((UnionGraph)graph).getBaseGraph());
        }
        if (graph instanceof Polyadic) {
            return Graphs.getBase(((Polyadic)graph).getBaseGraph());
        }
        if (graph instanceof Dyadic) {
            return Graphs.getBase((Graph)((Dyadic)graph).getL());
        }
        return graph;
    }

    public static Stream<Graph> flat(Graph graph) {
        return graph == null ? Stream.empty() : Stream.concat(Stream.of(Graphs.getBase(graph)), Graphs.subGraphs(graph).map(Graphs::flat).flatMap(Function.identity()));
    }

    public static boolean isSameBase(Graph left, Graph right) {
        return Objects.equals(Graphs.getBase(left), Graphs.getBase(right));
    }

    public static UnionGraph toUnion(Graph g) {
        return Graphs.toUnion(Graphs.getBase(g), Graphs.flat(g).collect(Collectors.toSet()));
    }

    public static UnionGraph toUnion(Graph base, Collection<Graph> other) {
        UnionGraph res = base instanceof UnionGraph ? (UnionGraph)base : new UnionGraph(base);
        Set<String> imports = Graphs.getImports(base);
        other.stream().filter(g -> imports.contains(Graphs.getURI(g))).forEach(g -> res.addGraph((Graph)Graphs.toUnion(g, other)));
        return res;
    }

    public static String getURI(Graph graph) {
        return Graphs.ontologyNode(Graphs.getBase(graph)).filter(Node::isURI).map(Node::getURI).orElse(null);
    }

    public static String getName(Graph graph) {
        return Graphs.ontologyNode(Graphs.getBase(graph)).map(n -> String.format("<%s>", n.toString())).orElse("NullOntology");
    }

    public static Optional<Node> ontologyNode(Graph g) {
        try (Stream<Node> nodes = Iter.asStream(g.find(Node.ANY, RDF.type.asNode(), OWL.Ontology.asNode())).map(Triple::getSubject).filter(node -> node.isBlank() || node.isURI()).sorted(Graphs.rootNodeComparator(g));){
            Optional<Node> optional = nodes.findFirst();
            return optional;
        }
    }

    public static Comparator<Node> rootNodeComparator(Graph graph) {
        return ((Comparator)(a, b) -> Boolean.compare(b.isURI(), a.isURI())).thenComparing(Comparator.comparingInt(subj -> graph.find(subj, Node.ANY, Node.ANY).toList().size()).reversed());
    }

    public static Set<String> getImports(Graph graph) {
        return Iter.asStream(graph.find(Node.ANY, OWL.imports.asNode(), Node.ANY)).map(Triple::getObject).filter(Node::isURI).map(Node::getURI).collect(Collectors.toSet());
    }

    public static String importsTreeAsString(Graph graph) {
        return Graphs.makeImportsTree(graph, "\t", "\t", new HashSet<Graph>()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder makeImportsTree(Graph graph, String indent, String step, Set<Graph> seen) {
        StringBuilder res = new StringBuilder();
        Graph base = Graphs.getBase(graph);
        try {
            String name = Graphs.getName(base);
            if (seen.contains(base)) {
                StringBuilder stringBuilder = res.append("Recursion: ").append(name);
                return stringBuilder;
            }
            seen.add(base);
            res.append(name).append("\n");
            Graphs.subGraphs(graph).sorted(Comparator.comparingLong(o -> Graphs.subGraphs(o).count())).forEach(sub -> res.append(indent).append((CharSequence)Graphs.makeImportsTree(sub, indent + step, step, seen)));
            StringBuilder stringBuilder = res;
            return stringBuilder;
        }
        finally {
            seen.remove(base);
        }
    }

    public static String toTurtleString(Graph g) {
        StringWriter sw = new StringWriter();
        RDFDataMgr.write((StringWriter)sw, (Graph)g, (Lang)Lang.TURTLE);
        return sw.toString();
    }

    public static PrefixMapping collectPrefixes(Iterable<Graph> graphs) {
        PrefixMapping res = PrefixMapping.Factory.create();
        graphs.forEach(g -> res.setNsPrefixes(g.getPrefixMapping()));
        return res.lock();
    }

    public static Graph asConcurrent(Graph graph, ReadWriteLock lock) {
        if (graph instanceof RWLockedGraph) {
            return Graphs.asConcurrent(((RWLockedGraph)graph).get(), lock);
        }
        if (!(graph instanceof UnionGraph)) {
            return new RWLockedGraph(graph, lock);
        }
        UnionGraph u = (UnionGraph)graph;
        Graph base = Graphs.asConcurrent(u.getBaseGraph(), lock);
        UnionGraph res = new UnionGraph(base, u.getEventManager());
        u.getUnderlying().graphs().map(Graphs::asNonConcurrent).forEach(res::addGraph);
        return res;
    }

    public static Graph asNonConcurrent(Graph graph) {
        if (graph instanceof RWLockedGraph) {
            return ((RWLockedGraph)graph).get();
        }
        if (!(graph instanceof UnionGraph)) {
            return graph;
        }
        UnionGraph u = (UnionGraph)graph;
        Graph base = Graphs.asNonConcurrent(u.getBaseGraph());
        UnionGraph res = new UnionGraph(base, u.getEventManager());
        u.getUnderlying().graphs().map(Graphs::asNonConcurrent).forEach(res::addGraph);
        return res;
    }

    public static Node createNode(String iri) {
        return iri == null ? NodeFactory.createBlankNode() : NodeFactory.createURI((String)iri);
    }

    public static ExtendedIterator<Node> subjects(Graph g) {
        return GraphUtil.listSubjects((Graph)g, (Node)Node.ANY, (Node)Node.ANY);
    }

    public static ExtendedIterator<Node> subjectsAndObjects(Graph g) {
        return WrappedIterator.create((Iterator)GraphUtils.allNodes((Graph)g));
    }

    public static ExtendedIterator<Node> all(Graph g) {
        Set res = Iter.flatMap(g.find(Triple.ANY), t -> Iter.of(t.getSubject(), t.getPredicate(), t.getObject())).toSet();
        return WrappedIterator.create(res.iterator());
    }
}

