/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.AsOWLAnnotationProperty;
import org.semanticweb.owlapi.model.AsOWLClass;
import org.semanticweb.owlapi.model.AsOWLDataProperty;
import org.semanticweb.owlapi.model.AsOWLDatatype;
import org.semanticweb.owlapi.model.AsOWLNamedIndividual;
import org.semanticweb.owlapi.model.AsOWLObjectProperty;
import org.semanticweb.owlapi.model.HasIndex;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.AbstractCollectorEx;
import org.semanticweb.owlapi.util.OWLClassExpressionCollector;
import org.semanticweb.owlapi.util.OWLEntityCollector;

public abstract class OWLObjectImpl
implements OWLObject,
Serializable {
    public static final Comparator<OWLObject> DEFAULT_COMPARATOR = Comparator.comparingInt(HasIndex::typeIndex).thenComparing(o -> o.components().iterator(), OWLObjectImpl::compareIterators);
    protected static final Set<OWLAnnotation> NO_ANNOTATIONS = Collections.emptySet();
    protected int hashCode = 0;

    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return this.addAnonymousIndividualsToSet(new TreeSet<OWLAnonymousIndividual>()).stream();
    }

    public Stream<OWLEntity> signature() {
        return this.addSignatureEntitiesToSet(new TreeSet<OWLEntity>()).stream();
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return this.signature().anyMatch(o -> Objects.equals(o, owlEntity));
    }

    public Stream<OWLClass> classesInSignature() {
        return this.signature().filter(AsOWLClass::isOWLClass).map(AsOWLClass::asOWLClass);
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return this.signature().filter(AsOWLDataProperty::isOWLDataProperty).map(AsOWLDataProperty::asOWLDataProperty);
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return this.signature().filter(AsOWLObjectProperty::isOWLObjectProperty).map(AsOWLObjectProperty::asOWLObjectProperty);
    }

    public Stream<OWLNamedIndividual> individualsInSignature() {
        return this.signature().filter(AsOWLNamedIndividual::isOWLNamedIndividual).map(AsOWLNamedIndividual::asOWLNamedIndividual);
    }

    public Stream<OWLDatatype> datatypesInSignature() {
        return this.signature().filter(AsOWLDatatype::isOWLDatatype).map(AsOWLDatatype::asOWLDatatype);
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return this.signature().filter(AsOWLAnnotationProperty::isOWLAnnotationProperty).map(AsOWLAnnotationProperty::asOWLAnnotationProperty);
    }

    public Stream<OWLClassExpression> nestedClassExpressions() {
        return ((Collection)this.accept((OWLObjectVisitorEx)new OWLClassExpressionCollector())).stream();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OWLObject)) {
            return false;
        }
        OWLObject other = (OWLObject)obj;
        return this.typeIndex() == other.typeIndex() && this.hashCode() == other.hashCode() && OWLObjectImpl.equalIterators(this.components().iterator(), other.components().iterator());
    }

    public int hashCode() {
        return this.hashCode == 0 ? (this.hashCode = this.initHashCode()) : this.hashCode;
    }

    public int compareTo(@Nullable OWLObject o) {
        return DEFAULT_COMPARATOR.compare(this, Objects.requireNonNull(o));
    }

    public String toString() {
        return ToStringRenderer.getRendering((OWLObject)this);
    }

    protected Set<OWLEntity> addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        this.accept((OWLObjectVisitorEx)new OWLEntityCollector(entities));
        return entities;
    }

    protected Set<OWLAnonymousIndividual> addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        this.accept((OWLObjectVisitorEx)new AnonymousIndividualCollector(anons));
        return anons;
    }

    protected static boolean equalIterators(Iterator set1, Iterator set2) {
        while (set1.hasNext() && set2.hasNext()) {
            Object o1 = set1.next();
            Object o2 = set2.next();
            if (!(o1 instanceof Stream && o2 instanceof Stream ? !OWLObjectImpl.equalIterators(((Stream)o1).iterator(), ((Stream)o2).iterator()) : !o1.equals(o2))) continue;
            return false;
        }
        return set1.hasNext() == set2.hasNext();
    }

    protected static int compareIterators(Iterator<?> set1, Iterator<?> set2) {
        while (set1.hasNext() && set2.hasNext()) {
            int diff;
            Object o1 = set1.next();
            Object o2 = set2.next();
            if (o1 instanceof Stream && o2 instanceof Stream) {
                diff = OWLObjectImpl.compareIterators(((Stream)o1).iterator(), ((Stream)o2).iterator());
            } else if (o1 instanceof Collection && o2 instanceof Collection) {
                diff = OWLObjectImpl.compareIterators(((Collection)o1).iterator(), ((Collection)o2).iterator());
            } else if (o1 instanceof Comparable && o2 instanceof Comparable) {
                diff = ((Comparable)o1).compareTo(o2);
            } else {
                throw new IllegalArgumentException(String.format("Incomparable types: '%s' with class %s, '%s' with class %s found while comparing iterators", o1, o1.getClass(), o2, o2.getClass()));
            }
            if (diff == 0) continue;
            return diff;
        }
        return Boolean.compare(set1.hasNext(), set2.hasNext());
    }

    protected static class AnonymousIndividualCollector
    extends AbstractCollectorEx<OWLAnonymousIndividual> {
        public AnonymousIndividualCollector(Collection<OWLAnonymousIndividual> anonsToReturn) {
            super(anonsToReturn);
        }

        public Collection<OWLAnonymousIndividual> visit(OWLAnonymousIndividual individual) {
            this.objects.add(individual);
            return this.objects;
        }
    }
}

