/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.axioms;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import ru.avicomp.ontapi.owlapi.axioms.OWLNaryPropertyAxiomImpl;
import ru.avicomp.ontapi.owlapi.axioms.OWLSubObjectPropertyOfAxiomImpl;

public class OWLInverseObjectPropertiesAxiomImpl
extends OWLNaryPropertyAxiomImpl<OWLObjectPropertyExpression>
implements OWLInverseObjectPropertiesAxiom {
    private final OWLObjectPropertyExpression first;
    private final OWLObjectPropertyExpression second;

    public OWLInverseObjectPropertiesAxiomImpl(OWLObjectPropertyExpression first, OWLObjectPropertyExpression second, Collection<OWLAnnotation> annotations) {
        super(Arrays.asList(Objects.requireNonNull(first, "first cannot be null"), Objects.requireNonNull(second, "second cannot be null")), annotations);
        this.first = first;
        this.second = second;
    }

    public Collection<OWLInverseObjectPropertiesAxiom> asPairwiseAxioms() {
        return CollectionFactory.createSet((Object)this);
    }

    public Collection<OWLInverseObjectPropertiesAxiom> splitToAnnotatedPairs() {
        return this.asPairwiseAxioms();
    }

    public OWLInverseObjectPropertiesAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLInverseObjectPropertiesAxiomImpl(this.getFirstProperty(), this.getSecondProperty(), NO_ANNOTATIONS);
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> anns) {
        return (T)new OWLInverseObjectPropertiesAxiomImpl(this.getFirstProperty(), this.getSecondProperty(), this.mergeAnnos(anns));
    }

    public OWLObjectPropertyExpression getFirstProperty() {
        return this.first;
    }

    public OWLObjectPropertyExpression getSecondProperty() {
        return this.second;
    }

    public Collection<OWLSubObjectPropertyOfAxiom> asSubObjectPropertyOfAxioms() {
        HashSet<OWLSubObjectPropertyOfAxiom> axs = new HashSet<OWLSubObjectPropertyOfAxiom>();
        axs.add(new OWLSubObjectPropertyOfAxiomImpl(this.first, this.second.getInverseProperty().getSimplified(), (Collection<OWLAnnotation>)NO_ANNOTATIONS));
        axs.add(new OWLSubObjectPropertyOfAxiomImpl(this.second, this.first.getInverseProperty().getSimplified(), (Collection<OWLAnnotation>)NO_ANNOTATIONS));
        return axs;
    }
}

