/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.axioms;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.owlapi.axioms.OWLClassAxiomImpl;

public abstract class OWLNaryClassAxiomImpl
extends OWLClassAxiomImpl
implements OWLNaryClassAxiom {
    protected final List<OWLClassExpression> classExpressions;

    public OWLNaryClassAxiomImpl(Collection<? extends OWLClassExpression> classExpressions, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.classExpressions = Objects.requireNonNull(classExpressions, "classExpressions cannot be null").stream().filter(Objects::nonNull).distinct().sorted().collect(Iter.toUnmodifiableList());
    }

    public Stream<OWLClassExpression> classExpressions() {
        return this.classExpressions.stream();
    }

    public List<OWLClassExpression> getOperandsAsList() {
        return this.classExpressions;
    }

    public boolean contains(OWLClassExpression ce) {
        return this.classExpressions.contains(ce);
    }

    public Set<OWLClassExpression> getClassExpressionsMinus(OWLClassExpression ... desc) {
        LinkedHashSet<OWLClassExpression> result = new LinkedHashSet<OWLClassExpression>(this.classExpressions);
        for (OWLClassExpression d : desc) {
            result.remove(d);
        }
        return result;
    }
}

