/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.axioms;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.owlapi.axioms.OWLPropertyAxiomImpl;

public abstract class OWLNaryPropertyAxiomImpl<P extends OWLPropertyExpression>
extends OWLPropertyAxiomImpl
implements OWLNaryPropertyAxiom<P> {
    protected final List<P> properties;

    public OWLNaryPropertyAxiomImpl(Collection<? extends P> properties, Collection<OWLAnnotation> annotations) {
        this(Objects.requireNonNull(properties, "properties cannot be null").stream(), annotations);
    }

    private OWLNaryPropertyAxiomImpl(Stream<? extends P> properties, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.properties = Objects.requireNonNull(properties, "properties cannot be null").filter(Objects::nonNull).distinct().sorted().collect(Iter.toUnmodifiableList());
    }

    public Stream<P> properties() {
        return this.properties.stream();
    }

    public List<P> getOperandsAsList() {
        return this.properties;
    }

    public Set<P> getPropertiesMinus(P property) {
        LinkedHashSet<P> props = new LinkedHashSet<P>(this.properties);
        props.remove(property);
        return props;
    }
}

