/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.axioms;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import ru.avicomp.ontapi.owlapi.axioms.OWLClassAxiomImpl;

public class OWLSubClassOfAxiomImpl
extends OWLClassAxiomImpl
implements OWLSubClassOfAxiom {
    private final OWLClassExpression subClass;
    private final OWLClassExpression superClass;

    public OWLSubClassOfAxiomImpl(OWLClassExpression subClass, OWLClassExpression superClass, Collection<OWLAnnotation> annotations) {
        super(annotations);
        this.subClass = Objects.requireNonNull(subClass, "subClass cannot be null");
        this.superClass = Objects.requireNonNull(superClass, "superClass cannot be null");
    }

    public <T extends OWLAxiom> T getAnnotatedAxiom(Stream<OWLAnnotation> anns) {
        return (T)new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, this.mergeAnnos(anns));
    }

    public OWLSubClassOfAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLSubClassOfAxiomImpl(this.subClass, this.superClass, NO_ANNOTATIONS);
    }

    public OWLClassExpression getSubClass() {
        return this.subClass;
    }

    public OWLClassExpression getSuperClass() {
        return this.superClass;
    }

    public boolean isGCI() {
        return this.subClass.isAnonymous();
    }
}

