/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.objects;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.RDFLangString;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import ru.avicomp.ontapi.jena.vocabulary.RDF;
import ru.avicomp.ontapi.owlapi.InternalizedEntities;
import ru.avicomp.ontapi.owlapi.OWLObjectImpl;
import ru.avicomp.ontapi.owlapi.objects.entity.OWLDatatypeImpl;

public class OWLLiteralImpl
extends OWLObjectImpl
implements OWLLiteral {
    protected static TypeMapper typeMapper = TypeMapper.getInstance();
    public static final Map<String, OWLDatatype> BUILTIN_OWL_DATATYPES = Collections.unmodifiableMap(new HashMap<String, OWLDatatype>(){
        {
            this.put(InternalizedEntities.RDFS_LITERAL);
            this.put(InternalizedEntities.RDF_LANG_STRING);
            this.put(InternalizedEntities.RDF_PLAIN_LITERAL);
            this.put(InternalizedEntities.XSD_STRING);
            this.put(InternalizedEntities.XSD_BOOLEAN);
            this.put(InternalizedEntities.XSD_DOUBLE);
            this.put(InternalizedEntities.XSD_FLOAT);
            this.put(InternalizedEntities.XSD_INTEGER);
        }

        private void put(OWLDatatype d) {
            this.put(d.getIRI().getIRIString(), d);
        }
    });
    protected final LiteralLabel label;
    private transient SoftReference<OWLDatatype> owlDatatypeRef;

    protected OWLLiteralImpl(LiteralLabel label) {
        this.label = Objects.requireNonNull(label);
    }

    public static OWLLiteralImpl createLiteral(String s) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.createTypedLiteral((Object)s));
    }

    public static OWLLiteralImpl createLiteral(String val, String lang) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.create((String)val, (String)OWLLiteralImpl.normalizeLanguageTag(lang)));
    }

    public static OWLLiteralImpl createLiteral(int i) {
        return OWLLiteralImpl.newLiteral(i, null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static OWLLiteralImpl createLiteral(boolean b) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.createTypedLiteral((Object)b));
    }

    public static OWLLiteralImpl createLiteral(double d) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.createTypedLiteral((Object)d));
    }

    public static OWLLiteralImpl createLiteral(float f) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.createTypedLiteral((Object)Float.valueOf(f)));
    }

    public static OWLLiteralImpl createLiteral(String txt, OWLDatatype owl) {
        if (owl.isRDFPlainLiteral() || InternalizedEntities.RDF_LANG_STRING.equals(owl)) {
            XSDDatatype dt;
            String lang;
            String lex;
            int sep = txt.lastIndexOf(64);
            if (sep != -1) {
                lex = txt.substring(0, sep);
                lang = OWLLiteralImpl.normalizeLanguageTag(txt.substring(sep + 1));
                dt = RDFLangString.rdfLangString;
            } else {
                lex = txt;
                lang = null;
                dt = XSDDatatype.XSDstring;
            }
            return OWLLiteralImpl.newLiteral((Object)lex, lang, (RDFDatatype)dt);
        }
        if (owl.isString()) {
            return OWLLiteralImpl.createLiteral(txt);
        }
        if (owl.isBoolean()) {
            return OWLLiteralImpl.parseBoolean(txt, owl);
        }
        if (owl.isFloat()) {
            return OWLLiteralImpl.parseFloat(txt, owl);
        }
        if (owl.isDouble()) {
            return OWLLiteralImpl.parseDouble(txt, owl);
        }
        if (owl.isInteger()) {
            return OWLLiteralImpl.parseInteger(txt, owl);
        }
        return OWLLiteralImpl.newLiteral(txt, null, owl);
    }

    public static String normalizeLanguageTag(String lang) {
        return lang == null ? "" : lang.trim().toLowerCase(Locale.ENGLISH);
    }

    public static OWLLiteralImpl parseBoolean(String txt, OWLDatatype dt) {
        return OWLLiteralImpl.createLiteral(OWLLiteralImpl.parseBoolean(txt.trim()));
    }

    public static boolean parseBoolean(String str) {
        return Boolean.parseBoolean(str) || "1".equals(str.trim());
    }

    public static OWLLiteralImpl parseDouble(String txt, OWLDatatype dt) {
        try {
            return OWLLiteralImpl.createLiteral(Double.parseDouble(txt));
        }
        catch (NumberFormatException e) {
            return OWLLiteralImpl.newLiteral(txt, null, dt);
        }
    }

    public static OWLLiteralImpl parseFloat(String txt, OWLDatatype dt) {
        if ("-0.0".equals(txt.trim())) {
            return OWLLiteralImpl.newLiteral(txt, null, dt);
        }
        try {
            return OWLLiteralImpl.createLiteral(Float.parseFloat(txt));
        }
        catch (NumberFormatException e) {
            return OWLLiteralImpl.newLiteral(txt, null, dt);
        }
    }

    public static OWLLiteralImpl parseInteger(String txt, OWLDatatype dt) {
        if ('0' == txt.trim().charAt(0)) {
            return OWLLiteralImpl.newLiteral(txt, null, dt);
        }
        try {
            return OWLLiteralImpl.createLiteral(Integer.parseInt(txt));
        }
        catch (NumberFormatException ex) {
            return OWLLiteralImpl.newLiteral(txt, null, dt);
        }
    }

    public static OWLLiteralImpl asONT(OWLLiteral literal) {
        if (literal instanceof OWLLiteralImpl) {
            return (OWLLiteralImpl)literal;
        }
        return OWLLiteralImpl.newLiteral(literal.getLiteral(), literal.getLang(), literal.getDatatype());
    }

    public static OWLLiteralImpl newLiteral(String txt, String lang, OWLDatatype owl) {
        String uri = owl.getIRI().getIRIString();
        RDFDatatype dt = typeMapper.getTypeByName(uri);
        if (dt == null) {
            dt = new BaseDatatype(uri);
        }
        return OWLLiteralImpl.newLiteral((Object)txt, lang, dt).putOWLDatatype(owl);
    }

    public static OWLLiteralImpl newLiteral(Object lex, String lang, RDFDatatype dt) {
        return OWLLiteralImpl.newLiteral(LiteralLabelFactory.createByValue((Object)lex, (String)lang, (RDFDatatype)dt));
    }

    public static OWLLiteralImpl newLiteral(LiteralLabel label) {
        return new OWLLiteralImpl(label);
    }

    public LiteralLabel getLiteralLabel() {
        return this.label;
    }

    public String getLiteral() {
        return this.label.getLexicalForm();
    }

    public String getLang() {
        return this.label.language();
    }

    public OWLDatatype getDatatype() {
        OWLDatatype res;
        if (this.owlDatatypeRef != null && (res = this.owlDatatypeRef.get()) != null) {
            return res;
        }
        res = this.calcOWLDatatype();
        this.owlDatatypeRef = new SoftReference<OWLDatatype>(res);
        return res;
    }

    public OWLDatatype calcOWLDatatype() {
        String uri = this.label.getDatatypeURI();
        if (uri != null) {
            if (RDF.PlainLiteral.getURI().equals(uri) && this.label.language().isEmpty()) {
                return InternalizedEntities.XSD_STRING;
            }
            OWLDatatype owl = BUILTIN_OWL_DATATYPES.get(uri);
            if (owl != null) {
                return owl;
            }
            return new OWLDatatypeImpl(IRI.create((String)uri));
        }
        return this.label.language().isEmpty() ? InternalizedEntities.XSD_STRING : InternalizedEntities.RDF_LANG_STRING;
    }

    public OWLLiteralImpl putOWLDatatype(OWLDatatype owl) {
        this.owlDatatypeRef = new SoftReference<OWLDatatype>(owl);
        return this;
    }

    public boolean hasLang() {
        return !this.label.language().isEmpty();
    }

    public boolean hasLang(@Nullable String lang) {
        if (lang == null) {
            return !this.hasLang();
        }
        return this.getLang().equalsIgnoreCase(lang.trim());
    }

    public boolean isRDFPlainLiteral() {
        return this.getDatatype().isRDFPlainLiteral();
    }

    public boolean isInteger() {
        return this.getDatatype().isInteger();
    }

    public boolean isBoolean() {
        return this.getDatatype().isBoolean();
    }

    public boolean isDouble() {
        return this.getDatatype().isDouble();
    }

    public boolean isFloat() {
        return this.getDatatype().isFloat();
    }

    public int parseInteger() {
        return Integer.parseInt(this.getLiteral());
    }

    public boolean parseBoolean() {
        return OWLLiteralImpl.parseBoolean(this.getLiteral());
    }

    public double parseDouble() {
        return Double.parseDouble(this.getLiteral());
    }

    public float parseFloat() {
        String res = this.getLiteral();
        if ("inf".equalsIgnoreCase(res)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-inf".equalsIgnoreCase(res)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(res);
    }

    protected int getLiteralHashCode() {
        if (this.label.isWellFormedRaw()) {
            Object value = this.label.getValue();
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1 : 0;
            }
        }
        return this.label.getLexicalForm().hashCode();
    }

    public int initHashCode() {
        int hash = this.hashIndex();
        hash = OWLObject.hashIteration((int)hash, (int)this.getDatatype().hashCode());
        hash = OWLObject.hashIteration((int)hash, (int)(this.getLiteralHashCode() * 65536));
        return OWLObject.hashIteration((int)hash, (int)this.getLang().hashCode());
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

