/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.objects.ce;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLAnonymousClassExpressionImpl;
import ru.avicomp.ontapi.owlapi.objects.ce.OWLObjectUnionOfImpl;

public class OWLObjectOneOfImpl
extends OWLAnonymousClassExpressionImpl
implements OWLObjectOneOf {
    private final List<OWLIndividual> values;

    public OWLObjectOneOfImpl(Stream<OWLIndividual> values) {
        this.values = Objects.requireNonNull(values, "values cannot be null").filter(Objects::nonNull).distinct().sorted().collect(Iter.toUnmodifiableList());
    }

    public OWLObjectOneOfImpl(OWLIndividual ... values) {
        this(Stream.of(values));
    }

    public OWLObjectOneOfImpl(OWLIndividual value) {
        this(Stream.of(value));
    }

    public Stream<OWLIndividual> individuals() {
        return this.values.stream();
    }

    public List<OWLIndividual> getOperandsAsList() {
        return this.values;
    }

    public OWLClassExpression asObjectUnionOf() {
        if (this.values.size() == 1) {
            return this;
        }
        return new OWLObjectUnionOfImpl(this.individuals().map(OWLObjectOneOfImpl::new));
    }
}

