/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.objects.dr;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLLiteral;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.owlapi.OWLObjectImpl;

public class OWLDataOneOfImpl
extends OWLObjectImpl
implements OWLDataOneOf {
    private final List<OWLLiteral> values;

    public OWLDataOneOfImpl(Stream<? extends OWLLiteral> values) {
        this.values = Objects.requireNonNull(values, "values cannot be null").filter(Objects::nonNull).distinct().sorted().collect(Iter.toUnmodifiableList());
    }

    public OWLDataOneOfImpl(Collection<? extends OWLLiteral> values) {
        this(Objects.requireNonNull(values, "values cannot be null").stream());
    }

    public OWLDataOneOfImpl(OWLLiteral value) {
        Objects.requireNonNull(value, "value cannot be null");
        this.values = Collections.singletonList(value);
    }

    public Stream<OWLLiteral> values() {
        return this.values.stream();
    }

    public Stream<OWLLiteral> operands() {
        return this.values();
    }

    public List<OWLLiteral> getOperandsAsList() {
        return this.values;
    }
}

