/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.owlapi.objects.swrl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;
import ru.avicomp.ontapi.owlapi.objects.swrl.SWRLAtomImpl;

public class SWRLBuiltInAtomImpl
extends SWRLAtomImpl
implements SWRLBuiltInAtom {
    private final List<SWRLDArgument> args;

    public SWRLBuiltInAtomImpl(IRI predicate, List<SWRLDArgument> args) {
        super((SWRLPredicate)predicate);
        this.args = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(args, "args cannot be null")));
    }

    public IRI getPredicate() {
        return (IRI)super.getPredicate();
    }

    public boolean isCoreBuiltIn() {
        return SWRLBuiltInsVocabulary.getBuiltIn((IRI)this.getPredicate()) != null;
    }

    public Stream<SWRLDArgument> arguments() {
        return this.args.stream();
    }

    public Stream<SWRLArgument> allArguments() {
        return this.args.stream().map(x -> x);
    }

    public List<SWRLDArgument> getArguments() {
        return this.args;
    }
}

