/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.transforms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;
import ru.avicomp.ontapi.jena.vocabulary.SWRL;
import ru.avicomp.ontapi.jena.vocabulary.XSD;
import ru.avicomp.ontapi.transforms.Transform;
import ru.avicomp.ontapi.transforms.vocabulary.AVC;

public class OWLDeclarationTransform
extends Transform {
    protected final Transform manifestDeclarator;
    protected final Transform reasonerDeclarator;

    public OWLDeclarationTransform(Graph graph) {
        super(graph);
        this.manifestDeclarator = new ManifestDeclarator(graph);
        this.reasonerDeclarator = new ReasonerDeclarator(graph);
    }

    @Override
    public void perform() {
        try {
            this.manifestDeclarator.perform();
            this.reasonerDeclarator.perform();
        }
        finally {
            this.finalActions();
        }
    }

    @Override
    public Stream<Triple> uncertainTriples() {
        return this.reasonerDeclarator.uncertainTriples();
    }

    protected void finalActions() {
        this.getBaseModel().removeAll(null, RDF.type, (RDFNode)AVC.AnonymousIndividual);
        Set<Resource> properties = this.statements(null, RDF.type, (RDFNode)RDF.Property).map(Statement::getSubject).filter(s -> this.statements((Resource)s, RDF.type, null).count() > 1L).collect(Collectors.toSet());
        Set<Resource> classes = this.statements(null, RDF.type, (RDFNode)RDFS.Class).map(Statement::getSubject).filter(s -> this.statements((Resource)s, RDF.type, null).count() > 1L).collect(Collectors.toSet());
        properties.forEach(p -> this.undeclare((Resource)p, RDF.Property));
        classes.forEach(c -> this.undeclare((Resource)c, RDFS.Class));
    }

    public static abstract class BaseDeclarator
    extends Transform {
        protected BaseDeclarator(Graph graph) {
            super(graph);
        }

        protected Set<Resource> subjectAndObjectsAsSet(Statement s) {
            HashSet<Resource> res = new HashSet<Resource>();
            res.add(s.getSubject());
            Iter.asStream(((RDFList)s.getObject().as(RDFList.class)).iterator()).filter(RDFNode::isResource).map(RDFNode::asResource).forEach(res::add);
            return res;
        }

        public Stream<Resource> members(Resource subject, Property predicate) {
            return Iter.asStream(subject.listProperties(predicate)).map(Statement::getObject).filter(o -> o.canAs(RDFList.class)).map(r -> (RDFList)r.as(RDFList.class)).flatMap(l -> Iter.asStream(l.iterator())).filter(RDFNode::isResource).map(RDFNode::asResource);
        }

        public Resource getObjectResource(Resource subject, Property predicate) {
            Statement res = subject.getProperty(predicate);
            return res != null && res.getObject().isResource() ? res.getObject().asResource() : null;
        }

        public Literal getObjectLiteral(Resource subject, Property predicate) {
            Statement res = subject.getProperty(predicate);
            return res != null && res.getObject().isLiteral() ? res.getObject().asLiteral() : null;
        }

        public boolean isClassExpression(Resource candidate) {
            return this.builtIn.classes().contains(candidate) || this.hasType(candidate, OWL.Class) || this.hasType(candidate, OWL.Restriction);
        }

        public boolean isDataRange(Resource candidate) {
            return this.builtIn.datatypes().contains(candidate) || this.hasType(candidate, RDFS.Datatype);
        }

        public boolean isObjectPropertyExpression(Resource candidate) {
            return this.builtIn.objectProperties().contains(candidate) || this.hasType(candidate, OWL.ObjectProperty) || candidate.hasProperty(OWL.inverseOf);
        }

        public boolean isDataProperty(Resource candidate) {
            return this.builtIn.datatypeProperties().contains(candidate) || this.hasType(candidate, OWL.DatatypeProperty);
        }

        public boolean isAnnotationProperty(Resource candidate) {
            return this.builtIn.annotationProperties().contains(candidate) || this.hasType(candidate, OWL.AnnotationProperty);
        }

        public boolean isIndividual(Resource candidate) {
            return this.hasType(candidate, OWL.NamedIndividual) || this.hasType(candidate, AVC.AnonymousIndividual);
        }

        public void declareObjectProperty(Resource resource) {
            this.declareObjectProperty(resource, this.builtIn.objectProperties());
        }

        public void declareDataProperty(Resource resource) {
            this.declareDataProperty(resource, this.builtIn.datatypeProperties());
        }

        public void declareAnnotationProperty(Resource resource) {
            this.declareAnnotationProperty(resource, this.builtIn.annotationProperties());
        }

        public void declareObjectProperty(Resource resource, Set<? extends Resource> builtIn) {
            if (resource.isAnon()) {
                this.undeclare(resource, OWL.ObjectProperty);
                return;
            }
            this.declare(resource, OWL.ObjectProperty, builtIn);
        }

        public void declareDataProperty(Resource resource, Set<? extends Resource> builtIn) {
            this.declare(resource, OWL.DatatypeProperty, builtIn);
        }

        public void declareAnnotationProperty(Resource resource, Set<? extends Resource> builtIn) {
            this.declare(resource, OWL.AnnotationProperty, builtIn);
        }

        public void declareIndividual(Resource resource) {
            if (resource.isAnon()) {
                this.undeclare(resource, OWL.NamedIndividual);
                this.declare(resource, AVC.AnonymousIndividual);
            } else {
                this.declare(resource, OWL.NamedIndividual);
            }
        }

        public void declareDatatype(Resource resource) {
            this.declare(resource, RDFS.Datatype, this.builtIn.datatypes());
        }

        public boolean declareClass(Resource resource) {
            Resource type;
            if (this.builtIn.classes().contains(resource)) {
                return true;
            }
            Object object = resource.isURIResource() ? OWL.Class : (this.containsClassExpressionProperty(resource) ? OWL.Class : (type = this.containsRestrictionProperty(resource) ? OWL.Restriction : null));
            if (type != null) {
                this.declare(resource, type);
                return true;
            }
            return false;
        }

        public boolean containsClassExpressionProperty(Resource candidate) {
            return Stream.of(OWL.intersectionOf, OWL.oneOf, OWL.unionOf, OWL.complementOf).anyMatch(arg_0 -> ((Resource)candidate).hasProperty(arg_0));
        }

        public boolean containsRestrictionProperty(Resource candidate) {
            return Stream.of(OWL.onProperty, OWL.allValuesFrom, OWL.someValuesFrom, OWL.hasValue, OWL.onClass, OWL.onDataRange, OWL.cardinality, OWL.qualifiedCardinality, OWL.maxCardinality, OWL.maxQualifiedCardinality, OWL.minCardinality, OWL.maxQualifiedCardinality, OWL.onProperties).anyMatch(arg_0 -> ((Resource)candidate).hasProperty(arg_0));
        }

        public void declare(Resource subject, Resource type, Set<? extends Resource> forbidden) {
            if (type == null || forbidden.contains(subject)) {
                return;
            }
            this.declare(subject, type);
        }
    }

    public static class ReasonerDeclarator
    extends BaseDeclarator {
        protected static final int MAX_TAIL_COUNT = 10;
        protected static final boolean PREFER_ANNOTATIONS_IN_UNCLEAR_CASES_DEFAULT = true;
        public Map<Statement, Function<Statement, Res>> rerun = new LinkedHashMap<Statement, Function<Statement, Res>>();
        protected boolean annotationsOpt;
        protected Set<Statement> unparsed = new HashSet<Statement>();

        public ReasonerDeclarator(Graph graph, boolean annotationsOpt) {
            super(graph);
            this.annotationsOpt = annotationsOpt;
        }

        protected ReasonerDeclarator(Graph graph) {
            this(graph, true);
        }

        @Override
        public Stream<Statement> statements(Resource s, Property p, RDFNode o) {
            return super.statements(s, p, o).sorted(Models.STATEMENT_COMPARATOR_IGNORE_BLANK);
        }

        @Override
        public void perform() {
            try {
                this.parseDataAndObjectRestrictions();
                this.parsePropertyDomains();
                this.parsePropertyRanges();
                this.parsePropertyAssertions();
                this.parseEquivalentClasses();
                this.parseUnionAndIntersectionClassExpressions();
                this.parseEquivalentAndDisjointProperties();
                this.parseAllDisjointProperties();
                this.parseSubProperties();
                this.unparsed.addAll(this.parseTail());
            }
            finally {
                this.rerun = new LinkedHashMap<Statement, Function<Statement, Res>>();
            }
        }

        @Override
        public Stream<Triple> uncertainTriples() {
            return this.unparsed.stream().map(FrontsTriple::asTriple);
        }

        public void parseDataAndObjectRestrictions() {
            Stream.of(OWL.allValuesFrom, OWL.someValuesFrom).map(p -> this.statements(null, (Property)p, null)).flatMap(Function.identity()).forEach(s -> {
                if (Res.UNKNOWN.equals((Object)this.dataAndObjectRestrictions((Statement)s))) {
                    this.rerun.put((Statement)s, this::dataAndObjectRestrictions);
                }
            });
        }

        public Res dataAndObjectRestrictions(Statement statement) {
            Resource p = this.getObjectResource(statement.getSubject(), OWL.onProperty);
            Resource c = this.getObjectResource(statement.getSubject(), statement.getPredicate());
            if (p == null || c == null) {
                return Res.FALSE;
            }
            this.declare(statement.getSubject(), OWL.Restriction);
            if (this.isClassExpression(c) || this.isObjectPropertyExpression(p)) {
                this.declareObjectProperty(p);
                if (this.declareClass(c)) {
                    return Res.TRUE;
                }
            }
            if (this.isDataRange(c) || this.isDataProperty(p)) {
                this.declareDataProperty(p);
                this.declareDatatype(c);
                return Res.TRUE;
            }
            return Res.UNKNOWN;
        }

        public void parsePropertyDomains() {
            this.statements(null, RDFS.domain, null).filter(s -> s.getObject().isResource()).forEach(s -> {
                if (Res.UNKNOWN.equals((Object)this.propertyDomains((Statement)s, false))) {
                    this.rerun.put((Statement)s, statement -> this.propertyDomains((Statement)statement, this.annotationsOpt));
                }
            });
        }

        public Res propertyDomains(Statement statement, boolean preferAnnotationsInUnknownCases) {
            Resource left = statement.getSubject();
            Resource right = statement.getObject().asResource();
            if (this.isAnnotationProperty(left) && right.isURIResource()) {
                return Res.TRUE;
            }
            if ((this.isDataProperty(left) || this.isObjectPropertyExpression(left)) && this.declareClass(right)) {
                return Res.TRUE;
            }
            if (right.isAnon()) {
                this.declareClass(right);
            }
            if (preferAnnotationsInUnknownCases) {
                this.declareAnnotationProperty(left);
                return Res.TRUE;
            }
            return Res.UNKNOWN;
        }

        public void parsePropertyRanges() {
            this.statements(null, RDFS.range, null).filter(s -> s.getObject().isResource()).forEach(s -> {
                if (Res.UNKNOWN.equals((Object)this.propertyRanges((Statement)s, false))) {
                    this.rerun.put((Statement)s, statement -> this.propertyRanges((Statement)statement, this.annotationsOpt));
                }
            });
        }

        public Res propertyRanges(Statement statement, boolean preferAnnotationsInUnknownCases) {
            Resource left = statement.getSubject();
            Resource right = statement.getObject().asResource();
            if (this.isAnnotationProperty(left) && right.isURIResource()) {
                return Res.TRUE;
            }
            if (this.isClassExpression(right)) {
                this.declareObjectProperty(left);
                return Res.TRUE;
            }
            if (this.isDataRange(right)) {
                this.declareDataProperty(left);
                return Res.TRUE;
            }
            if (preferAnnotationsInUnknownCases) {
                this.declareAnnotationProperty(left);
                return Res.TRUE;
            }
            return Res.UNKNOWN;
        }

        public void parsePropertyAssertions() {
            Set<Statement> statements = this.statements(null, null, null).filter(s -> !this.builtIn.reservedProperties().contains(s.getPredicate())).collect(Collectors.toSet());
            statements.forEach(s -> {
                if (Res.UNKNOWN.equals((Object)this.propertyAssertions((Statement)s, false))) {
                    this.rerun.put((Statement)s, statement -> this.propertyAssertions((Statement)statement, this.annotationsOpt));
                }
            });
        }

        public Res propertyAssertions(Statement statement, boolean preferAnnotationsInUnknownCases) {
            Resource subject = statement.getSubject();
            RDFNode right = statement.getObject();
            Property property = statement.getPredicate();
            if (this.isAnnotationProperty((Resource)property)) {
                return Res.TRUE;
            }
            if (right.isLiteral()) {
                if (this.isDataProperty((Resource)property)) {
                    this.declareIndividual(subject);
                    return Res.TRUE;
                }
                if (this.isIndividual(subject) && this.couldBeDataPropertyInAssertion(property)) {
                    this.declareDataProperty((Resource)property);
                    return Res.TRUE;
                }
                if (this.mustBeDataOrObjectProperty((Resource)property)) {
                    this.declareDataProperty((Resource)property);
                    this.declareIndividual(subject);
                    return Res.TRUE;
                }
            } else {
                Resource object = right.asResource();
                if (this.isIndividual(object) || this.couldBeIndividual((RDFNode)object)) {
                    if (this.isObjectPropertyExpression((Resource)property)) {
                        this.declareIndividual(subject);
                        this.declareIndividual(object);
                        return Res.TRUE;
                    }
                    if (this.isIndividual(subject)) {
                        this.declareObjectProperty((Resource)property);
                        this.declareIndividual(object);
                        return Res.TRUE;
                    }
                    if (this.mustBeDataOrObjectProperty((Resource)property)) {
                        this.declareObjectProperty((Resource)property);
                        this.declareIndividual(subject);
                        this.declareIndividual(object);
                        return Res.TRUE;
                    }
                }
            }
            if (preferAnnotationsInUnknownCases) {
                this.declareAnnotationProperty((Resource)property);
                return Res.TRUE;
            }
            return Res.UNKNOWN;
        }

        protected boolean mustBeDataOrObjectProperty(Resource candidate) {
            if (candidate.hasProperty(RDF.type, (RDFNode)OWL.FunctionalProperty)) {
                return true;
            }
            return this.statements(null, OWL.hasKey, null).map(Statement::getObject).filter(o -> o.canAs(RDFList.class)).map(o -> (RDFList)o.as(RDFList.class)).flatMap(l -> Iter.asStream(l.iterator())).filter(RDFNode::isResource).map(RDFNode::asResource).anyMatch(arg_0 -> ((Resource)candidate).equals(arg_0));
        }

        protected boolean couldBeIndividual(RDFNode candidate) {
            return candidate.isResource() && (candidate.isAnon() ? !candidate.canAs(RDFList.class) : !this.builtIn.reserved().contains(candidate.asResource()));
        }

        protected boolean couldBeDataPropertyInAssertion(Property candidate) {
            Set objects = this.statements(null, candidate, null).map(Statement::getObject).collect(Collectors.toSet());
            if (objects.stream().anyMatch(RDFNode::isResource)) {
                return true;
            }
            List datatypes = objects.stream().map(RDFNode::asLiteral).map(Literal::getDatatypeURI).distinct().collect(Collectors.toList());
            return datatypes.size() > 1 || !XSD.xstring.getURI().equals(datatypes.get(0));
        }

        public void parseEquivalentClasses() {
            this.statements(null, OWL.equivalentClass, null).filter(s -> s.getObject().isResource()).forEach(s -> {
                if (Res.UNKNOWN.equals((Object)this.equivalentClasses((Statement)s))) {
                    this.rerun.put((Statement)s, this::equivalentClasses);
                }
            });
        }

        public Res equivalentClasses(Statement statement) {
            Resource b;
            Resource a = statement.getSubject();
            if (Stream.of(a, b = statement.getObject().asResource()).anyMatch(this::isClassExpression)) {
                this.declareClass(a);
                this.declareClass(b);
                return Res.TRUE;
            }
            if (a.isURIResource() && Stream.of(a, b).anyMatch(this::isDataRange)) {
                this.declareDatatype(a);
                this.declareDatatype(b);
                return Res.TRUE;
            }
            return Res.UNKNOWN;
        }

        public void parseUnionAndIntersectionClassExpressions() {
            Stream.of(OWL.unionOf, OWL.intersectionOf).map(p -> this.statements(null, (Property)p, null)).flatMap(Function.identity()).filter(s -> s.getSubject().isAnon()).filter(s -> s.getObject().canAs(RDFList.class)).forEach(s -> {
                if (Res.UNKNOWN.equals((Object)this.unionAndIntersectionClassExpressions((Statement)s))) {
                    this.rerun.put((Statement)s, this::unionAndIntersectionClassExpressions);
                }
            });
        }

        public Res unionAndIntersectionClassExpressions(Statement statement) {
            Set<Resource> set = this.subjectAndObjectsAsSet(statement);
            if (set.stream().anyMatch(this::isClassExpression)) {
                set.forEach(this::declareClass);
                return Res.TRUE;
            }
            if (set.stream().anyMatch(this::isDataRange)) {
                set.forEach(this::declareDatatype);
                return Res.TRUE;
            }
            return Res.UNKNOWN;
        }

        public void parseEquivalentAndDisjointProperties() {
            Stream.of(OWL.equivalentProperty, OWL.propertyDisjointWith).map(p -> this.statements(null, (Property)p, null)).flatMap(Function.identity()).filter(s -> s.getObject().isResource()).forEach(s -> {
                if (Res.UNKNOWN.equals((Object)this.equivalentAndDisjointProperties((Statement)s))) {
                    this.rerun.put((Statement)s, this::equivalentAndDisjointProperties);
                }
            });
        }

        public Res equivalentAndDisjointProperties(Statement statement) {
            Resource a = statement.getSubject();
            Resource b = statement.getObject().asResource();
            if (Stream.of(a, b).anyMatch(this::isObjectPropertyExpression)) {
                this.declareObjectProperty(a, this.builtIn.properties());
                this.declareObjectProperty(b, this.builtIn.properties());
                return Res.TRUE;
            }
            if (Stream.of(a, b).anyMatch(this::isDataProperty)) {
                this.declareDataProperty(a, this.builtIn.properties());
                this.declareDataProperty(b, this.builtIn.properties());
                return Res.TRUE;
            }
            return Res.UNKNOWN;
        }

        public void parseAllDisjointProperties() {
            this.statements(null, RDF.type, (RDFNode)OWL.AllDisjointProperties).filter(s -> s.getSubject().isAnon()).filter(s -> s.getSubject().hasProperty(OWL.members)).forEach(s -> {
                if (Res.UNKNOWN.equals((Object)this.allDisjointProperties((Statement)s))) {
                    this.rerun.put((Statement)s, this::allDisjointProperties);
                }
            });
        }

        public Res allDisjointProperties(Statement statement) {
            Set<Resource> set = this.members(statement.getSubject(), OWL.members).collect(Collectors.toSet());
            if (set.isEmpty()) {
                return Res.FALSE;
            }
            if (set.stream().anyMatch(this::isObjectPropertyExpression)) {
                set.forEach(this::declareObjectProperty);
                return Res.TRUE;
            }
            if (set.stream().anyMatch(this::isDataProperty)) {
                set.forEach(this::declareDataProperty);
                return Res.TRUE;
            }
            return Res.UNKNOWN;
        }

        public void parseSubProperties() {
            this.statements(null, RDFS.subPropertyOf, null).filter(s -> s.getObject().isResource()).forEach(s -> {
                if (Res.UNKNOWN.equals((Object)this.subProperties((Statement)s, false))) {
                    this.rerun.put((Statement)s, statement -> this.subProperties((Statement)statement, this.annotationsOpt));
                }
            });
        }

        public Res subProperties(Statement statement, boolean preferAnnotationsInUnknownCases) {
            Resource a = statement.getSubject();
            Resource b = statement.getObject().asResource();
            Res res = Res.UNKNOWN;
            if (Stream.of(a, b).anyMatch(this::isObjectPropertyExpression)) {
                this.declareObjectProperty(a, this.builtIn.properties());
                this.declareObjectProperty(b, this.builtIn.properties());
                res = Res.TRUE;
            }
            if (Stream.of(a, b).anyMatch(this::isDataProperty)) {
                this.declareDataProperty(a, this.builtIn.properties());
                this.declareDataProperty(b, this.builtIn.properties());
                res = Res.TRUE;
            }
            if (Stream.of(a, b).anyMatch(this::isAnnotationProperty) || Res.UNKNOWN.equals((Object)res) && preferAnnotationsInUnknownCases) {
                this.declareAnnotationProperty(a, this.builtIn.properties());
                this.declareAnnotationProperty(b, this.builtIn.properties());
                res = Res.TRUE;
            }
            return res;
        }

        public Set<Statement> parseTail() {
            LinkedHashMap<Object, Function<Object, Res>> prev = new LinkedHashMap<Statement, Function<Statement, Res>>(this.rerun);
            LinkedHashMap next = new LinkedHashMap();
            int count = 0;
            while (count++ < 10) {
                for (Statement s : prev.keySet()) {
                    Function func = (Function)prev.get(s);
                    if (!Res.UNKNOWN.equals(func.apply(s))) continue;
                    next.put(s, prev.get(s));
                }
                if (next.isEmpty()) {
                    return Collections.emptySet();
                }
                if (next.size() == prev.size()) break;
                prev = next;
                next = new LinkedHashMap();
            }
            LOGGER.warn("Ambiguous statements {}", next.keySet());
            return next.keySet();
        }

        public static enum Res {
            TRUE,
            FALSE,
            UNKNOWN;

        }
    }

    public static class ManifestDeclarator
    extends BaseDeclarator {
        protected Set<Resource> forbiddenClassCandidates;

        public ManifestDeclarator(Graph graph) {
            super(graph);
        }

        @Override
        public void perform() {
            this.parseAnnotations();
            this.parseClassExpressions();
            this.parseDataRangeExpressions();
            this.parseOneOfExpression();
            this.parseObjectPropertyExpressions();
            this.parseObjectOrDataProperties();
            this.parseIndividuals();
            this.parseClassAssertions();
            this.parseSWRL();
        }

        public void parseAnnotations() {
            this.statements(null, OWL.annotatedProperty, (RDFNode)RDF.type).map(Statement::getSubject).filter(RDFNode::isAnon).filter(s -> s.hasProperty(RDF.type, (RDFNode)OWL.Annotation) || s.hasProperty(RDF.type, (RDFNode)OWL.Axiom)).forEach(r -> {
                Resource source = this.getObjectResource((Resource)r, OWL.annotatedSource);
                Resource target = this.getObjectResource((Resource)r, OWL.annotatedTarget);
                if (source == null || target == null) {
                    return;
                }
                this.declare(source, target);
            });
        }

        public void parseClassExpressions() {
            Stream.of(RDFS.subClassOf, OWL.disjointWith).map(p -> this.statements(null, (Property)p, null)).flatMap(Function.identity()).map(s -> Stream.of(s.getSubject(), s.getObject())).flatMap(Function.identity()).filter(RDFNode::isResource).map(RDFNode::asResource).distinct().forEach(this::declareClass);
            this.statements(null, OWL.complementOf, null).map(s -> Stream.of(s.getSubject(), s.getObject())).flatMap(Function.identity()).filter(RDFNode::isResource).map(RDFNode::asResource).distinct().forEach(this::declareClass);
            this.statements(null, RDF.type, (RDFNode)OWL.AllDisjointClasses).filter(s -> s.getSubject().isAnon()).map(s -> this.members(s.getSubject(), OWL.members)).flatMap(Function.identity()).distinct().forEach(this::declareClass);
            this.statements(null, OWL.disjointUnionOf, null).map(Statement::getSubject).filter(RDFNode::isURIResource).forEach(c -> {
                this.declareClass((Resource)c);
                this.members((Resource)c, OWL.disjointUnionOf).forEach(this::declareClass);
            });
            this.statements(null, OWL.hasKey, null).map(Statement::getSubject).forEach(this::declareClass);
            this.statements(null, OWL.onClass, null).filter(s -> s.getSubject().isAnon()).filter(s -> s.getSubject().hasProperty(OWL.onProperty)).filter(s -> s.getObject().isResource()).forEach(s -> {
                this.declare(s.getSubject(), OWL.Restriction);
                this.declareClass(s.getObject().asResource());
            });
        }

        public void parseDataRangeExpressions() {
            this.statements(null, OWL.datatypeComplementOf, null).filter(s -> s.getObject().isResource()).forEach(s -> {
                this.declareDatatype(s.getSubject());
                this.declareDatatype(s.getObject().asResource());
            });
            this.statements(null, OWL.onDatatype, null).filter(s -> s.getObject().isURIResource()).filter(s -> s.getSubject().hasProperty(OWL.withRestrictions)).filter(s -> s.getSubject().getProperty(OWL.withRestrictions).getObject().canAs(RDFList.class)).forEach(s -> {
                this.declareDatatype(s.getSubject());
                this.declareDatatype(s.getObject().asResource());
            });
            this.statements(null, OWL.onProperties, null).filter(s -> s.getSubject().isAnon()).filter(s -> s.getObject().canAs(RDFList.class)).map(Statement::getSubject).forEach(r -> {
                Stream.of(OWL.allValuesFrom, OWL.someValuesFrom).map(p -> this.statements((Resource)r, (Property)p, null)).flatMap(Function.identity()).map(Statement::getObject).filter(RDFNode::isAnon).forEach(n -> this.declareDatatype(n.asResource()));
                this.declare((Resource)r, OWL.Restriction);
            });
            this.statements(null, OWL.onDataRange, null).filter(s -> s.getSubject().isAnon()).filter(s -> s.getSubject().hasProperty(OWL.onProperty)).filter(s -> s.getObject().isResource()).forEach(s -> {
                this.declare(s.getSubject(), OWL.Restriction);
                this.declareDatatype(s.getObject().asResource());
            });
        }

        public void parseOneOfExpression() {
            this.statements(null, OWL.oneOf, null).filter(s -> s.getSubject().isAnon()).filter(s -> s.getObject().canAs(RDFList.class)).forEach(s -> {
                List values = ((RDFList)s.getObject().as(RDFList.class)).asJavaList();
                if (values.isEmpty()) {
                    return;
                }
                if (values.stream().allMatch(RDFNode::isLiteral)) {
                    this.declareDatatype(s.getSubject());
                } else {
                    this.declareClass(s.getSubject());
                    values.forEach(v -> this.declareIndividual(v.asResource()));
                }
            });
        }

        public void parseObjectPropertyExpressions() {
            Stream.of(OWL.InverseFunctionalProperty, OWL.ReflexiveProperty, OWL.IrreflexiveProperty, OWL.SymmetricProperty, OWL.AsymmetricProperty, OWL.TransitiveProperty).map(p -> this.statements(null, RDF.type, (RDFNode)p)).flatMap(Function.identity()).map(Statement::getSubject).distinct().forEach(this::declareObjectProperty);
            this.statements(null, OWL.inverseOf, null).filter(s -> s.getObject().isURIResource()).map(s -> Stream.of(s.getSubject(), s.getObject().asResource())).flatMap(Function.identity()).distinct().forEach(this::declareObjectProperty);
            this.statements(null, OWL.propertyChainAxiom, null).map(this::subjectAndObjectsAsSet).map(Collection::stream).flatMap(Function.identity()).distinct().forEach(this::declareObjectProperty);
            this.statements(null, OWL.hasSelf, null).filter(s -> Objects.equals(Models.TRUE, s.getObject())).map(Statement::getSubject).filter(RDFNode::isAnon).filter(s -> s.hasProperty(OWL.onProperty)).forEach(s -> {
                Resource p = this.getObjectResource((Resource)s, OWL.onProperty);
                if (p == null) {
                    return;
                }
                this.declare((Resource)s, OWL.Restriction);
                this.declareObjectProperty(p);
            });
        }

        public void parseObjectOrDataProperties() {
            this.statements(null, OWL.hasValue, null).forEach(s -> {
                Resource p = this.getObjectResource(s.getSubject(), OWL.onProperty);
                if (p == null) {
                    return;
                }
                this.declare(s.getSubject(), OWL.Restriction);
                if (s.getObject().isLiteral()) {
                    this.declareDataProperty(p);
                } else {
                    this.declareObjectProperty(p);
                    this.declareIndividual(s.getObject().asResource());
                }
            });
            this.statements(null, RDF.type, (RDFNode)OWL.NegativePropertyAssertion).map(Statement::getSubject).filter(RDFNode::isAnon).forEach(r -> {
                Resource source = this.getObjectResource((Resource)r, OWL.sourceIndividual);
                Resource prop = this.getObjectResource((Resource)r, OWL.assertionProperty);
                if (source == null || prop == null) {
                    return;
                }
                Resource i = this.getObjectResource((Resource)r, OWL.targetIndividual);
                if (i == null && this.getObjectLiteral((Resource)r, OWL.targetValue) == null) {
                    return;
                }
                this.declareIndividual(source);
                if (i != null) {
                    this.declareIndividual(i);
                    this.declareObjectProperty(prop);
                } else {
                    this.declareDataProperty(prop);
                }
            });
        }

        public void parseIndividuals() {
            Stream.of(OWL.sameAs, OWL.differentFrom).map(p -> this.statements(null, (Property)p, null)).flatMap(Function.identity()).map(s -> Stream.of(s.getSubject(), s.getObject())).flatMap(Function.identity()).filter(RDFNode::isResource).map(RDFNode::asResource).distinct().forEach(this::declareIndividual);
            this.statements(null, RDF.type, (RDFNode)OWL.AllDifferent).filter(s -> s.getSubject().isAnon()).map(Statement::getSubject).map(s -> Stream.concat(this.members((Resource)s, OWL.members), this.members((Resource)s, OWL.distinctMembers))).flatMap(Function.identity()).distinct().forEach(this::declareIndividual);
        }

        protected Set<Resource> forbiddenClassCandidates() {
            if (this.forbiddenClassCandidates != null) {
                return this.forbiddenClassCandidates;
            }
            this.forbiddenClassCandidates = new HashSet<Resource>(this.builtIn.reservedResources());
            this.forbiddenClassCandidates.add(AVC.AnonymousIndividual);
            this.forbiddenClassCandidates.removeAll(this.builtIn.classes());
            return this.forbiddenClassCandidates;
        }

        public void parseClassAssertions() {
            Set<Statement> statements = this.statements(null, RDF.type, null).filter(s -> s.getObject().isResource()).filter(s -> !this.forbiddenClassCandidates().contains(s.getObject().asResource())).collect(Collectors.toSet());
            statements.forEach(s -> {
                this.declareIndividual(s.getSubject());
                this.declareClass(s.getObject().asResource());
            });
        }

        public void parseSWRL() {
            this.processSWRL(SWRL.argument1, s -> s.getSubject().isAnon() && Stream.of(SWRL.ClassAtom, SWRL.DatavaluedPropertyAtom, SWRL.IndividualPropertyAtom, SWRL.DifferentIndividualsAtom, SWRL.SameIndividualAtom).anyMatch(t -> this.hasType(s.getSubject(), (Resource)t)), r -> !this.hasType((Resource)r, SWRL.Variable), this::declareIndividual);
            this.processSWRL(SWRL.argument2, s -> s.getSubject().isAnon() && Stream.of(SWRL.IndividualPropertyAtom, SWRL.DifferentIndividualsAtom, SWRL.SameIndividualAtom).anyMatch(t -> this.hasType(s.getSubject(), (Resource)t)), r -> !this.hasType((Resource)r, SWRL.Variable), this::declareIndividual);
            this.processSWRL(SWRL.classPredicate, s -> s.getSubject().isAnon() && this.hasType(s.getSubject(), SWRL.ClassAtom), null, this::declareClass);
            this.processSWRL(SWRL.dataRange, s -> s.getSubject().isAnon() && this.hasType(s.getSubject(), SWRL.DataRangeAtom), null, this::declareDatatype);
            this.processSWRL(SWRL.propertyPredicate, s -> s.getSubject().isAnon() && this.hasType(s.getSubject(), SWRL.IndividualPropertyAtom), null, this::declareObjectProperty);
            this.processSWRL(SWRL.propertyPredicate, s -> s.getSubject().isAnon() && this.hasType(s.getSubject(), SWRL.DatavaluedPropertyAtom), null, this::declareDataProperty);
        }

        protected void processSWRL(Property predicateToFind, Predicate<Statement> functionToFilter, Predicate<Resource> functionToCheck, Consumer<Resource> functionToDeclare) {
            this.statements(null, predicateToFind, null).filter(functionToFilter).map(Statement::getObject).filter(RDFNode::isResource).map(RDFNode::asResource).filter(r -> functionToCheck == null || functionToCheck.test((Resource)r)).forEach(functionToDeclare);
        }
    }
}

