/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.transforms;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.vocabulary.RDF;
import ru.avicomp.ontapi.jena.utils.BuiltIn;
import ru.avicomp.ontapi.jena.vocabulary.SWRL;
import ru.avicomp.ontapi.transforms.Transform;
import ru.avicomp.ontapi.transforms.TransformException;

public class SWRLTransform
extends Transform {
    public SWRLTransform(Graph graph) {
        super(graph, BuiltIn.get());
    }

    @Override
    public void perform() throws TransformException {
        this.fixEmptyLists();
    }

    protected void fixEmptyLists() {
        Stream.of(SWRL.body, SWRL.head).forEach(this::fixEmptyList);
    }

    protected void fixEmptyList(Property predicate) {
        Model m = this.getBaseModel();
        SWRLTransform.statements(this.getModel(), null, predicate, null).filter(s -> s.getObject().isAnon()).filter(s -> s.getResource().hasProperty(RDF.type, (RDFNode)SWRL.AtomList)).filter(s -> s.getResource().listProperties().toList().size() == 1).collect(Collectors.toSet()).forEach(s -> m.removeAll(s.getResource(), null, null).remove(s).add(s.getSubject(), s.getPredicate(), (RDFNode)RDF.nil));
    }

    @Override
    public boolean test() {
        return this.graph.contains(Node.ANY, RDF.type.asNode(), SWRL.Imp.asNode());
    }
}

