/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.transforms;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.avicomp.ontapi.jena.UnionGraph;
import ru.avicomp.ontapi.jena.utils.BuiltIn;
import ru.avicomp.ontapi.jena.utils.Graphs;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.RDF;
import ru.avicomp.ontapi.transforms.TransformException;

public abstract class Transform {
    protected static final Logger LOGGER = LoggerFactory.getLogger(Transform.class);
    protected final Graph graph;
    protected final BuiltIn.Vocabulary builtIn;
    private Model model;
    private Model base;

    protected Transform(Graph graph, BuiltIn.Vocabulary vocabulary) throws NullPointerException {
        this.graph = Objects.requireNonNull(graph, "Null graph.");
        this.builtIn = Objects.requireNonNull(vocabulary, "Null built-in vocabulary.");
    }

    public Transform(Graph graph) {
        this(graph, BuiltIn.get());
    }

    public Stream<Triple> process() throws TransformException {
        if (this.test()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Process <%s> on <%s>", this.name(), Graphs.getName(this.getBaseGraph())));
            }
            this.perform();
        }
        return this.uncertainTriples();
    }

    public abstract void perform() throws TransformException;

    public boolean test() {
        return true;
    }

    public Stream<Triple> uncertainTriples() {
        return Stream.empty();
    }

    protected static Stream<Statement> statements(Model m, Resource s, Property p, RDFNode o) {
        return Iter.asStream(m.listStatements(s, p, o));
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public Graph getGraph() {
        return this.graph;
    }

    protected Graph getBaseGraph() {
        return this.graph instanceof UnionGraph ? ((UnionGraph)this.graph).getBaseGraph() : this.graph;
    }

    protected Model getModel() {
        return this.model == null ? (this.model = ModelFactory.createModelForGraph((Graph)this.getGraph())) : this.model;
    }

    protected Model getBaseModel() {
        return this.base == null ? (this.base = ModelFactory.createModelForGraph((Graph)this.getBaseGraph())) : this.base;
    }

    protected void changeType(Resource realType, Resource newType) {
        Set<Resource> toFix = this.statements(null, RDF.type, (RDFNode)realType).map(Statement::getSubject).collect(Collectors.toSet());
        toFix.forEach(subject -> {
            this.undeclare((Resource)subject, realType);
            this.declare((Resource)subject, newType);
        });
    }

    protected void declare(Resource subject, Resource type) {
        if (subject.hasProperty(RDF.type, (RDFNode)Objects.requireNonNull(type, "Declare: null type for resource '" + subject + "'"))) {
            return;
        }
        subject.addProperty(RDF.type, (RDFNode)type);
    }

    protected void undeclare(Resource subject, Resource type) {
        this.getBaseModel().removeAll(subject, RDF.type, (RDFNode)Objects.requireNonNull(type, "Undeclare: null type for resource '" + subject + "'"));
    }

    protected boolean containsType(Resource type) {
        return this.getBaseModel().contains(null, RDF.type, (RDFNode)type);
    }

    protected boolean hasType(Resource resource, Resource type) {
        return resource.hasProperty(RDF.type, (RDFNode)type);
    }

    protected Stream<Statement> statements(Resource s, Property p, RDFNode o) {
        return Transform.statements(this.getBaseModel(), s, p, o).map(st -> this.getModel().asStatement(st.asTriple()));
    }

    public String toString() {
        return String.format("[%s:%s]", this.name(), Graphs.getName(this.getBaseGraph()));
    }
}

