/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.util.Objects;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import ru.avicomp.ontapi.DataFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntologyManager;
import ru.avicomp.ontapi.OntologyManagerImpl;
import ru.avicomp.ontapi.config.OntConfig;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;
import ru.avicomp.ontapi.config.OntWriterConfiguration;

public class OWLAdapter {
    private static OWLAdapter instance = new OWLAdapter();

    public static OWLAdapter get() {
        return instance;
    }

    public static void set(OWLAdapter adapter) {
        instance = Objects.requireNonNull(adapter, "Null adapter");
    }

    public OntologyManager asONT(OWLOntologyManager manager) {
        try {
            return (OntologyManager)manager;
        }
        catch (ClassCastException c) {
            throw new OntApiException("Wrong Ontology Manager", c);
        }
    }

    public DataFactory asONT(OWLDataFactory factory) {
        try {
            return (DataFactory)factory;
        }
        catch (ClassCastException c) {
            throw new OntApiException("Wrong Ontology Data Factory", c);
        }
    }

    public OntConfig asONT(OntologyConfigurator conf) {
        return conf instanceof OntConfig ? (OntConfig)conf : OntConfig.copy(conf);
    }

    public OntLoaderConfiguration asONT(OWLOntologyLoaderConfiguration conf) {
        return conf instanceof OntLoaderConfiguration ? (OntLoaderConfiguration)conf : new OntLoaderConfiguration(conf);
    }

    public OntWriterConfiguration asONT(OWLOntologyWriterConfiguration conf) {
        return conf instanceof OntWriterConfiguration ? (OntWriterConfiguration)conf : new OntWriterConfiguration(conf);
    }

    protected OntologyManagerImpl asIMPL(OWLOntologyManager manager) {
        return (OntologyManagerImpl)manager;
    }
}

