/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import ru.avicomp.ontapi.NoOpReadWriteLock;

public class OWLOntologyWrapper
implements OWLMutableOntology {
    protected final OWLOntology delegate;
    protected final ReadWriteLock lock;

    public OWLOntologyWrapper(OWLOntology delegate, ReadWriteLock lock) {
        this.delegate = Objects.requireNonNull(delegate, "Null delegate");
        this.lock = lock == null ? NoOpReadWriteLock.NO_OP_RW_LOCK : lock;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public boolean isConcurrent() {
        return NoOpReadWriteLock.NO_OP_RW_LOCK != this.lock;
    }

    protected <R> Stream<R> reduce(Stream<R> res) {
        return this.isConcurrent() ? res.collect(Collectors.toList()).stream() : res;
    }

    public int hashCode() {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean equals(@Nullable Object obj) {
        this.lock.readLock().lock();
        try {
            if (obj == this) {
                boolean bl = true;
                return bl;
            }
            if (obj instanceof OWLOntologyWrapper) {
                obj = ((OWLOntologyWrapper)obj).delegate;
            }
            boolean bl = this.delegate.equals(obj);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int compareTo(OWLObject o) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.compareTo((Object)o);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int typeIndex() {
        return this.delegate.typeIndex();
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        this.delegate.accept(visitor);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return (O)this.delegate.accept(visitor);
    }

    public void accept(OWLObjectVisitor visitor) {
        this.delegate.accept(visitor);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)this.delegate.accept(visitor);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        this.lock.readLock().lock();
        try {
            OWLOntologyManager oWLOntologyManager = this.delegate.getOWLOntologyManager();
            return oWLOntologyManager;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setOWLOntologyManager(@Nullable OWLOntologyManager manager) {
        this.lock.writeLock().lock();
        try {
            this.delegate.setOWLOntologyManager(manager);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public OWLOntologyID getOntologyID() {
        this.lock.readLock().lock();
        try {
            OWLOntologyID oWLOntologyID = this.delegate.getOntologyID();
            return oWLOntologyID;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isAnonymous() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.isAnonymous();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnnotation> getAnnotations() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAnnotations();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<IRI> getDirectImportsDocuments() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDirectImportsDocuments();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<IRI> directImportsDocuments() {
        this.lock.readLock().lock();
        try {
            Stream<IRI> stream = this.reduce(this.delegate.directImportsDocuments());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLOntology> getDirectImports() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDirectImports();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLOntology> directImports() {
        this.lock.readLock().lock();
        try {
            Stream<OWLOntology> stream = this.reduce(this.delegate.directImports());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLOntology> getImports() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getImports();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLOntology> imports() {
        this.lock.readLock().lock();
        try {
            Stream<OWLOntology> stream = this.reduce(this.delegate.imports());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLOntology> getImportsClosure() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getImportsClosure();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLOntology> importsClosure() {
        this.lock.readLock().lock();
        try {
            Stream<OWLOntology> stream = this.reduce(this.delegate.importsClosure());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getImportsDeclarations();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAxiom> getTBoxAxioms(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getTBoxAxioms(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAxiom> getABoxAxioms(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getABoxAxioms(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAxiom> getRBoxAxioms(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getRBoxAxioms(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAxiom> tboxAxioms(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAxiom> stream = this.reduce(this.delegate.tboxAxioms(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAxiom> aboxAxioms(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAxiom> stream = this.reduce(this.delegate.aboxAxioms(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAxiom> rboxAxioms(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAxiom> stream = this.reduce(this.delegate.rboxAxioms(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getGeneralClassAxioms();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLEntity> getSignature() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getSignature();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLEntity> getSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getSignature(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLClassAxiom> generalClassAxioms() {
        this.lock.readLock().lock();
        try {
            Stream<OWLClassAxiom> stream = this.reduce(this.delegate.generalClassAxioms());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLEntity> signature() {
        this.lock.readLock().lock();
        try {
            Stream<OWLEntity> stream = this.reduce(this.delegate.signature());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLEntity> signature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLEntity> stream = this.reduce(this.delegate.signature(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isDeclared(OWLEntity entity) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.isDeclared(entity);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeclared(OWLEntity entity, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.isDeclared(entity, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void saveOntology() throws OWLOntologyStorageException {
        this.lock.readLock().lock();
        try {
            this.delegate.saveOntology();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void saveOntology(IRI iri) throws OWLOntologyStorageException {
        this.lock.readLock().lock();
        try {
            this.delegate.saveOntology(iri);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void saveOntology(OutputStream stream) throws OWLOntologyStorageException {
        this.lock.readLock().lock();
        try {
            this.delegate.saveOntology(stream);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void saveOntology(OWLDocumentFormat format) throws OWLOntologyStorageException {
        this.lock.readLock().lock();
        try {
            this.delegate.saveOntology(format);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void saveOntology(OWLDocumentFormat format, IRI iri) throws OWLOntologyStorageException {
        this.lock.readLock().lock();
        try {
            this.delegate.saveOntology(format, iri);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void saveOntology(OWLDocumentFormat format, OutputStream stream) throws OWLOntologyStorageException {
        this.lock.readLock().lock();
        try {
            this.delegate.saveOntology(format, stream);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void saveOntology(OWLOntologyDocumentTarget target) throws OWLOntologyStorageException {
        this.lock.readLock().lock();
        try {
            this.delegate.saveOntology(target);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void saveOntology(OWLDocumentFormat format, OWLOntologyDocumentTarget target) throws OWLOntologyStorageException {
        this.lock.readLock().lock();
        try {
            this.delegate.saveOntology(format, target);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLClassExpression> getNestedClassExpressions() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getNestedClassExpressions();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsEntityInSignature(OWLEntity entity) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(entity);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsEntitiesOfTypeInSignature(type);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsEntitiesOfTypeInSignature(type, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAnonymousIndividuals();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLClass> getClassesInSignature() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getClassesInSignature();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getIndividualsInSignature();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDatatype> getDatatypesInSignature() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDatatypesInSignature();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAnnotationPropertiesInSignature();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAxiom> getAxioms(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getAxiomCount(Imports imports) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.getAxiomCount(imports);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getLogicalAxioms(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getLogicalAxiomCount(Imports imports) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.getLogicalAxiomCount(imports);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> type, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(type, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> type, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream stream = this.delegate.axioms(type, imports);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> type, Imports imports) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.getAxiomCount(type, imports);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiom(OWLAxiom axiom, Imports imports, AxiomAnnotations annotations) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsAxiom(axiom, imports, annotations);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(axiom, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAxiom> stream = this.reduce(this.delegate.axiomsIgnoreAnnotations(axiom, imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive primitive, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getReferencingAxioms(primitive, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive primitive, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAxiom> stream = this.reduce(this.delegate.referencingAxioms(primitive, imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClassAxiom> getAxioms(OWLClass clazz, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(clazz, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(property, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(property, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(individual, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(property, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(datatype, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAxiom> getAxioms() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAxiom> axioms() {
        this.lock.readLock().lock();
        try {
            Stream<OWLAxiom> stream = this.reduce(this.delegate.axioms());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getLogicalAxioms();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLLogicalAxiom> logicalAxioms() {
        this.lock.readLock().lock();
        try {
            Stream<OWLLogicalAxiom> stream = this.reduce(this.delegate.logicalAxioms());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> type) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(type);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> type) {
        this.lock.readLock().lock();
        try {
            Stream stream = this.delegate.axioms(type);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsAxiom(OWLAxiom axiom) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsAxiom(axiom);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAxiom> getAxioms(boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getAxiomCount(boolean b) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.getAxiomCount(b);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms(boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getLogicalAxioms(b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getLogicalAxiomCount(boolean b) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.getLogicalAxiomCount(b);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(axiomType, b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, boolean b) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.getAxiomCount(axiomType, b);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiom(OWLAxiom axiom, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsAxiom(axiom, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsAxiomIgnoreAnnotations(axiom, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom, boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(axiom, b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive, boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getReferencingAxioms(owlPrimitive, b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass, boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(owlClass, b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression, boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(owlObjectPropertyExpression, b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty, boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(owlDataProperty, b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual, boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(individual, b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property, boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(property, b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype, boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(owlDatatype, b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getAxiomCount() {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.getAxiomCount();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getLogicalAxiomCount() {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.getLogicalAxiomCount();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.getAxiomCount(axiomType);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsAxiomIgnoreAnnotations(axiom);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxiomsIgnoreAnnotations(axiom);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAxiom> stream = this.reduce(this.delegate.axiomsIgnoreAnnotations(axiom));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getReferencingAxioms(owlPrimitive);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive owlPrimitive) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAxiom> stream = this.reduce(this.delegate.referencingAxioms(owlPrimitive));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(owlClass);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(owlObjectPropertyExpression);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(owlDataProperty);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(individual);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(owlDatatype);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLClassAxiom> axioms(OWLClass owlClass) {
        this.lock.readLock().lock();
        try {
            Stream<OWLClassAxiom> stream = this.reduce(this.delegate.axioms(owlClass));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        this.lock.readLock().lock();
        try {
            Stream<OWLObjectPropertyAxiom> stream = this.reduce(this.delegate.axioms(owlObjectPropertyExpression));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty owlDataProperty) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDataPropertyAxiom> stream = this.reduce(this.delegate.axioms(owlDataProperty));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Stream<OWLIndividualAxiom> stream = this.reduce(this.delegate.axioms(individual));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotationAxiom> stream = this.reduce(this.delegate.axioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype owlDatatype) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDatatypeDefinitionAxiom> stream = this.reduce(this.delegate.axioms(owlDatatype));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLClass> getClassesInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getClassesInSignature(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getIndividualsInSignature(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getReferencedAnonymousIndividuals(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnonymousIndividual> stream = this.reduce(this.delegate.referencedAnonymousIndividuals(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals() {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnonymousIndividual> stream = this.reduce(this.delegate.referencedAnonymousIndividuals());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDatatype> getDatatypesInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDatatypesInSignature(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAnnotationPropertiesInSignature(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(OWLEntity entity, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(entity, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(IRI iri, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(iri, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsClassInSignature(IRI iri, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(iri, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObjectPropertyInSignature(IRI iri, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(iri, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDataPropertyInSignature(IRI iri, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(iri, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnnotationPropertyInSignature(IRI iri, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(iri, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatatypeInSignature(IRI iri, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(iri, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIndividualInSignature(IRI iri, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(iri, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsDatatypeInSignature(IRI iri) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(iri);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsEntityInSignature(IRI iri) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(iri);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsClassInSignature(IRI iri) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(iri);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsObjectPropertyInSignature(IRI iri) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(iri);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsDataPropertyInSignature(IRI iri) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(iri);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(iri);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsIndividualInSignature(IRI iri) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(iri);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<IRI> getPunnedIRIs(Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getPunnedIRIs(imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsReference(OWLEntity entity, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsReference(entity, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean containsReference(OWLEntity entity) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsReference(entity);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLEntity> entitiesInSignature(IRI iri) {
        this.lock.readLock().lock();
        try {
            Stream<OWLEntity> stream = this.reduce(this.delegate.entitiesInSignature(iri));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLClass> getClassesInSignature(boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getClassesInSignature(b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getObjectPropertiesInSignature(b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDataPropertiesInSignature(b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getIndividualsInSignature(b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getReferencedAnonymousIndividuals(b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDatatype> getDatatypesInSignature(boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDatatypesInSignature(b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAnnotationPropertiesInSignature(b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(OWLEntity entity, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(entity, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsEntityInSignature(IRI iri, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsEntityInSignature(iri, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsClassInSignature(IRI iri, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsClassInSignature(iri, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObjectPropertyInSignature(IRI iri, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsObjectPropertyInSignature(iri, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDataPropertyInSignature(IRI iri, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsDataPropertyInSignature(iri, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnnotationPropertyInSignature(IRI iri, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsAnnotationPropertyInSignature(iri, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatatypeInSignature(IRI iri, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsDatatypeInSignature(iri, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsIndividualInSignature(IRI iri, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsIndividualInSignature(iri, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLEntity> getEntitiesInSignature(IRI iri, boolean b) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getEntitiesInSignature(iri, b);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsReference(OWLEntity entity, boolean b) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsReference(entity, b);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, OWLObject object, Imports imports, Navigation navigation) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(type, object, imports, navigation);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, OWLObject object, Imports imports, Navigation navigation) {
        this.lock.readLock().lock();
        try {
            Stream stream = this.delegate.axioms(type, object, imports, navigation);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Collection<T> filterAxioms(OWLAxiomSearchFilter filter, Object o, Imports imports) {
        this.lock.readLock().lock();
        try {
            Collection collection = this.delegate.filterAxioms(filter, o, imports);
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(OWLAxiomSearchFilter filter, Object o, Imports imports) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.contains(filter, o, imports);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(OWLAxiomSearchFilter filter, Object o) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.contains(filter, o);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject object, Imports imports, Navigation navigation) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(type, explicitClass, object, imports, navigation);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject object, Imports imports, Navigation navigation) {
        this.lock.readLock().lock();
        try {
            Stream stream = this.delegate.axioms(type, explicitClass, object, imports, navigation);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(OWLAnnotationProperty property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getSubAnnotationPropertyOfAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAnnotationPropertyDomainAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAnnotationPropertyRangeAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnnotationPropertyDomainAxiom> annotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotationPropertyDomainAxiom> stream = this.reduce(this.delegate.annotationPropertyDomainAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnnotationPropertyRangeAxiom> annotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotationPropertyRangeAxiom> stream = this.reduce(this.delegate.annotationPropertyRangeAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity entity) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDeclarationAxioms(entity);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject subject) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAnnotationAssertionAxioms(subject);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getSubClassAxiomsForSubClass(clazz);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getSubClassAxiomsForSuperClass(clazz);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getEquivalentClassesAxioms(clazz);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDisjointClassesAxioms(clazz);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDisjointUnionAxioms(clazz);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLHasKeyAxiom> getHasKeyAxioms(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getHasKeyAxioms(clazz);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getObjectSubPropertyAxiomsForSubProperty(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getObjectSubPropertyAxiomsForSuperProperty(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getObjectPropertyDomainAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getObjectPropertyRangeAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getInverseObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getEquivalentObjectPropertiesAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDisjointObjectPropertiesAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getFunctionalObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getInverseFunctionalObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getSymmetricObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAsymmetricObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getReflexiveObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getIrreflexiveObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getTransitiveObjectPropertyAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(OWLDataProperty property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDataSubPropertyAxiomsForSubProperty(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDataSubPropertyAxiomsForSuperProperty(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(OWLDataProperty property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDataPropertyDomainAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(OWLDataProperty property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDataPropertyRangeAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(OWLDataProperty property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getEquivalentDataPropertiesAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(OWLDataProperty property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDisjointDataPropertiesAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getFunctionalDataPropertyAxioms(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getClassAssertionAxioms(individual);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClassExpression clazz) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getClassAssertionAxioms(clazz);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDataPropertyAssertionAxioms(individual);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getObjectPropertyAssertionAxioms(individual);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getNegativeObjectPropertyAssertionAxioms(individual);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getNegativeDataPropertyAssertionAxioms(individual);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getSameIndividualAxioms(individual);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDifferentIndividualAxioms(individual);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(OWLDatatype datatype) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getDatatypeDefinitions(datatype);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ChangeApplied applyChange(OWLOntologyChange change) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().applyChange(change);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeDetails applyChangesAndGetDetails(List<? extends OWLOntologyChange> list) {
        this.lock.writeLock().lock();
        try {
            ChangeDetails changeDetails = this.getMutableOntology().applyChangesAndGetDetails(list);
            return changeDetails;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied addAxiom(OWLAxiom axiom) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().addAxiom(axiom);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied addAxioms(Collection<? extends OWLAxiom> set) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().addAxioms(set);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied addAxioms(OWLAxiom ... set) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().addAxioms(set);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied add(OWLAxiom axiom) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().add(axiom);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied add(Collection<? extends OWLAxiom> set) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().add(set);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied add(OWLAxiom ... set) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.getMutableOntology().add(set);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private OWLMutableOntology getMutableOntology() {
        return (OWLMutableOntology)this.delegate;
    }

    public Stream<OWLImportsDeclaration> importsDeclarations() {
        this.lock.readLock().lock();
        try {
            Stream<OWLImportsDeclaration> stream = this.reduce(this.delegate.importsDeclarations());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key, Imports includeImportsClosure) {
        this.lock.readLock().lock();
        try {
            Stream stream = this.delegate.axioms(filter, key, includeImportsClosure);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key) {
        this.lock.readLock().lock();
        try {
            Stream stream = this.delegate.axioms(filter, key);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject entity, Navigation forSubPosition) {
        this.lock.readLock().lock();
        try {
            Stream stream = this.delegate.axioms(type, explicitClass, entity, forSubPosition);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLSubAnnotationPropertyOfAxiom> subAnnotationPropertyOfAxioms(OWLAnnotationProperty property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLSubAnnotationPropertyOfAxiom> stream = this.reduce(this.delegate.subAnnotationPropertyOfAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDatatypeDefinitionAxiom> datatypeDefinitions(OWLDatatype datatype) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDatatypeDefinitionAxiom> stream = this.reduce(this.delegate.datatypeDefinitions(datatype));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public ChangeApplied removeAxiom(OWLAxiom axiom) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.delegate.removeAxiom(axiom);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied removeAxioms(Collection<? extends OWLAxiom> axioms) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.delegate.removeAxioms(axioms);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied removeAxioms(OWLAxiom ... axioms) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.delegate.removeAxioms(axioms);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied remove(OWLAxiom axiom) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.delegate.remove(axiom);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied remove(Collection<? extends OWLAxiom> axioms) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.delegate.remove(axioms);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied remove(OWLAxiom ... axioms) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.delegate.remove(axioms);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ChangeApplied applyDirectChange(OWLOntologyChange change) {
        this.lock.writeLock().lock();
        try {
            ChangeApplied changeApplied = this.delegate.applyDirectChange(change);
            return changeApplied;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Stream<OWLDisjointObjectPropertiesAxiom> disjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDisjointObjectPropertiesAxiom> stream = this.reduce(this.delegate.disjointObjectPropertiesAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        this.lock.readLock().lock();
        try {
            Stream<OWLObjectProperty> stream = this.reduce(this.delegate.objectPropertiesInSignature());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotationAssertionAxiom> stream = this.reduce(this.delegate.annotationAssertionAxioms(entity));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotationAssertionAxiom> stream = this.reduce(this.delegate.annotationAssertionAxioms(entity, imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotationProperty> stream = this.reduce(this.delegate.annotationPropertiesInSignature());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotationProperty> stream = this.reduce(this.delegate.annotationPropertiesInSignature(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnnotation> annotations() {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotation> stream = this.reduce(this.delegate.annotations());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<OWLAnnotation> annotationsAsList() {
        this.lock.readLock().lock();
        try {
            List list = this.delegate.annotationsAsList();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnnotation> annotations(OWLAnnotationProperty p) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotation> stream = this.reduce(this.delegate.annotations(p));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnnotation> annotations(Predicate<OWLAnnotation> p) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotation> stream = this.reduce(this.delegate.annotations(p));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnonymousIndividual> stream = this.reduce(this.delegate.anonymousIndividuals());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAsymmetricObjectPropertyAxiom> asymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAsymmetricObjectPropertyAxiom> stream = this.reduce(this.delegate.asymmetricObjectPropertyAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, OWLObject entity, Navigation forSubPosition) {
        this.lock.readLock().lock();
        try {
            Stream stream = this.delegate.axioms(type, entity, forSubPosition);
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLAxiom> axioms(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAxiom> stream = this.reduce(this.delegate.axioms(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLAnnotationAxiom> stream = this.reduce(this.delegate.axioms(property, imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLClassAxiom> axioms(OWLClass clazz, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLClassAxiom> stream = this.reduce(this.delegate.axioms(clazz, imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDataPropertyAxiom> stream = this.reduce(this.delegate.axioms(property, imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDatatypeDefinitionAxiom> stream = this.reduce(this.delegate.axioms(datatype, imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLIndividualAxiom> stream = this.reduce(this.delegate.axioms(individual, imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLObjectPropertyAxiom> stream = this.reduce(this.delegate.axioms(property, imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLClassExpression ce) {
        this.lock.readLock().lock();
        try {
            Stream<OWLClassAssertionAxiom> stream = this.reduce(this.delegate.classAssertionAxioms(ce));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Stream<OWLClassAssertionAxiom> stream = this.reduce(this.delegate.classAssertionAxioms(individual));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLClass> classesInSignature() {
        this.lock.readLock().lock();
        try {
            Stream<OWLClass> stream = this.reduce(this.delegate.classesInSignature());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLClass> classesInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLClass> stream = this.reduce(this.delegate.classesInSignature(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        this.lock.readLock().lock();
        try {
            Stream<OWLDataProperty> stream = this.reduce(this.delegate.dataPropertiesInSignature());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDataProperty> stream = this.reduce(this.delegate.dataPropertiesInSignature(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDataPropertyAssertionAxiom> dataPropertyAssertionAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDataPropertyAssertionAxiom> stream = this.reduce(this.delegate.dataPropertyAssertionAxioms(individual));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDataPropertyDomainAxiom> dataPropertyDomainAxioms(OWLDataProperty property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDataPropertyDomainAxiom> stream = this.reduce(this.delegate.dataPropertyDomainAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDataPropertyRangeAxiom> dataPropertyRangeAxioms(OWLDataProperty property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDataPropertyRangeAxiom> stream = this.reduce(this.delegate.dataPropertyRangeAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSubProperty(OWLDataProperty property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLSubDataPropertyOfAxiom> stream = this.reduce(this.delegate.dataSubPropertyAxiomsForSubProperty(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLSubDataPropertyOfAxiom> stream = this.reduce(this.delegate.dataSubPropertyAxiomsForSuperProperty(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDatatype> datatypesInSignature() {
        this.lock.readLock().lock();
        try {
            Stream<OWLDatatype> stream = this.reduce(this.delegate.datatypesInSignature());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDatatype> datatypesInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDatatype> stream = this.reduce(this.delegate.datatypesInSignature(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDeclarationAxiom> declarationAxioms(OWLEntity subject) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDeclarationAxiom> stream = this.reduce(this.delegate.declarationAxioms(subject));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDifferentIndividualsAxiom> differentIndividualAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDifferentIndividualsAxiom> stream = this.reduce(this.delegate.differentIndividualAxioms(individual));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDisjointClassesAxiom> disjointClassesAxioms(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDisjointClassesAxiom> stream = this.reduce(this.delegate.disjointClassesAxioms(clazz));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDisjointDataPropertiesAxiom> disjointDataPropertiesAxioms(OWLDataProperty property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDisjointDataPropertiesAxiom> stream = this.reduce(this.delegate.disjointDataPropertiesAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLDisjointUnionAxiom> disjointUnionAxioms(OWLClass owlClass) {
        this.lock.readLock().lock();
        try {
            Stream<OWLDisjointUnionAxiom> stream = this.reduce(this.delegate.disjointUnionAxioms(owlClass));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<OWLEntity> entitiesInSignature(IRI iri, Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLEntity> stream = this.reduce(this.delegate.entitiesInSignature(iri, imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLEquivalentClassesAxiom> equivalentClassesAxioms(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Stream<OWLEquivalentClassesAxiom> stream = this.reduce(this.delegate.equivalentClassesAxioms(clazz));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLEquivalentDataPropertiesAxiom> equivalentDataPropertiesAxioms(OWLDataProperty property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLEquivalentDataPropertiesAxiom> stream = this.reduce(this.delegate.equivalentDataPropertiesAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLEquivalentObjectPropertiesAxiom> equivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLEquivalentObjectPropertiesAxiom> stream = this.reduce(this.delegate.equivalentObjectPropertiesAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Collection<T> filterAxioms(OWLAxiomSearchFilter filter, Object key) {
        this.lock.readLock().lock();
        try {
            Collection collection = this.delegate.filterAxioms(filter, key);
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLFunctionalDataPropertyAxiom> stream = this.reduce(this.delegate.functionalDataPropertyAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLFunctionalObjectPropertyAxiom> stream = this.reduce(this.delegate.functionalObjectPropertyAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject entity, Imports imports) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAnnotationAssertionAxioms(entity, imports);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnnotation> getAnnotations(OWLAnnotationProperty property) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAnnotations(property);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject entity, Navigation forSubPosition) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(type, explicitClass, entity, forSubPosition);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, OWLObject entity, Navigation navigation) {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getAxioms(type, entity, navigation);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Nullable
    public OWLDocumentFormat getFormat() {
        this.lock.readLock().lock();
        try {
            OWLDocumentFormat oWLDocumentFormat = this.delegate.getFormat();
            return oWLDocumentFormat;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals() {
        this.lock.readLock().lock();
        try {
            Set set = this.delegate.getReferencedAnonymousIndividuals();
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLHasKeyAxiom> hasKeyAxioms(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Stream<OWLHasKeyAxiom> stream = this.reduce(this.delegate.hasKeyAxioms(clazz));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLNamedIndividual> individualsInSignature() {
        this.lock.readLock().lock();
        try {
            Stream<OWLNamedIndividual> stream = this.reduce(this.delegate.individualsInSignature());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLNamedIndividual> individualsInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLNamedIndividual> stream = this.reduce(this.delegate.individualsInSignature(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLInverseFunctionalObjectPropertyAxiom> stream = this.reduce(this.delegate.inverseFunctionalObjectPropertyAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLInverseObjectPropertiesAxiom> inverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLInverseObjectPropertiesAxiom> stream = this.reduce(this.delegate.inverseObjectPropertyAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLIrreflexiveObjectPropertyAxiom> irreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLIrreflexiveObjectPropertyAxiom> stream = this.reduce(this.delegate.irreflexiveObjectPropertyAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLLogicalAxiom> logicalAxioms(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLLogicalAxiom> stream = this.reduce(this.delegate.logicalAxioms(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLNegativeDataPropertyAssertionAxiom> negativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Stream<OWLNegativeDataPropertyAssertionAxiom> stream = this.reduce(this.delegate.negativeDataPropertyAssertionAxioms(individual));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLNegativeObjectPropertyAssertionAxiom> negativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Stream<OWLNegativeObjectPropertyAssertionAxiom> stream = this.reduce(this.delegate.negativeObjectPropertyAssertionAxioms(individual));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLClassExpression> nestedClassExpressions() {
        this.lock.readLock().lock();
        try {
            Stream<OWLClassExpression> stream = this.reduce(this.delegate.nestedClassExpressions());
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature(Imports imports) {
        this.lock.readLock().lock();
        try {
            Stream<OWLObjectProperty> stream = this.reduce(this.delegate.objectPropertiesInSignature(imports));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLObjectPropertyAssertionAxiom> objectPropertyAssertionAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Stream<OWLObjectPropertyAssertionAxiom> stream = this.reduce(this.delegate.objectPropertyAssertionAxioms(individual));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLObjectPropertyDomainAxiom> objectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLObjectPropertyDomainAxiom> stream = this.reduce(this.delegate.objectPropertyDomainAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLObjectPropertyRangeAxiom> objectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLObjectPropertyRangeAxiom> stream = this.reduce(this.delegate.objectPropertyRangeAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLSubObjectPropertyOfAxiom> stream = this.reduce(this.delegate.objectSubPropertyAxiomsForSubProperty(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLSubObjectPropertyOfAxiom> stream = this.reduce(this.delegate.objectSubPropertyAxiomsForSuperProperty(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLReflexiveObjectPropertyAxiom> reflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLReflexiveObjectPropertyAxiom> stream = this.reduce(this.delegate.reflexiveObjectPropertyAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLSameIndividualAxiom> sameIndividualAxioms(OWLIndividual individual) {
        this.lock.readLock().lock();
        try {
            Stream<OWLSameIndividualAxiom> stream = this.reduce(this.delegate.sameIndividualAxioms(individual));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSubClass(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Stream<OWLSubClassOfAxiom> stream = this.reduce(this.delegate.subClassAxiomsForSubClass(clazz));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSuperClass(OWLClass clazz) {
        this.lock.readLock().lock();
        try {
            Stream<OWLSubClassOfAxiom> stream = this.reduce(this.delegate.subClassAxiomsForSuperClass(clazz));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLSymmetricObjectPropertyAxiom> symmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLSymmetricObjectPropertyAxiom> stream = this.reduce(this.delegate.symmetricObjectPropertyAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Stream<OWLTransitiveObjectPropertyAxiom> transitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        this.lock.readLock().lock();
        try {
            Stream<OWLTransitiveObjectPropertyAxiom> stream = this.reduce(this.delegate.transitiveObjectPropertyAxioms(property));
            return stream;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

