/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.util.concurrent.locks.ReadWriteLock;
import org.apache.jena.graph.Graph;
import org.semanticweb.owlapi.model.OWLOntologyID;
import ru.avicomp.ontapi.NoOpReadWriteLock;
import ru.avicomp.ontapi.OWLAdapter;
import ru.avicomp.ontapi.OntologyFactory;
import ru.avicomp.ontapi.OntologyManager;
import ru.avicomp.ontapi.OntologyManagerImpl;
import ru.avicomp.ontapi.OntologyModel;
import ru.avicomp.ontapi.OntologyModelImpl;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;
import ru.avicomp.ontapi.jena.OntModelFactory;

public class OntologyBuilderImpl
implements OntologyFactory.Builder {
    @Override
    public OntologyModel createOntology(OntologyManager manager, OWLOntologyID id) {
        OntologyManagerImpl m = OWLAdapter.get().asIMPL(manager);
        OntologyModelImpl res = this.createOntologyImpl(this.createGraph(), m, m.getOntologyLoaderConfiguration());
        res.setOntologyID(id);
        return this.withLock(res, m.getLock());
    }

    @Override
    public OntologyModel createOntology(Graph graph, OntologyManager manager, OntLoaderConfiguration config) {
        OntologyManagerImpl m = OWLAdapter.get().asIMPL(manager);
        return this.withLock(this.createOntologyImpl(graph, m, config), m.getLock());
    }

    public OntologyModelImpl createOntologyImpl(Graph graph, OntologyManagerImpl manager, OntLoaderConfiguration config) {
        OntologyManagerImpl.ModelConfig modelConfig = manager.createModelConfig();
        if (config != null) {
            modelConfig.setLoaderConf(config);
        }
        return new OntologyModelImpl(graph, modelConfig);
    }

    public OntologyModel withLock(OntologyModelImpl ont, ReadWriteLock lock) {
        if (NoOpReadWriteLock.NO_OP_RW_LOCK.equals(lock)) {
            return ont;
        }
        return new OntologyModelImpl.Concurrent(ont, lock);
    }

    @Override
    public Graph createGraph() {
        return OntModelFactory.createDefaultGraph();
    }
}

