/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.jena.graph.Graph;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import ru.avicomp.ontapi.OWLAdapter;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntologyManager;
import ru.avicomp.ontapi.OntologyModel;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;

public interface OntologyFactory
extends OWLOntologyFactory {
    public OntologyModel createOntology(OntologyManager var1, OWLOntologyID var2) throws OntApiException;

    public OntologyModel loadOntology(OntologyManager var1, OWLOntologyDocumentSource var2, OntLoaderConfiguration var3) throws OWLOntologyCreationException, OntApiException;

    default public boolean canCreateFromDocumentIRI(@Nonnull IRI iri) {
        return true;
    }

    default public boolean canAttemptLoading(@Nonnull OWLOntologyDocumentSource source) {
        return true;
    }

    default public OntologyModel createOWLOntology(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntologyID id, @Nonnull IRI documentIRI, @Nonnull OWLOntologyFactory.OWLOntologyCreationHandler handler) {
        return this.createOntology(OWLAdapter.get().asONT(manager), id);
    }

    default public OntologyModel loadOWLOntology(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntologyDocumentSource source, @Nonnull OWLOntologyFactory.OWLOntologyCreationHandler handler, @Nonnull OWLOntologyLoaderConfiguration config) throws OWLOntologyCreationException {
        return this.loadOntology(OWLAdapter.get().asONT(manager), source, OWLAdapter.get().asONT(config));
    }

    public static interface Loader
    extends Serializable {
        public OntologyModel load(OWLOntologyDocumentSource var1, OntologyManager var2, OntLoaderConfiguration var3) throws OWLOntologyCreationException;
    }

    public static interface Builder
    extends OWLOntologyBuilder {
        public OntologyModel createOntology(OntologyManager var1, OWLOntologyID var2);

        public OntologyModel createOntology(Graph var1, OntologyManager var2, OntLoaderConfiguration var3);

        public Graph createGraph();

        default public OntologyModel createOWLOntology(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntologyID id) {
            return this.createOntology(OWLAdapter.get().asONT(manager), id);
        }
    }
}

