/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import ru.avicomp.ontapi.OWLAdapter;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntFormat;
import ru.avicomp.ontapi.OntologyFactory;
import ru.avicomp.ontapi.OntologyManager;
import ru.avicomp.ontapi.OntologyModel;
import ru.avicomp.ontapi.config.OntLoaderConfiguration;
import ru.avicomp.ontapi.transforms.TransformException;

public class OntologyFactoryImpl
implements OntologyFactory {
    protected final OntologyFactory.Builder builder;
    protected final OntologyFactory.Loader loader;

    public OntologyFactoryImpl(OntologyFactory.Builder builder, OntologyFactory.Loader loader) {
        this.builder = Objects.requireNonNull(builder, "Null builder");
        this.loader = Objects.requireNonNull(loader, "Null loader");
    }

    @Override
    public OntologyModel createOntology(OntologyManager manager, OWLOntologyID id) {
        OntologyModel res = this.builder.createOWLOntology(manager, id);
        OWLAdapter.get().asIMPL(manager).ontologyCreated(res);
        manager.setOntologyFormat(res, OntFormat.TURTLE.createOwlFormat());
        return res;
    }

    @Override
    public OntologyModel loadOntology(OntologyManager manager, OWLOntologyDocumentSource source, OntLoaderConfiguration configuration) throws OWLOntologyCreationException {
        return this.loader.load(source, manager, configuration);
    }

    static {
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)ErrorHandlerFactory.errorHandlerNoLogging);
    }

    public static class OWLTransformException
    extends OWLOntologyCreationException {
        public OWLTransformException(TransformException cause) {
            super(cause.getMessage(), (Throwable)(cause.getCause() == null ? cause : cause.getCause()));
        }
    }

    public static class BadRecursionException
    extends OWLOntologyCreationException {
        public BadRecursionException(String message) {
            super(message);
        }
    }

    public static class UnsupportedFormatException
    extends OWLOntologyCreationException {
        private OntFormat format;
        private IRI source;

        public UnsupportedFormatException(String message) {
            super(message);
        }

        public UnsupportedFormatException(Throwable cause) {
            super(cause);
        }

        public UnsupportedFormatException putFormat(OntFormat format) {
            this.format = OntApiException.notNull(format, "Null format");
            return this;
        }

        public UnsupportedFormatException putSource(IRI iri) {
            this.source = OntApiException.notNull(iri, "Null source");
            return this;
        }

        public String getMessage() {
            Throwable cause = this.getCause();
            String msg = super.getMessage();
            if (this.format != null && this.source != null && cause != null) {
                String suffix = String.format("Format: %s. IRI: <%s>. Cause: '%s'", new Object[]{this.format, this.source, cause.getMessage()});
                msg = StringUtils.isEmpty((CharSequence)msg) ? suffix : msg + ". " + suffix;
            }
            return msg;
        }
    }

    public static class ConfigMismatchException
    extends OWLOntologyCreationException {
        public ConfigMismatchException(String s) {
            super(s);
        }
    }
}

