/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.io.OWLOntologyLoaderMetaData;
import org.semanticweb.owlapi.io.RDFOntologyHeaderStatus;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import ru.avicomp.ontapi.OntGraphUtils;
import ru.avicomp.ontapi.jena.utils.Graphs;
import ru.avicomp.ontapi.jena.vocabulary.OWL;
import ru.avicomp.ontapi.jena.vocabulary.RDF;
import ru.avicomp.ontapi.transforms.GraphTransformers;
import ru.avicomp.ontapi.transforms.OWLIDTransform;

public class OntologyMetaData
implements OWLOntologyLoaderMetaData {
    private static final long serialVersionUID = -1L;
    private final transient Graph graph;
    private Integer count;
    private final RDFOntologyHeaderStatus header;
    private final Set<RDFTriple> unparsed;
    private final ArrayListMultimap<IRI, Class<? extends OWLObject>> guessed;

    protected OntologyMetaData(Graph graph, RDFOntologyHeaderStatus header, Set<RDFTriple> unparsed, ArrayListMultimap<IRI, Class<? extends OWLObject>> guessed) {
        this.graph = graph;
        this.header = header;
        this.unparsed = unparsed;
        this.guessed = guessed;
    }

    public static OntologyMetaData createParserMetaData(Graph graph) {
        return new OntologyMetaData(Graphs.getBase(Objects.requireNonNull(graph, "Null graph")), RDFOntologyHeaderStatus.PARSED_ONE_HEADER, Collections.emptySet(), (ArrayListMultimap<IRI, Class<? extends OWLObject>>)ArrayListMultimap.create());
    }

    public static OntologyMetaData createParserMetaData(GraphTransformers.Stats stats) {
        Graph graph = Graphs.getBase(Objects.requireNonNull(stats, "Null graph").getGraph());
        RDFOntologyHeaderStatus header = RDFOntologyHeaderStatus.PARSED_ONE_HEADER;
        String idKey = OWLIDTransform.class.getSimpleName();
        if (stats.hasTriples(GraphTransformers.Stats.Type.ADDED, idKey)) {
            header = RDFOntologyHeaderStatus.PARSED_ZERO_HEADERS;
        }
        if (stats.hasTriples(GraphTransformers.Stats.Type.DELETED, idKey)) {
            header = RDFOntologyHeaderStatus.PARSED_MULTIPLE_HEADERS;
        }
        Set<RDFTriple> unparsed = stats.triples(GraphTransformers.Stats.Type.UNPARSED).map(OntGraphUtils::triple).collect(Collectors.toSet());
        ArrayListMultimap guessedDeclarations = ArrayListMultimap.create();
        stats.triples(GraphTransformers.Stats.Type.ADDED).collect(Collectors.toSet()).forEach(t -> {
            IRI iri = IRI.create((String)t.getSubject().toString());
            Class<? extends OWLObject> type = OntologyMetaData.guessTripleType(t);
            guessedDeclarations.put((Object)iri, type);
        });
        return new OntologyMetaData(graph, header, unparsed, (ArrayListMultimap<IRI, Class<? extends OWLObject>>)guessedDeclarations);
    }

    protected static Class<? extends OWLObject> guessTripleType(Triple t) {
        if (!RDF.type.asNode().equals((Object)t.getPredicate())) {
            return OWLObject.class;
        }
        Resource obj = ResourceFactory.createResource((String)t.getObject().toString());
        if (OWL.Ontology.equals((Object)obj)) {
            return OWLOntology.class;
        }
        if (t.getSubject().isURI() && t.getObject().isURI()) {
            if (OWL.Class.equals((Object)obj)) {
                return OWLClass.class;
            }
            if (RDFS.Datatype.equals((Object)obj)) {
                return OWLDatatype.class;
            }
            if (OWL.NamedIndividual.equals((Object)obj)) {
                return OWLNamedIndividual.class;
            }
            if (OWL.ObjectProperty.equals((Object)obj)) {
                return OWLObjectProperty.class;
            }
            if (OWL.DatatypeProperty.equals((Object)obj)) {
                return OWLDataProperty.class;
            }
            if (OWL.AnnotationProperty.equals((Object)obj)) {
                return OWLAnnotationProperty.class;
            }
        }
        if (OWL.Class.equals((Object)obj) || OWL.Restriction.equals((Object)obj)) {
            return OWLClassExpression.class;
        }
        if (RDFS.Datatype.equals((Object)obj)) {
            return OWLDataRange.class;
        }
        return OWLObject.class;
    }

    public int getTripleCount() {
        return this.count == null ? (this.count = Integer.valueOf(this.calcTripleCount())) : this.count;
    }

    protected int calcTripleCount() {
        return this.graph instanceof GraphMem ? this.graph.size() : -1;
    }

    public RDFOntologyHeaderStatus getHeaderState() {
        return this.header;
    }

    public Stream<RDFTriple> getUnparsedTriples() {
        return this.unparsed.stream();
    }

    public Multimap<IRI, Class<?>> getGuessedDeclarations() {
        return Multimaps.unmodifiableMultimap(this.guessed);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getTripleCount();
        out.defaultWriteObject();
    }
}

