/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi;

import com.google.common.collect.LinkedListMultimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.avicomp.ontapi.OntApiException;

class ReflectionUtils {
    ReflectionUtils() {
    }

    static Method findStaticMethod(Class<?> clazz, String name) throws OntApiException {
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new OntApiException("Can't find method '" + name + "' in " + clazz, e);
        }
    }

    static <R> R newProxy(Class<R> interfaceType, InvocationHandler handler) {
        Objects.requireNonNull(handler);
        if (!Objects.requireNonNull(interfaceType).isInterface()) {
            throw new OntApiException(interfaceType + " is not an interface");
        }
        Object object = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return interfaceType.cast(object);
    }

    static <R> R newInstance(Class<? extends R> interfaceType, String className, LinkedListMultimap<Class<?>, Object> constructorParams) {
        Constructor<R> constructor;
        Class<R> clazz = ReflectionUtils.getClass(interfaceType, className);
        String name = MessageFormat.format("{0}({1})", clazz.getName(), constructorParams.keys().stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
        try {
            constructor = clazz.getConstructor((Class[])constructorParams.keys().toArray((Object[])new Class[constructorParams.size()]));
        }
        catch (NoSuchMethodException e) {
            throw new OntApiException("Unable to find constructor " + name, e);
        }
        try {
            return constructor.newInstance(constructorParams.values().toArray());
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new OntApiException("Can't init " + name);
        }
    }

    static <R> R newInstance(Class<R> type) throws OntApiException {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OntApiException("Can't create instance of " + type.getName(), e);
        }
    }

    static <R> Class<R> findClass(Class<R> interfaceType, String className) throws OntApiException {
        Class<?> res;
        try {
            res = ReflectionUtils.getClass(className);
        }
        catch (OntApiException e) {
            return null;
        }
        if (interfaceType.isAssignableFrom(res)) {
            return res;
        }
        throw new OntApiException(className + " is not subtype of " + interfaceType.getName());
    }

    static <R> Class<R> getClass(Class<R> interfaceType, String className) throws OntApiException {
        Class<?> res = ReflectionUtils.getClass(className);
        if (interfaceType.isAssignableFrom(res)) {
            return res;
        }
        throw new OntApiException(className + " is not subtype of " + interfaceType.getName());
    }

    static Class<?> getClass(String name) throws OntApiException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new OntApiException("No " + name + " in class-path found. Please include corresponding library to the maven dependencies.", e);
        }
    }
}

