/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.config;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.config.OntConfig;
import ru.avicomp.ontapi.config.OntSettings;
import ru.avicomp.ontapi.jena.impl.conf.OntPersonality;
import ru.avicomp.ontapi.transforms.GraphTransformers;

public class OntLoaderConfiguration
extends OWLOntologyLoaderConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntLoaderConfiguration.class);
    private static final long serialVersionUID = 1599596390911768315L;
    protected final Map<OntConfig.OptionSetting, Object> map = new HashMap<OntConfig.OptionSetting, Object>();
    protected transient OntPersonality personality;
    protected GraphTransformers.Store transformers;

    public OntLoaderConfiguration(OWLOntologyLoaderConfiguration owl) {
        if (owl == null) {
            return;
        }
        if (owl instanceof OntLoaderConfiguration) {
            this.copyONTSettings((OntLoaderConfiguration)owl);
        } else {
            this.copyOWLSettings(owl);
        }
    }

    protected OntLoaderConfiguration copy(OWLOntologyLoaderConfiguration owl) {
        return new OntLoaderConfiguration(owl);
    }

    protected Object get(OntConfig.OptionSetting key) {
        return key.fromMap(this.map);
    }

    protected OntLoaderConfiguration set(OntConfig.OptionSetting key, Object o) {
        if (Objects.equals(this.get(key), o)) {
            return this;
        }
        OntLoaderConfiguration copy = this.copy(this);
        copy.map.put(key, o);
        return copy;
    }

    protected void copyOWLSettings(OWLOntologyLoaderConfiguration conf) {
        this.map.put(OntSettings.OWL_API_LOAD_CONF_IGNORED_IMPORTS, new ArrayList<IRI>(OntLoaderConfiguration.ignoredImports(conf)));
        this.map.put(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION, conf.isAcceptingHTTPCompression());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT, conf.getConnectionTimeout());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS, conf.isFollowRedirects());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS, conf.isLoadAnnotationAxioms());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY, conf.getMissingImportHandlingStrategy());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY, conf.getMissingOntologyHeaderStrategy());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES, conf.isReportStackTrace());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT, conf.getRetriesToAttempt());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION, conf.isStrict());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN, conf.isTreatDublinCoreAsBuiltIn());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING, conf.getPriorityCollectionSorting());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS, conf.getBannedParsers());
        this.map.put(OntSettings.OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT, conf.getEntityExpansionLimit());
        this.map.put(OntSettings.OWL_API_AUTHORIZATION_VALUE, conf.getAuthorizationValue());
    }

    protected void copyONTSettings(OntLoaderConfiguration conf) {
        this.personality = conf.getPersonality();
        this.transformers = conf.getGraphTransformers();
        this.map.putAll(conf.map);
    }

    protected static Set<IRI> ignoredImports(OWLOntologyLoaderConfiguration owl) {
        try {
            Field field = owl.getClass().getDeclaredField("ignoredImports");
            field.setAccessible(true);
            return (Set)field.get(owl);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            throw new OntApiException("Can't get OWLOntologyLoaderConfiguration#ignoredImports.", e);
        }
    }

    public boolean isPerformTransformation() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_PERFORM_TRANSFORMATIONS);
    }

    public OntLoaderConfiguration setPerformTransformation(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_PERFORM_TRANSFORMATIONS, b);
    }

    public GraphTransformers.Store getGraphTransformers() {
        return this.transformers == null ? (this.transformers = OntConfig.getDefaultTransformers()) : this.transformers;
    }

    public OntLoaderConfiguration setGraphTransformers(GraphTransformers.Store t) {
        if (Objects.equals(this.transformers, t)) {
            return this;
        }
        OntLoaderConfiguration res = this.copy(this);
        res.transformers = t;
        return res;
    }

    public OntPersonality getPersonality() {
        return this.personality == null ? (this.personality = OntConfig.getDefaultPersonality()) : this.personality;
    }

    public OntLoaderConfiguration setPersonality(OntPersonality p) {
        if (Objects.equals((Object)this.personality, (Object)p)) {
            return this;
        }
        OntLoaderConfiguration res = this.copy(this);
        res.personality = p;
        return res;
    }

    public List<OntConfig.Scheme> getSupportedSchemes() {
        return (List)this.get(OntSettings.ONT_API_LOAD_CONF_SUPPORTED_SCHEMES);
    }

    public OntLoaderConfiguration setSupportedSchemes(List<OntConfig.Scheme> schemes) {
        ArrayList res = schemes instanceof Serializable ? schemes : new ArrayList(schemes);
        return this.set(OntSettings.ONT_API_LOAD_CONF_SUPPORTED_SCHEMES, res);
    }

    public OntLoaderConfiguration disableWebAccess() {
        return this.setSupportedSchemes(Collections.singletonList(OntConfig.DefaultScheme.FILE));
    }

    public boolean isAllowBulkAnnotationAssertions() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_ALLOW_BULK_ANNOTATION_ASSERTIONS);
    }

    public OntLoaderConfiguration setAllowBulkAnnotationAssertions(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_ALLOW_BULK_ANNOTATION_ASSERTIONS, b);
    }

    public boolean isAllowReadDeclarations() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_ALLOW_READ_DECLARATIONS);
    }

    public OntLoaderConfiguration setAllowReadDeclarations(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_ALLOW_READ_DECLARATIONS, b);
    }

    public boolean isIgnoreAnnotationAxiomOverlaps() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_IGNORE_ANNOTATION_AXIOM_OVERLAPS);
    }

    public OntLoaderConfiguration setIgnoreAnnotationAxiomOverlaps(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_IGNORE_ANNOTATION_AXIOM_OVERLAPS, b);
    }

    public boolean isUseOWLParsersToLoad() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_USE_OWL_PARSERS_TO_LOAD);
    }

    public OntLoaderConfiguration setUseOWLParsersToLoad(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_USE_OWL_PARSERS_TO_LOAD, b);
    }

    public boolean isIgnoreAxiomsReadErrors() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_IGNORE_AXIOMS_READ_ERRORS);
    }

    public OntLoaderConfiguration setIgnoreAxiomsReadErrors(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_IGNORE_AXIOMS_READ_ERRORS, b);
    }

    public boolean isSplitAxiomAnnotations() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_SPLIT_AXIOM_ANNOTATIONS);
    }

    public OntLoaderConfiguration setSplitAxiomAnnotations(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_SPLIT_AXIOM_ANNOTATIONS, b);
    }

    public boolean isLoadAnnotationAxioms() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS);
    }

    public OntLoaderConfiguration setLoadAnnotationAxioms(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS, b);
    }

    protected List<String> getIgnoredImports() {
        return (List)this.map.computeIfAbsent(OntSettings.OWL_API_LOAD_CONF_IGNORED_IMPORTS, OntConfig.OptionSetting::getDefaultValue);
    }

    public OntLoaderConfiguration addIgnoredImport(@Nonnull IRI iri) {
        if (this.getIgnoredImports().contains(iri.getIRIString())) {
            return this;
        }
        OntLoaderConfiguration res = this.copy(this);
        res.getIgnoredImports().add(iri.getIRIString());
        return res;
    }

    public OntLoaderConfiguration clearIgnoredImports() {
        if (this.getIgnoredImports().isEmpty()) {
            return this;
        }
        OntLoaderConfiguration res = this.copy(this);
        res.getIgnoredImports().clear();
        return res;
    }

    public boolean isIgnoredImport(@Nonnull IRI iri) {
        return Namespaces.isDefaultIgnoredImport((IRI)iri) || this.getIgnoredImports().contains(iri.getIRIString());
    }

    public OntLoaderConfiguration removeIgnoredImport(@Nonnull IRI iri) {
        if (!this.getIgnoredImports().contains(iri.getIRIString())) {
            return this;
        }
        OntLoaderConfiguration res = this.copy(this);
        res.getIgnoredImports().remove(iri.getIRIString());
        return res;
    }

    public PriorityCollectionSorting getPriorityCollectionSorting() {
        return (PriorityCollectionSorting)this.get(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING);
    }

    public OntLoaderConfiguration setPriorityCollectionSorting(PriorityCollectionSorting sorting) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING, sorting);
    }

    public int getConnectionTimeout() {
        return (Integer)this.get(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT);
    }

    public OntLoaderConfiguration setConnectionTimeout(int time) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT, time);
    }

    public MissingImportHandlingStrategy getMissingImportHandlingStrategy() {
        return (MissingImportHandlingStrategy)this.get(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY);
    }

    public OntLoaderConfiguration setMissingImportHandlingStrategy(@Nonnull MissingImportHandlingStrategy strategy) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY, strategy);
    }

    public MissingOntologyHeaderStrategy getMissingOntologyHeaderStrategy() {
        return (MissingOntologyHeaderStrategy)this.get(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY);
    }

    public OntLoaderConfiguration setMissingOntologyHeaderStrategy(@Nonnull MissingOntologyHeaderStrategy strategy) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY, strategy);
    }

    public int getRetriesToAttempt() {
        return (Integer)this.get(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT);
    }

    public OntLoaderConfiguration setRetriesToAttempt(int retries) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT, retries);
    }

    public boolean isAcceptingHTTPCompression() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION);
    }

    public OntLoaderConfiguration setAcceptingHTTPCompression(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION, b);
    }

    public boolean isFollowRedirects() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS);
    }

    public OntLoaderConfiguration setFollowRedirects(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS, b);
    }

    public boolean isReportStackTrace() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES);
    }

    public OntLoaderConfiguration setReportStackTraces(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES, b);
    }

    public boolean isStrict() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION);
    }

    public OntLoaderConfiguration setStrict(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION, b);
    }

    public boolean isTreatDublinCoreAsBuiltIn() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN);
    }

    public OntLoaderConfiguration setTreatDublinCoreAsBuiltIn(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN, b);
    }

    public String getBannedParsers() {
        return (String)this.get(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS);
    }

    public OntLoaderConfiguration setBannedParsers(@Nonnull String s) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS, s);
    }

    public String getEntityExpansionLimit() {
        return (String)this.get(OntSettings.OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT);
    }

    public OntLoaderConfiguration setEntityExpansionLimit(@Nonnull String s) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT, s);
    }

    public String getAuthorizationValue() {
        return (String)this.get(OntSettings.OWL_API_AUTHORIZATION_VALUE);
    }

    public OntLoaderConfiguration setAuthorizationValue(@Nonnull String s) {
        return this.set(OntSettings.OWL_API_AUTHORIZATION_VALUE, s);
    }

    public boolean shouldTrimToSize() {
        LOGGER.warn("ONT-API does not support TrimToSize");
        return true;
    }

    public OntLoaderConfiguration setTrimToSize(boolean b) {
        LOGGER.warn("ONT-API does not support TrimToSize");
        return this;
    }

    public boolean shouldRepairIllegalPunnings() {
        LOGGER.warn("ONT-API does not support RepairIllegalPunnings");
        return true;
    }

    public OntLoaderConfiguration setRepairIllegalPunnings(boolean b) {
        LOGGER.warn("ONT-API does not support RepairIllegalPunnings");
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OntLoaderConfiguration)) {
            return false;
        }
        OntLoaderConfiguration that = (OntLoaderConfiguration)((Object)o);
        return Objects.equals((Object)this.getPersonality(), (Object)that.getPersonality()) && Objects.equals(this.getGraphTransformers(), that.getGraphTransformers()) && Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getPersonality(), this.getGraphTransformers(), this.map});
    }
}

