/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.config.ExtendedProperties;
import ru.avicomp.ontapi.config.OntConfig;
import ru.avicomp.ontapi.jena.impl.conf.OntModelConfig;
import ru.avicomp.ontapi.transforms.OWLCommonTransform;
import ru.avicomp.ontapi.transforms.OWLDeclarationTransform;
import ru.avicomp.ontapi.transforms.OWLIDTransform;
import ru.avicomp.ontapi.transforms.OWLRecursiveTransform;
import ru.avicomp.ontapi.transforms.RDFSTransform;

public enum OntSettings implements OntConfig.OptionSetting
{
    OWL_API_LOAD_CONF_IGNORED_IMPORTS(new ArrayList<E>()),
    ONT_API_LOAD_CONF_TRANSFORMERS(Stream.of(OWLIDTransform.class, OWLRecursiveTransform.class, RDFSTransform.class, OWLCommonTransform.class, OWLDeclarationTransform.class).collect(Collectors.toCollection(ArrayList::new))),
    ONT_API_LOAD_CONF_SUPPORTED_SCHEMES(OntConfig.DefaultScheme.all().collect(Collectors.toCollection(ArrayList::new))),
    ONT_API_LOAD_CONF_PERSONALITY_MODE(OntModelConfig.StdMode.MEDIUM),
    ONT_API_LOAD_CONF_PERFORM_TRANSFORMATIONS(Boolean.valueOf(true)),
    ONT_API_LOAD_CONF_ALLOW_BULK_ANNOTATION_ASSERTIONS(Boolean.valueOf(true)),
    ONT_API_LOAD_CONF_ALLOW_READ_DECLARATIONS(Boolean.valueOf(true)),
    ONT_API_LOAD_CONF_IGNORE_ANNOTATION_AXIOM_OVERLAPS(Boolean.valueOf(true)),
    ONT_API_LOAD_CONF_USE_OWL_PARSERS_TO_LOAD(Boolean.valueOf(false)),
    ONT_API_LOAD_CONF_IGNORE_AXIOMS_READ_ERRORS(Boolean.valueOf(false)),
    ONT_API_LOAD_CONF_SPLIT_AXIOM_ANNOTATIONS(Boolean.valueOf(false)),
    OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION(Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_CONNECTION_TIMEOUT(Integer.valueOf(20000)),
    OWL_API_LOAD_CONF_FOLLOW_REDIRECTS(Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_LOAD_ANNOTATIONS(Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY((Serializable)MissingImportHandlingStrategy.THROW_EXCEPTION),
    OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY((Serializable)MissingOntologyHeaderStrategy.INCLUDE_GRAPH),
    OWL_API_LOAD_CONF_REPORT_STACK_TRACES(Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT(Integer.valueOf(5)),
    OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION(Boolean.valueOf(false)),
    OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN(Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING((Serializable)PriorityCollectionSorting.ON_SET_INJECTION_ONLY),
    OWL_API_LOAD_CONF_BANNED_PARSERS((Serializable)((Object)"")),
    OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT((Serializable)((Object)"100000000")),
    OWL_API_AUTHORIZATION_VALUE((Serializable)((Object)"")),
    ONT_API_WRITE_CONF_CONTROL_IMPORTS(Boolean.valueOf(true)),
    OWL_API_WRITE_CONF_SAVE_IDS(Boolean.valueOf(false)),
    OWL_API_WRITE_CONF_REMAP_IDS(Boolean.valueOf(true)),
    OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES(Boolean.valueOf(false)),
    OWL_API_WRITE_CONF_INDENTING(Boolean.valueOf(true)),
    OWL_API_WRITE_CONF_LABEL_AS_BANNER(Boolean.valueOf(false)),
    OWL_API_WRITE_CONF_BANNERS_ENABLED(Boolean.valueOf(true)),
    OWL_API_WRITE_CONF_INDENT_SIZE(Integer.valueOf(4));

    protected static final ExtendedProperties PROPERTIES;
    protected final Serializable secondary;

    private OntSettings(Serializable value) {
        this.secondary = value;
    }

    @Override
    public Serializable getDefaultValue() {
        Object primary;
        String k = this.key();
        if (this.secondary instanceof Enum) {
            primary = PROPERTIES.getEnumProperty(k);
        } else if (this.secondary instanceof Class) {
            primary = PROPERTIES.getClassProperty(k);
        } else if (this.secondary instanceof List) {
            List<?> list = PROPERTIES.getListProperty(k);
            primary = list == null ? new ArrayList() : (list instanceof Serializable ? (Serializable)((Object)list) : new ArrayList(list));
        } else if (this.secondary instanceof Boolean) {
            primary = PROPERTIES.getBooleanProperty(k);
        } else if (this.secondary instanceof Integer) {
            primary = PROPERTIES.getIntegerProperty(k);
        } else if (this.secondary instanceof Long) {
            primary = PROPERTIES.getLongProperty(k);
        } else if (this.secondary instanceof Double) {
            primary = PROPERTIES.getDoubleProperty(k);
        } else if (this.secondary instanceof String) {
            primary = PROPERTIES.getProperty(k);
        } else {
            throw new OntApiException("Unsupported value " + this.secondary.getClass());
        }
        return primary == null ? this.secondary : primary;
    }

    public boolean isLoad() {
        return this.name().contains("_LOAD_CONF_");
    }

    public boolean isWrite() {
        return this.name().contains("_WRITE_CONF_");
    }

    public boolean isONT() {
        return this.name().startsWith("ONT_API");
    }

    public String key() {
        return this.name().toLowerCase().replace("_", ".");
    }

    protected static ExtendedProperties loadProperties() {
        ExtendedProperties res = new ExtendedProperties();
        try (InputStream io = OntApiException.notNull(OntSettings.class.getResourceAsStream("/ontapi.properties"), "Null properties");){
            res.load(io);
        }
        catch (IOException e) {
            throw new OntApiException("No properties", e);
        }
        return res;
    }

    static {
        PROPERTIES = OntSettings.loadProperties();
    }
}

