/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import ru.avicomp.ontapi.config.OntConfig;
import ru.avicomp.ontapi.config.OntSettings;

public class OntWriterConfiguration
extends OWLOntologyWriterConfiguration {
    private static final long serialVersionUID = 2369276991908772369L;
    protected final Map<OntConfig.OptionSetting, Object> map = new HashMap<OntConfig.OptionSetting, Object>();

    public OntWriterConfiguration(OWLOntologyWriterConfiguration owl) {
        if (owl == null) {
            return;
        }
        this.map.put(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS, owl.shouldSaveIdsForAllAnonymousIndividuals());
        this.map.put(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS, owl.shouldRemapAllAnonymousIndividualsIds());
        this.map.put(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES, owl.isUseNamespaceEntities());
        this.map.put(OntSettings.OWL_API_WRITE_CONF_INDENTING, owl.isIndenting());
        this.map.put(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER, owl.isLabelsAsBanner());
        this.map.put(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED, owl.shouldUseBanners());
        this.map.put(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE, owl.getIndentSize());
    }

    protected OntWriterConfiguration copy(OWLOntologyWriterConfiguration owl) {
        return new OntWriterConfiguration(owl);
    }

    protected Object get(OntConfig.OptionSetting key) {
        return key.fromMap(this.map);
    }

    protected OntWriterConfiguration set(OntSettings key, Object o) {
        if (Objects.equals(this.get(key), o)) {
            return this;
        }
        OntWriterConfiguration copy = this.copy(this);
        copy.map.put(key, o);
        return copy;
    }

    public boolean isControlImports() {
        return (Boolean)this.get(OntSettings.ONT_API_WRITE_CONF_CONTROL_IMPORTS);
    }

    public OntWriterConfiguration setControlImports(boolean b) {
        return this.set(OntSettings.ONT_API_WRITE_CONF_CONTROL_IMPORTS, b);
    }

    public boolean shouldUseBanners() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED);
    }

    public OntWriterConfiguration withBannersEnabled(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED, b);
    }

    public boolean isLabelsAsBanner() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER);
    }

    public OntWriterConfiguration withLabelsAsBanner(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER, b);
    }

    public boolean shouldSaveIdsForAllAnonymousIndividuals() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS);
    }

    public OntWriterConfiguration withSaveIdsForAllAnonymousIndividuals(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS, b);
    }

    public boolean shouldRemapAllAnonymousIndividualsIds() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS);
    }

    public OntWriterConfiguration withRemapAllAnonymousIndividualsIds(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS, b);
    }

    public boolean isUseNamespaceEntities() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES);
    }

    public OntWriterConfiguration withUseNamespaceEntities(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES, b);
    }

    public boolean isIndenting() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_INDENTING);
    }

    public OntWriterConfiguration withIndenting(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_INDENTING, b);
    }

    public int getIndentSize() {
        return (Integer)this.get(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE);
    }

    public OntWriterConfiguration withIndentSize(int indent) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE, indent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OntWriterConfiguration)) {
            return false;
        }
        OntWriterConfiguration that = (OntWriterConfiguration)((Object)o);
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }
}

