/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLNaryAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;

public abstract class AbstractNaryTranslator<Axiom extends OWLAxiom & OWLNaryAxiom<OWL>, OWL extends OWLObject & IsAnonymous, ONT extends OntObject>
extends AxiomTranslator<Axiom> {
    private final Comparator<OWL> uriFirstComparator = (a, b) -> a.isAnonymous() == b.isAnonymous() ? 0 : (a.isAnonymous() ? -1 : 1);

    void write(OWLNaryAxiom<OWL> thisAxiom, Set<OWLAnnotation> annotations, OntGraphModel model) {
        List operands = thisAxiom.operands().sorted(this.uriFirstComparator).distinct().collect(Collectors.toList());
        if (operands.isEmpty() && annotations.isEmpty()) {
            return;
        }
        if (operands.size() != 2) {
            throw new OntApiException(this.getClass().getSimpleName() + ": expected two operands. Axiom: " + thisAxiom);
        }
        WriteHelper.writeTriple(model, (OWLObject)operands.get(0), this.getPredicate(), (OWLObject)operands.get(1), annotations.stream());
    }

    @Override
    public void write(Axiom axiom, OntGraphModel model) {
        ((OWLNaryAxiom)axiom).asPairwiseAxioms().forEach(a -> this.write((OWLNaryAxiom<OWL>)a, axiom.annotations().collect(Collectors.toSet()), model));
    }

    abstract Property getPredicate();

    abstract Class<ONT> getView();

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        return Models.listStatements(model, null, this.getPredicate(), null).filterKeep(s -> s.getSubject().canAs(this.getView()));
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.getPredicate().equals(this.getPredicate()) && statement.getSubject().canAs(this.getView());
    }

    @Override
    public ExtendedIterator<ONTObject<Axiom>> listAxioms(OntGraphModel model, InternalDataFactory factory, InternalConfig config) {
        HashMap res = new HashMap();
        super.listAxioms(model, factory, config).forEachRemaining(c -> res.compute(c.getObject(), (a, w) -> w == null ? c : w.append((ONTObject<? extends OWLObject>)c)));
        return WrappedIterator.create(res.values().iterator());
    }
}

