/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.ReadHelper;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntID;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;

public class AnnotationAssertionTranslator
extends AxiomTranslator<OWLAnnotationAssertionAxiom> {
    @Override
    public void write(OWLAnnotationAssertionAxiom axiom, OntGraphModel model) {
        WriteHelper.writeAssertionTriple(model, axiom.getSubject(), (OWLPropertyExpression)axiom.getProperty(), (OWLObject)axiom.getValue(), axiom.annotations());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        if (!config.isLoadAnnotationAxioms()) {
            return NullIterator.instance();
        }
        OntID id = model.getID();
        return Models.listStatements(model, null, null, null).filterKeep(s -> !id.equals(s.getSubject()) && this.filter((OntStatement)s, config));
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        if (!config.isLoadAnnotationAxioms()) {
            return false;
        }
        if (statement.getSubject().canAs(OntID.class)) {
            return false;
        }
        return this.filter(statement, config);
    }

    public boolean filter(OntStatement s, InternalConfig c) {
        return ReadHelper.isAnnotationAssertionStatement(s, c) && ReadHelper.isEntityOrAnonymousIndividual(s.getSubject());
    }

    @Override
    public ONTObject<OWLAnnotationAssertionAxiom> toAxiom(OntStatement statement, InternalDataFactory reader, InternalConfig config) {
        ONTObject<? extends OWLAnnotationSubject> s = reader.get(statement.getSubject(OntObject.class));
        ONTObject<OWLAnnotationProperty> p = reader.get((OntNAP)statement.getPredicate().as(OntNAP.class));
        ONTObject<? extends OWLAnnotationValue> v = reader.get(statement.getObject());
        Collection annotations = reader.get(statement, config);
        OWLAnnotationAssertionAxiom res = reader.getOWLDataFactory().getOWLAnnotationAssertionAxiom(p.getObject(), s.getObject(), v.getObject(), ONTObject.extract(annotations));
        return ONTObject.create(res, statement).append(annotations).append(s).append(p).append(v);
    }
}

