/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import ru.avicomp.ontapi.internal.AbstractPropertyRangeTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.ReadHelper;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;

public class AnnotationPropertyRangeTranslator
extends AbstractPropertyRangeTranslator<OWLAnnotationPropertyRangeAxiom, OntNAP> {
    @Override
    Class<OntNAP> getView() {
        return OntNAP.class;
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        if (!config.isLoadAnnotationAxioms()) {
            return NullIterator.instance();
        }
        return super.listStatements(model, config);
    }

    @Override
    public boolean filter(OntStatement statement, InternalConfig config) {
        return super.filter(statement, config) && statement.getObject().isURIResource() && ReadHelper.testAnnotationAxiomOverlaps(statement, config, (AxiomType<? extends OWLObjectPropertyAxiom>)AxiomType.OBJECT_PROPERTY_RANGE, (AxiomType<? extends OWLDataPropertyAxiom>)AxiomType.DATA_PROPERTY_RANGE);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return config.isLoadAnnotationAxioms() && super.testStatement(statement, config);
    }

    @Override
    public ONTObject<OWLAnnotationPropertyRangeAxiom> toAxiom(OntStatement statement, InternalDataFactory reader, InternalConfig config) {
        ONTObject<OWLAnnotationProperty> p = reader.get(statement.getSubject(this.getView()));
        ONTObject<IRI> d = reader.asIRI((OntObject)statement.getObject().as(OntObject.class));
        Collection annotations = reader.get(statement, config);
        OWLAnnotationPropertyRangeAxiom res = reader.getOWLDataFactory().getOWLAnnotationPropertyRangeAxiom(p.getObject(), d.getObject(), ONTObject.extract(annotations));
        return ONTObject.create(res, statement).append(annotations).append(p).append(d);
    }
}

