/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.internal.AnnotationAssertionTranslator;
import ru.avicomp.ontapi.internal.AnnotationPropertyDomainTranslator;
import ru.avicomp.ontapi.internal.AnnotationPropertyRangeTranslator;
import ru.avicomp.ontapi.internal.AsymmetricObjectPropertyTranslator;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.ClassAssertionTranslator;
import ru.avicomp.ontapi.internal.DataPropertyAssertionTranslator;
import ru.avicomp.ontapi.internal.DataPropertyDomainTranslator;
import ru.avicomp.ontapi.internal.DataPropertyRangeTranslator;
import ru.avicomp.ontapi.internal.DatatypeDefinitionTranslator;
import ru.avicomp.ontapi.internal.DeclarationTranslator;
import ru.avicomp.ontapi.internal.DifferentIndividualsTranslator;
import ru.avicomp.ontapi.internal.DisjointClassesTranslator;
import ru.avicomp.ontapi.internal.DisjointDataPropertiesTranslator;
import ru.avicomp.ontapi.internal.DisjointObjectPropertiesTranslator;
import ru.avicomp.ontapi.internal.DisjointUnionTranslator;
import ru.avicomp.ontapi.internal.EquivalentClassesTranslator;
import ru.avicomp.ontapi.internal.EquivalentDataPropertiesTranslator;
import ru.avicomp.ontapi.internal.EquivalentObjectPropertiesTranslator;
import ru.avicomp.ontapi.internal.FunctionalDataPropertyTranslator;
import ru.avicomp.ontapi.internal.FunctionalObjectPropertyTranslator;
import ru.avicomp.ontapi.internal.HasKeyTranslator;
import ru.avicomp.ontapi.internal.InverseFunctionalObjectPropertyTranslator;
import ru.avicomp.ontapi.internal.InverseObjectPropertiesTranslator;
import ru.avicomp.ontapi.internal.IrreflexiveObjectPropertyTranslator;
import ru.avicomp.ontapi.internal.NegativeDataPropertyAssertionTranslator;
import ru.avicomp.ontapi.internal.NegativeObjectPropertyAssertionTranslator;
import ru.avicomp.ontapi.internal.ObjectPropertyAssertionTranslator;
import ru.avicomp.ontapi.internal.ObjectPropertyDomainTranslator;
import ru.avicomp.ontapi.internal.ObjectPropertyRangeTranslator;
import ru.avicomp.ontapi.internal.ReflexiveObjectPropertyTranslator;
import ru.avicomp.ontapi.internal.SWRLRuleTranslator;
import ru.avicomp.ontapi.internal.SameIndividualTranslator;
import ru.avicomp.ontapi.internal.SubAnnotationPropertyOfTranslator;
import ru.avicomp.ontapi.internal.SubClassOfTranslator;
import ru.avicomp.ontapi.internal.SubDataPropertyOfTranslator;
import ru.avicomp.ontapi.internal.SubObjectPropertyOfTranslator;
import ru.avicomp.ontapi.internal.SubPropertyChainOfTranslator;
import ru.avicomp.ontapi.internal.SymmetricObjectPropertyTranslator;
import ru.avicomp.ontapi.internal.TransitiveObjectPropertyTranslator;

public abstract class AxiomParserProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AxiomParserProvider.class);

    public static Map<AxiomType, AxiomTranslator<? extends OWLAxiom>> getParsers() {
        return ParserHolder.PARSERS;
    }

    public static <A extends OWLAxiom> AxiomTranslator<A> get(Class<A> type) {
        return AxiomParserProvider.get(AxiomType.getTypeForClass(type));
    }

    public static <A extends OWLAxiom> AxiomTranslator<A> get(A axiom) {
        return AxiomParserProvider.get(OntApiException.notNull(axiom, "Null axiom.").getAxiomType());
    }

    public static <A extends OWLAxiom> AxiomTranslator<A> get(AxiomType<A> type) {
        return OntApiException.notNull(AxiomParserProvider.getParsers().get(OntApiException.notNull(type, "Null axiom type")), "Can't find parser for axiom " + type.getActualClass());
    }

    static <A extends OWLAxiom> AxiomTranslator<A> getByType(AxiomType<? extends OWLAxiom> type) {
        return AxiomParserProvider.get(type);
    }

    private static class ParserHolder {
        private static final List<Class<? extends AxiomTranslator>> TRANSLATORS = Arrays.asList(DataPropertyDomainTranslator.class, SameIndividualTranslator.class, SubObjectPropertyOfTranslator.class, AsymmetricObjectPropertyTranslator.class, FunctionalObjectPropertyTranslator.class, AnnotationAssertionTranslator.class, DisjointUnionTranslator.class, SWRLRuleTranslator.class, EquivalentClassesTranslator.class, AnnotationPropertyRangeTranslator.class, DatatypeDefinitionTranslator.class, DisjointObjectPropertiesTranslator.class, InverseFunctionalObjectPropertyTranslator.class, DataPropertyAssertionTranslator.class, InverseObjectPropertiesTranslator.class, ReflexiveObjectPropertyTranslator.class, DifferentIndividualsTranslator.class, FunctionalDataPropertyTranslator.class, DataPropertyRangeTranslator.class, EquivalentObjectPropertiesTranslator.class, ObjectPropertyRangeTranslator.class, NegativeDataPropertyAssertionTranslator.class, SubPropertyChainOfTranslator.class, AnnotationPropertyDomainTranslator.class, TransitiveObjectPropertyTranslator.class, EquivalentDataPropertiesTranslator.class, DisjointDataPropertiesTranslator.class, ObjectPropertyDomainTranslator.class, SubAnnotationPropertyOfTranslator.class, SubClassOfTranslator.class, DisjointClassesTranslator.class, SymmetricObjectPropertyTranslator.class, SubDataPropertyOfTranslator.class, DeclarationTranslator.class, ObjectPropertyAssertionTranslator.class, ClassAssertionTranslator.class, HasKeyTranslator.class, IrreflexiveObjectPropertyTranslator.class, NegativeObjectPropertyAssertionTranslator.class);
        private static final Map<AxiomType, AxiomTranslator<? extends OWLAxiom>> PARSERS = ParserHolder.init();

        private ParserHolder() {
        }

        private static Map<AxiomType, AxiomTranslator<? extends OWLAxiom>> init() {
            HashMap<AxiomType, AxiomTranslator<? extends OWLAxiom>> res = new HashMap<AxiomType, AxiomTranslator<? extends OWLAxiom>>();
            AxiomType.AXIOM_TYPES.forEach(type -> {
                Class<? extends AxiomTranslator> parserClass = ParserHolder.findParserClass((AxiomType<? extends OWLAxiom>)type);
                try {
                    res.put((AxiomType)type, parserClass.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new OntApiException("Can't instance parser for type: " + type, e);
                }
            });
            return res;
        }

        private static Class<? extends AxiomTranslator> findParserClass(AxiomType<? extends OWLAxiom> type) {
            return TRANSLATORS.stream().filter(p -> ParserHolder.isRelatedToAxiom(p, type.getActualClass())).findFirst().orElseThrow(() -> new OntApiException("Can't find parser class for type '" + type + "'"));
        }

        private static boolean isRelatedToAxiom(Class<? extends AxiomTranslator> parserClass, Class<? extends OWLAxiom> actualClass) {
            ParameterizedType type = (ParameterizedType)parserClass.getGenericSuperclass();
            if (type == null) {
                return false;
            }
            for (Type t : type.getActualTypeArguments()) {
                if (!actualClass.getName().equals(t.getTypeName())) continue;
                return true;
            }
            return false;
        }

        static {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.trace("There are following axiom-parsers (" + PARSERS.size() + "): ");
                PARSERS.forEach((t, p) -> LOGGER.trace("{} ::: {}", t, p.getClass()));
            }
        }
    }
}

