/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.stream.Stream;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.InternalModel;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.utils.Models;

public abstract class AxiomTranslator<Axiom extends OWLAxiom> {
    public abstract void write(Axiom var1, OntGraphModel var2);

    public final Stream<ONTObject<Axiom>> axioms(OntGraphModel model) throws JenaException {
        InternalConfig conf = AxiomTranslator.getConfig(model).snapshot();
        InternalDataFactory factory = AxiomTranslator.getDataFactory(model);
        return Iter.asStream(this.listAxioms(model, factory, conf));
    }

    public ExtendedIterator<ONTObject<Axiom>> listAxioms(OntGraphModel model, InternalDataFactory factory, InternalConfig config) throws JenaException {
        return this.translate(this.listStatements(model, config), factory, config);
    }

    protected ExtendedIterator<ONTObject<Axiom>> translate(ExtendedIterator<OntStatement> statements, InternalDataFactory factory, InternalConfig config) {
        if (!config.isSplitAxiomAnnotations()) {
            return statements.mapWith(s -> this.toAxiom(Models.createCachedStatement(s), factory, config));
        }
        return Iter.flatMap(statements.mapWith(Models::createCachedStatement), Models::listSplitStatements).mapWith(s -> this.toAxiom((OntStatement)s, factory, config));
    }

    public final Stream<OntStatement> statements(OntGraphModel model) {
        return Iter.asStream(this.listStatements(model, AxiomTranslator.getConfig(model).snapshot()));
    }

    public final boolean testStatement(OntStatement statement) {
        return this.testStatement(statement, AxiomTranslator.getConfig(statement.getModel()).snapshot());
    }

    public final ONTObject<Axiom> toAxiom(OntStatement statement) throws JenaException {
        return this.toAxiom(statement, AxiomTranslator.getDataFactory(statement.getModel()), AxiomTranslator.getConfig(statement.getModel()).snapshot());
    }

    public abstract ExtendedIterator<OntStatement> listStatements(OntGraphModel var1, InternalConfig var2);

    public abstract boolean testStatement(OntStatement var1, InternalConfig var2);

    public abstract ONTObject<Axiom> toAxiom(OntStatement var1, InternalDataFactory var2, InternalConfig var3) throws JenaException;

    public static InternalConfig getConfig(OntGraphModel model) {
        return model instanceof InternalModel ? ((InternalModel)model).getConfig() : InternalConfig.DEFAULT;
    }

    public static InternalDataFactory getDataFactory(OntGraphModel model) {
        return model instanceof InternalModel ? ((InternalModel)model).getDataFactory() : InternalDataFactory.DEFAULT;
    }
}

