/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Objects;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import ru.avicomp.ontapi.DataFactory;
import ru.avicomp.ontapi.internal.NoCacheDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.jena.model.OntClass;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNOP;

public class CacheDataFactory
extends NoCacheDataFactory {
    public static final int CACHE_SIZE = 2048;
    protected final LoadingCache<OntClass, ONTObject<OWLClass>> classes;
    protected final LoadingCache<OntDT, ONTObject<OWLDatatype>> datatypes;
    protected final LoadingCache<OntNAP, ONTObject<OWLAnnotationProperty>> annotationProperties;
    protected final LoadingCache<OntNDP, ONTObject<OWLDataProperty>> datatypeProperties;
    protected final LoadingCache<OntNOP, ONTObject<OWLObjectProperty>> objectProperties;
    protected final LoadingCache<OntIndividual.Named, ONTObject<OWLNamedIndividual>> individuals;
    protected final LoadingCache<String, IRI> iris;

    public CacheDataFactory(DataFactory factory) {
        this(factory, CacheDataFactory.build(2048L, IRI::create), 2048);
    }

    public CacheDataFactory(DataFactory factory, LoadingCache<String, IRI> iris, int size) {
        super(factory);
        this.classes = CacheDataFactory.build(size, x$0 -> super.get((OntClass)x$0));
        this.datatypes = CacheDataFactory.build(size, x$0 -> super.get((OntDT)x$0));
        this.annotationProperties = CacheDataFactory.build(size, x$0 -> super.get((OntNAP)x$0));
        this.datatypeProperties = CacheDataFactory.build(size, x$0 -> super.get((OntNDP)x$0));
        this.objectProperties = CacheDataFactory.build(size, x$0 -> super.get((OntNOP)x$0));
        this.individuals = CacheDataFactory.build(size, x$0 -> super.get((OntIndividual.Named)x$0));
        this.iris = Objects.requireNonNull(iris);
    }

    @Override
    public void clear() {
        this.classes.invalidateAll();
        this.datatypes.invalidateAll();
        this.annotationProperties.invalidateAll();
        this.datatypeProperties.invalidateAll();
        this.objectProperties.invalidateAll();
        this.individuals.invalidateAll();
    }

    @Override
    public ONTObject<OWLClass> get(OntClass ce) {
        return (ONTObject)this.classes.get((Object)ce);
    }

    @Override
    public ONTObject<OWLDatatype> get(OntDT dr) {
        return (ONTObject)this.datatypes.get((Object)dr);
    }

    @Override
    public ONTObject<OWLAnnotationProperty> get(OntNAP nap) {
        return (ONTObject)this.annotationProperties.get((Object)nap);
    }

    @Override
    public ONTObject<OWLDataProperty> get(OntNDP ndp) {
        return (ONTObject)this.datatypeProperties.get((Object)ndp);
    }

    @Override
    public ONTObject<OWLObjectProperty> get(OntNOP nop) {
        return (ONTObject)this.objectProperties.get((Object)nop);
    }

    @Override
    public ONTObject<OWLNamedIndividual> get(OntIndividual.Named i) {
        return (ONTObject)this.individuals.get((Object)i);
    }

    @Override
    public IRI toIRI(String str) {
        return (IRI)this.iris.get((Object)str);
    }

    public static <K, V> LoadingCache<K, V> build(long maxSize, CacheLoader<K, V> loader) {
        if (maxSize > 0L) {
            return Caffeine.newBuilder().maximumSize(maxSize).build(loader);
        }
        return Caffeine.newBuilder().build(loader);
    }
}

