/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;

public class DataPropertyAssertionTranslator
extends AxiomTranslator<OWLDataPropertyAssertionAxiom> {
    @Override
    public void write(OWLDataPropertyAssertionAxiom axiom, OntGraphModel model) {
        WriteHelper.writeAssertionTriple(model, (OWLObject)axiom.getSubject(), axiom.getProperty(), (OWLObject)axiom.getObject(), axiom.annotations());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        return Models.listStatements(model, null, null, null).filterKeep(s -> this.testStatement((OntStatement)s, config));
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.isData() && statement.getObject().isLiteral() && statement.getSubject().canAs(OntIndividual.class);
    }

    @Override
    public ONTObject<OWLDataPropertyAssertionAxiom> toAxiom(OntStatement statement, InternalDataFactory reader, InternalConfig config) {
        ONTObject<? extends OWLIndividual> i = reader.get(statement.getSubject(OntIndividual.class));
        ONTObject<OWLDataProperty> p = reader.get((OntNDP)statement.getPredicate().as(OntNDP.class));
        ONTObject<OWLLiteral> l = reader.get(statement.getObject().asLiteral());
        Collection annotations = reader.get(statement, config);
        OWLDataPropertyAssertionAxiom res = reader.getOWLDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)p.getObject(), i.getObject(), l.getObject(), ONTObject.extract(annotations));
        return ONTObject.create(res, statement).append(annotations).append(i).append(p).append(l);
    }
}

