/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import java.util.stream.Stream;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public class DatatypeDefinitionTranslator
extends AxiomTranslator<OWLDatatypeDefinitionAxiom> {
    @Override
    public void write(OWLDatatypeDefinitionAxiom axiom, OntGraphModel model) {
        WriteHelper.writeTriple(model, (OWLObject)axiom.getDatatype(), OWL.equivalentClass, (OWLObject)axiom.getDataRange(), (Stream<OWLAnnotation>)axiom.annotations());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        return Models.listStatements(model, null, OWL.equivalentClass, null).filterKeep(s -> s.getSubject().canAs(OntDT.class) && s.getObject().canAs(OntDR.class));
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.getPredicate().equals(OWL.equivalentClass) && statement.getSubject().canAs(OntDT.class) && statement.getObject().canAs(OntDR.class);
    }

    @Override
    public ONTObject<OWLDatatypeDefinitionAxiom> toAxiom(OntStatement statement, InternalDataFactory reader, InternalConfig config) {
        ONTObject<OWLDatatype> dt = reader.get(statement.getSubject(OntDT.class));
        ONTObject<? extends OWLDataRange> dr = reader.get((OntDR)statement.getObject().as(OntDR.class));
        Collection annotations = reader.get(statement, config);
        OWLDatatypeDefinitionAxiom res = reader.getOWLDataFactory().getOWLDatatypeDefinitionAxiom(dt.getObject(), dr.getObject(), ONTObject.extract(annotations));
        return ONTObject.create(res, statement).append(annotations).append(dt).append(dr);
    }
}

