/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import java.util.Objects;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.SWRLAtom;
import ru.avicomp.ontapi.DataFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OntManagers;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.NoCacheDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntClass;
import ru.avicomp.ontapi.jena.model.OntDOP;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNOP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntPE;
import ru.avicomp.ontapi.jena.model.OntSWRL;
import ru.avicomp.ontapi.jena.model.OntStatement;

public interface InternalDataFactory {
    public static final InternalDataFactory DEFAULT = new NoCacheDataFactory(OntManagers.getDataFactory());

    public void clear();

    public DataFactory getOWLDataFactory();

    public ONTObject<OWLClass> get(OntClass var1);

    public ONTObject<OWLDatatype> get(OntDT var1);

    public ONTObject<OWLObjectProperty> get(OntNOP var1);

    public ONTObject<OWLAnnotationProperty> get(OntNAP var1);

    public ONTObject<OWLDataProperty> get(OntNDP var1);

    public ONTObject<OWLNamedIndividual> get(OntIndividual.Named var1);

    public ONTObject<? extends OWLClassExpression> get(OntCE var1);

    public ONTObject<? extends OWLDataRange> get(OntDR var1);

    public ONTObject<? extends OWLObjectPropertyExpression> get(OntOPE var1);

    public ONTObject<? extends OWLPropertyExpression> get(OntDOP var1);

    public ONTObject<? extends OWLIndividual> get(OntIndividual var1);

    public ONTObject<OWLLiteral> get(Literal var1);

    public ONTObject<? extends OWLAnnotationValue> get(RDFNode var1);

    public ONTObject<? extends OWLAnnotationSubject> get(OntObject var1);

    public ONTObject<? extends SWRLAtom> get(OntSWRL.Atom var1);

    public Collection<ONTObject<OWLAnnotation>> get(OntStatement var1, InternalConfig var2);

    public ONTObject<IRI> asIRI(OntObject var1);

    default public ONTObject<? extends OWLEntity> get(OntEntity e) {
        if (e instanceof OntClass) {
            return this.get((OntClass)e);
        }
        if (e instanceof OntDT) {
            return this.get((OntDT)e);
        }
        if (e instanceof OntIndividual.Named) {
            return this.get((OntIndividual.Named)e);
        }
        if (e instanceof OntNAP) {
            return this.get((OntNAP)e);
        }
        if (e instanceof OntNDP) {
            return this.get((OntNDP)e);
        }
        if (e instanceof OntNOP) {
            return this.get((OntNOP)e);
        }
        throw new OntApiException("Unsupported " + e);
    }

    default public IRI toIRI(String str) {
        return IRI.create((String)Objects.requireNonNull(str, "Null IRI."));
    }

    default public ONTObject<? extends OWLPropertyExpression> get(OntPE property) {
        if (OntApiException.notNull(property, "Null property.").canAs(OntNAP.class)) {
            return this.get((OntNAP)property.as(OntNAP.class));
        }
        return this.get((OntDOP)property);
    }
}

