/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.util.graph.GraphListenerBase;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.OwlObjects;
import ru.avicomp.ontapi.internal.AxiomParserProvider;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.DeclarationTranslator;
import ru.avicomp.ontapi.internal.EquivalentClassesTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.ReadHelper;
import ru.avicomp.ontapi.internal.SubClassOfTranslator;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.OntJenaException;
import ru.avicomp.ontapi.jena.impl.OntGraphModelImpl;
import ru.avicomp.ontapi.jena.impl.conf.OntPersonality;
import ru.avicomp.ontapi.jena.model.OntClass;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNOP;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Iter;
import ru.avicomp.ontapi.jena.vocabulary.OWL;

public class InternalModel
extends OntGraphModelImpl
implements OntGraphModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalModel.class);
    public static final List<AxiomType<? extends OWLAxiom>> AXIOM_TYPES = AxiomType.AXIOM_TYPES.stream().sorted().collect(Iter.toUnmodifiableList());
    private final InternalConfig config;
    protected LoadingCache<Class<? extends OWLObject>, ObjectTriplesMap<? extends OWLObject>> components = Caffeine.newBuilder().softValues().build(this::readObjectTriples);
    protected final InternalDataFactory cacheDataFactory;
    protected LoadingCache<Class<? extends OWLObject>, Set<? extends OWLObject>> objects = Caffeine.newBuilder().softValues().build(this::readOWLObjects);

    public InternalModel(Graph base, OntPersonality personality, InternalDataFactory factory, InternalConfig config) {
        super(base, personality);
        this.config = Objects.requireNonNull(config);
        this.cacheDataFactory = Objects.requireNonNull(factory);
        this.getGraph().getEventManager().register((GraphListener)new DirectListener());
    }

    public InternalConfig getConfig() {
        return this.config;
    }

    public InternalDataFactory getDataFactory() {
        return this.cacheDataFactory;
    }

    public Lock getLock() {
        throw new OntApiException.Unsupported();
    }

    public void enterCriticalSection(boolean requestReadLock) {
        throw new OntApiException.Unsupported();
    }

    public void leaveCriticalSection() {
        throw new OntApiException.Unsupported();
    }

    public Stream<OWLImportsDeclaration> listOWLImportDeclarations() {
        return this.getID().imports().map(this.cacheDataFactory::toIRI).map(i -> this.cacheDataFactory.getOWLDataFactory().getOWLImportsDeclaration((IRI)i));
    }

    public boolean isOntologyEmpty() {
        return this.listOWLAxioms().count() == 0L && this.listOWLAnnotations().count() == 0L;
    }

    public Stream<OWLEntity> listOWLEntities(IRI iri) {
        if (iri == null) {
            return Stream.empty();
        }
        OntEntity e = this.getOntEntity(OntEntity.class, iri.getIRIString());
        ArrayList<ONTObject<Object>> res = new ArrayList<ONTObject<Object>>();
        if (e.canAs(OntClass.class)) {
            res.add(this.cacheDataFactory.get((OntClass)e.as(OntClass.class)));
        }
        if (e.canAs(OntDT.class)) {
            res.add(this.cacheDataFactory.get((OntDT)e.as(OntDT.class)));
        }
        if (e.canAs(OntNAP.class)) {
            res.add(this.cacheDataFactory.get((OntNAP)e.as(OntNAP.class)));
        }
        if (e.canAs(OntNDP.class)) {
            res.add(this.cacheDataFactory.get((OntNDP)e.as(OntNDP.class)));
        }
        if (e.canAs(OntNOP.class)) {
            res.add(this.cacheDataFactory.get((OntNOP)e.as(OntNOP.class)));
        }
        if (e.canAs(OntIndividual.Named.class)) {
            res.add(this.cacheDataFactory.get((OntIndividual.Named)e.as(OntIndividual.Named.class)));
        }
        return res.stream().map(ONTObject::getObject);
    }

    public Stream<OWLAnonymousIndividual> listOWLAnonymousIndividuals() {
        return this.listOWLObjects(OWLAnonymousIndividual.class);
    }

    public Stream<OWLNamedIndividual> listOWLNamedIndividuals() {
        return this.listOWLObjects(OWLNamedIndividual.class);
    }

    public Stream<OWLClass> listOWLClasses() {
        return this.listOWLObjects(OWLClass.class);
    }

    public Stream<OWLDataProperty> listOWLDataProperties() {
        return this.listOWLObjects(OWLDataProperty.class);
    }

    public Stream<OWLObjectProperty> listOWLObjectProperties() {
        return this.listOWLObjects(OWLObjectProperty.class);
    }

    public Stream<OWLAnnotationProperty> listOWLAnnotationProperties() {
        return this.listOWLObjects(OWLAnnotationProperty.class);
    }

    public Stream<OWLDatatype> listOWLDatatypes() {
        return this.listOWLObjects(OWLDatatype.class);
    }

    protected <O extends OWLObject> Stream<O> listOWLObjects(Class<O> type) {
        return ((Set)Objects.requireNonNull(this.objects.get(type), "Nothing found. Type: " + type)).stream();
    }

    protected <O extends OWLObject> Set<O> readOWLObjects(Class<O> type) {
        return Stream.concat(this.listOWLAnnotations().flatMap(a -> OwlObjects.objects(type, a)), this.listOWLAxioms().flatMap(a -> OwlObjects.objects(type, a))).collect(Collectors.toSet());
    }

    public void add(OWLAnnotation annotation) {
        this.add(annotation, this.getAnnotationTripleStore(), a -> WriteHelper.addAnnotations(this.getID(), Stream.of(annotation)));
    }

    public void remove(OWLAnnotation annotation) {
        this.remove(annotation, this.getAnnotationTripleStore());
        this.clearObjectsCaches();
    }

    public Stream<OWLAnnotation> listOWLAnnotations() {
        return this.getAnnotationTripleStore().objects();
    }

    public Stream<OWLDeclarationAxiom> listOWLDeclarationAxioms(OWLEntity e) {
        InternalConfig conf = this.getConfig().snapshot();
        if (!conf.isAllowReadDeclarations()) {
            return Stream.empty();
        }
        if (this.hasManuallyAddedAxioms()) {
            return this.listOWLAxioms(OWLDeclarationAxiom.class).filter(a -> e.equals(a.getEntity()));
        }
        DeclarationTranslator t = (DeclarationTranslator)AxiomParserProvider.get(OWLDeclarationAxiom.class);
        OntEntity res = this.findNodeAs(WriteHelper.toResource((OWLObject)e).asNode(), WriteHelper.getEntityView(e));
        if (res == null) {
            return Stream.empty();
        }
        OntStatement s = res.getRoot();
        return s == null ? Stream.empty() : Stream.of(t.toAxiom(s, this.cacheDataFactory, conf).getObject());
    }

    public Stream<OWLAnnotationAssertionAxiom> listOWLAnnotationAssertionAxioms(OWLAnnotationSubject s) {
        InternalConfig conf = this.getConfig().snapshot();
        if (!conf.isLoadAnnotationAxioms()) {
            return Stream.empty();
        }
        if (this.hasManuallyAddedAxioms()) {
            return this.listOWLAxioms(OWLAnnotationAssertionAxiom.class).filter(a -> s.equals(a.getSubject()));
        }
        AxiomTranslator<Class<OWLAnnotationAssertionAxiom>> t = AxiomParserProvider.get(OWLAnnotationAssertionAxiom.class);
        ExtendedIterator res = this.listLocalStatements(WriteHelper.toResource((OWLObject)s), null, null).filterKeep(x -> t.testStatement((OntStatement)x, conf));
        return Iter.asStream(t.translate((ExtendedIterator<OntStatement>)res, this.cacheDataFactory, conf).mapWith(ONTObject::getObject));
    }

    public Stream<OWLSubClassOfAxiom> listOWLSubClassOfAxioms(OWLClass sub) {
        if (this.hasManuallyAddedAxioms()) {
            return this.listOWLAxioms(OWLSubClassOfAxiom.class).filter(a -> Objects.equals(a.getSubClass(), sub));
        }
        SubClassOfTranslator t = (SubClassOfTranslator)AxiomParserProvider.get(OWLSubClassOfAxiom.class);
        ExtendedIterator res = this.listLocalStatements(WriteHelper.toResource((OWLObject)sub), RDFS.subClassOf, null).filterKeep(t::filter);
        InternalConfig conf = this.getConfig().snapshot();
        return Iter.asStream(t.translate((ExtendedIterator<OntStatement>)res, this.cacheDataFactory, conf).mapWith(ONTObject::getObject));
    }

    public Stream<OWLEquivalentClassesAxiom> listOWLEquivalentClassesAxioms(OWLClass c) {
        if (this.hasManuallyAddedAxioms()) {
            return this.listOWLAxioms(OWLEquivalentClassesAxiom.class).filter(a -> a.operands().anyMatch(c::equals));
        }
        EquivalentClassesTranslator t = (EquivalentClassesTranslator)AxiomParserProvider.get(OWLEquivalentClassesAxiom.class);
        Resource r = WriteHelper.toResource((OWLObject)c);
        InternalConfig conf = this.getConfig().snapshot();
        ExtendedIterator res = this.listLocalStatements(r, OWL.equivalentClass, null).andThen(this.listLocalStatements(null, OWL.equivalentClass, (RDFNode)r)).filterKeep(s -> t.testStatement((OntStatement)s, conf));
        return Iter.asStream(t.translate((ExtendedIterator<OntStatement>)res, this.cacheDataFactory, conf).mapWith(ONTObject::getObject));
    }

    public Stream<OWLAxiom> listOWLAxioms() {
        return this.listOWLAxioms(AXIOM_TYPES);
    }

    public Stream<OWLAxiom> listOWLAxioms(Collection<AxiomType<? extends OWLAxiom>> types) {
        return types.stream().map(t -> this.getAxiomTripleStore(t.getActualClass())).flatMap(ObjectTriplesMap::objects).map(OWLAxiom.class::cast);
    }

    public <A extends OWLAxiom> Stream<A> listOWLAxioms(Class<A> view) {
        return this.listOWLAxioms(AxiomType.getTypeForClass(OntApiException.notNull(view, "Null axiom class type.")));
    }

    public <A extends OWLAxiom> Stream<A> listOWLAxioms(AxiomType<A> type) {
        return this.getAxiomTripleStore(type).objects();
    }

    public void add(OWLAxiom axiom) {
        this.add(axiom, this.getAxiomTripleStore((AxiomType<? extends OWLAxiom>)axiom.getAxiomType()), a -> AxiomParserProvider.getByType((AxiomType<? extends OWLAxiom>)a.getAxiomType()).write(a, this));
    }

    public void remove(OWLAxiom axiom) {
        this.remove(axiom, this.getAxiomTripleStore((AxiomType<? extends OWLAxiom>)axiom.getAxiomType()));
        Stream.of(OWLClass.class, OWLDatatype.class, OWLAnnotationProperty.class, OWLDataProperty.class, OWLObjectProperty.class, OWLNamedIndividual.class, OWLAnonymousIndividual.class).filter(entityType -> OwlObjects.objects(entityType, axiom).findAny().isPresent()).forEach(type -> this.objects.invalidate(type));
    }

    public boolean contains(OWLAxiom a) {
        if (!this.getCacheMap().containsKey(a.getClass())) {
            AXIOM_TYPES.forEach(t -> this.getAxiomTripleStore(t.getActualClass()));
        }
        return this.getAxiomTripleStore((AxiomType<? extends OWLAxiom>)a.getAxiomType()).contains(a);
    }

    protected <A extends OWLAxiom> ObjectTriplesMap<A> getAxiomTripleStore(AxiomType<? extends OWLAxiom> type) {
        return this.getAxiomTripleStore(type.getActualClass());
    }

    protected <A extends OWLAxiom> ObjectTriplesMap<A> getAxiomTripleStore(Class<A> type) {
        return (ObjectTriplesMap)this.components.get(type);
    }

    protected <O extends OWLObject> ObjectTriplesMap<O> readObjectTriples(Class<? extends OWLObject> type) {
        Instant start = null;
        if (LOGGER.isDebugEnabled()) {
            start = Instant.now();
        }
        ObjectTriplesMap<Object> res = OWLAnnotation.class.equals(type) ? this.readAnnotationTriples() : this.readAxiomTriples(type);
        if (start != null) {
            Duration d = Duration.between(start, Instant.now());
            LOGGER.debug("[{}]{}:::{}s{}", new Object[]{this.getID(), StringUtils.rightPad((String)("[" + type.getSimpleName() + "]"), (int)42), String.format(Locale.ENGLISH, "%.3f", (double)d.toMillis() / 1000.0), res.size() != 0 ? "(" + res.size() + ")" : ""});
        }
        return res;
    }

    @Override
    public <N extends RDFNode> N fetchNodeAs(Node node, Class<N> view) {
        try {
            return super.fetchNodeAs(node, view);
        }
        catch (OntJenaException e) {
            if (!this.getConfig().isIgnoreAxiomsReadErrors()) {
                throw new OntApiException((Throwable)((Object)e));
            }
            LOGGER.warn("Found a problem inside ontology <{}>: {}", (Object)this.getID(), (Object)e.getMessage());
            return null;
        }
    }

    protected <A extends OWLAxiom> ObjectTriplesMap<A> readAxiomTriples(Class<A> type) {
        return ObjectTriplesMap.create(type, Iter.asStream(AxiomParserProvider.get(type).listAxioms(this, this.cacheDataFactory, this.getConfig().snapshot())));
    }

    protected ObjectTriplesMap<OWLAnnotation> readAnnotationTriples() {
        return ObjectTriplesMap.create(OWLAnnotation.class, ReadHelper.objectAnnotations(this.getID(), this.cacheDataFactory));
    }

    protected ObjectTriplesMap<OWLAnnotation> getAnnotationTripleStore() {
        return (ObjectTriplesMap)this.components.get(OWLAnnotation.class);
    }

    protected <O extends OWLObject> void add(O object, ObjectTriplesMap<O> store, Consumer<O> writer) {
        OwlObjectListener<O> listener = this.createListener(store, object);
        this.clearObjectsCaches();
        try {
            this.getGraph().getEventManager().register((GraphListener)listener);
            store.manual = true;
            writer.accept(object);
        }
        catch (Exception e) {
            throw new OntApiException(String.format("OWLObject: %s, message: %s", object, e.getMessage()), e);
        }
        finally {
            this.getGraph().getEventManager().unregister((GraphListener)listener);
        }
    }

    protected <O extends OWLObject> void remove(O component, ObjectTriplesMap<O> map) {
        Set<Triple> triples = map.getTripleSet(component);
        map.remove(component);
        triples.stream().filter(t -> !this.containsTriple((Triple)t)).forEach(this::delete);
    }

    protected boolean containsTriple(Triple triple) {
        return this.getComponents().stream().anyMatch(c -> c.contains(triple));
    }

    protected void delete(Triple triple) {
        this.getNodeCache().remove((Object)triple.getSubject());
        this.getBaseGraph().delete(triple);
    }

    public InternalModel removeAll() {
        this.clearCache();
        this.getNodeCache().clear();
        super.removeAll();
        return this;
    }

    protected void clearCacheOnDelete(Triple triple) {
        this.getComponents().stream().filter(map -> InternalModel.findObjectsToInvalidate(map, triple).findAny().isPresent()).forEach(o -> this.components.invalidate(o.type()));
        this.clearObjectsCaches();
    }

    protected static <O extends OWLObject> Stream<O> findObjectsToInvalidate(ObjectTriplesMap<O> map, Triple triple) {
        return map.objects().filter(o -> {
            try {
                Set<Triple> res = map.get(o);
                return res == null || res.contains(triple);
            }
            catch (JenaException j) {
                return true;
            }
        });
    }

    protected Collection<ObjectTriplesMap<? extends OWLObject>> getComponents() {
        return this.getCacheMap().values();
    }

    public void clearCacheIfNeeded() {
        if (this.hasManuallyAddedAxioms()) {
            this.clearCache();
        }
    }

    public boolean hasManuallyAddedAxioms() {
        return this.getCacheMap().values().stream().anyMatch(m -> m.manual);
    }

    protected Map<Class<? extends OWLObject>, ObjectTriplesMap<? extends OWLObject>> getCacheMap() {
        return this.components.asMap();
    }

    protected void clearObjectsCaches() {
        this.objects.invalidateAll();
        this.cacheDataFactory.clear();
    }

    public void clearCache() {
        this.components.invalidateAll();
        this.clearObjectsCaches();
    }

    @Override
    public String toString() {
        return String.format("[%s]%s", this.getClass().getSimpleName(), this.getID());
    }

    public <O extends OWLObject> OwlObjectListener<O> createListener(ObjectTriplesMap<O> map, O obj) {
        return new OwlObjectListener<O>(map, obj);
    }

    public class DirectListener
    extends GraphListenerBase {
        private boolean hasObjectListener() {
            return InternalModel.this.getGraph().getEventManager().hasListeners(OwlObjectListener.class);
        }

        private void invalidate() {
            if (this.hasObjectListener()) {
                return;
            }
            InternalModel.this.clearCache();
        }

        protected void addEvent(Triple t) {
            this.invalidate();
        }

        protected void deleteEvent(Triple t) {
            if (this.hasObjectListener()) {
                return;
            }
            InternalModel.this.clearCacheOnDelete(t);
        }

        public void notifyAddGraph(Graph g, Graph other) {
            this.invalidate();
        }

        public void notifyDeleteGraph(Graph g, Graph other) {
            this.invalidate();
        }
    }

    public static class OwlObjectListener<O extends OWLObject>
    extends GraphListenerBase {
        private final ObjectTriplesMap<O> store;
        private final O object;

        public OwlObjectListener(ObjectTriplesMap<O> store, O object) {
            this.store = store;
            this.object = object;
        }

        protected void addEvent(Triple t) {
            this.store.add(this.object, t);
        }

        protected void deleteEvent(Triple t) {
            this.store.remove(this.object, t);
        }
    }

    public static class ObjectTriplesMap<O extends OWLObject> {
        protected final Class<O> type;
        protected final Map<O, ONTObject<O>> map;
        protected LoadingCache<O, Set<Triple>> triples = Caffeine.newBuilder().softValues().build(this::loadTripleSet);
        protected boolean manual;

        public ObjectTriplesMap(Class<O> type, Map<O, ONTObject<O>> map) {
            this.type = type;
            this.map = map;
        }

        protected static <R extends OWLObject> ObjectTriplesMap<R> create(Class<R> type, Stream<ONTObject<R>> stream) {
            return new ObjectTriplesMap<R>(type, stream.collect(Collectors.toMap(ONTObject::getObject, Function.identity(), ONTObject::append, HashMap::new)));
        }

        public Class<O> type() {
            return this.type;
        }

        private Optional<ONTObject<O>> find(O key) {
            return Optional.ofNullable(this.map.get(key));
        }

        @Nonnull
        private Set<Triple> loadTripleSet(O key) {
            return this.find(key).map(s -> s.triples().collect(Collectors.toSet())).orElse(Collections.emptySet());
        }

        public void add(O key, Triple triple) {
            ONTObject res = this.find(key).map(o -> o.isEmpty() ? new TripleSet(this, o) : o).orElseGet(() -> new TripleSet(this, key));
            this.map.put(key, res.add(triple));
            this.fromCache(key).ifPresent(set -> set.add(triple));
        }

        public void remove(O key, Triple triple) {
            this.find(key).ifPresent(o -> this.map.put(o.getObject(), o.delete(triple)));
            this.fromCache(key).ifPresent(set -> set.remove(triple));
        }

        public void remove(O key) {
            this.triples.invalidate(key);
            this.map.remove(key);
        }

        protected Optional<Set<Triple>> fromCache(O key) {
            return Optional.ofNullable(this.triples.getIfPresent(key));
        }

        protected Set<Triple> get(O key) {
            return (Set)this.triples.get(key);
        }

        public Set<Triple> getTripleSet(O key) {
            return Objects.requireNonNull(this.get(key));
        }

        public boolean contains(Triple triple) {
            return this.objects().anyMatch(o -> this.getTripleSet(o).contains(triple));
        }

        public boolean contains(O o) {
            return this.map.containsKey(o);
        }

        public Stream<O> objects() {
            return this.map.keySet().stream();
        }

        public int size() {
            return this.map.size();
        }

        private static class TripleSet<V extends O>
        extends ONTObject<V> {
            private final Set<Triple> triples;
            final /* synthetic */ ObjectTriplesMap this$0;

            protected TripleSet(V object) {
                this(var1_1, (OWLObject)object, new HashSet());
            }

            protected TripleSet(ObjectTriplesMap objectTriplesMap, ONTObject<V> object) {
                this(objectTriplesMap, (OWLObject)object.getObject(), object.triples().collect(Collectors.toCollection(HashSet::new)));
            }

            private TripleSet(V object, Set<Triple> triples) {
                this.this$0 = var1_1;
                super(object);
                this.triples = triples;
            }

            @Override
            public Stream<Triple> triples() {
                return this.triples.stream();
            }

            @Override
            protected boolean isEmpty() {
                return this.triples.isEmpty();
            }

            @Override
            public ONTObject<V> add(Triple triple) {
                this.triples.add(triple);
                return this;
            }

            @Override
            public ONTObject<V> delete(Triple triple) {
                this.triples.remove(triple);
                return this;
            }
        }
    }
}

