/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.SWRLAtom;
import ru.avicomp.ontapi.DataFactory;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.ReadHelper;
import ru.avicomp.ontapi.jena.model.OntCE;
import ru.avicomp.ontapi.jena.model.OntClass;
import ru.avicomp.ontapi.jena.model.OntDOP;
import ru.avicomp.ontapi.jena.model.OntDR;
import ru.avicomp.ontapi.jena.model.OntDT;
import ru.avicomp.ontapi.jena.model.OntEntity;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntNAP;
import ru.avicomp.ontapi.jena.model.OntNDP;
import ru.avicomp.ontapi.jena.model.OntNOP;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntSWRL;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;
import ru.avicomp.ontapi.owlapi.objects.OWLLiteralImpl;

public class NoCacheDataFactory
implements InternalDataFactory {
    protected final DataFactory factory;

    public NoCacheDataFactory(DataFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    @Override
    public void clear() {
    }

    protected IRI toIRI(Resource r) {
        return this.toIRI(r.getURI());
    }

    @Override
    public ONTObject<? extends OWLClassExpression> get(OntCE ce) {
        return ReadHelper.calcClassExpression(ce, this, new HashSet<Resource>());
    }

    @Override
    public ONTObject<? extends OWLDataRange> get(OntDR dr) {
        return ReadHelper.calcDataRange(dr, this, new HashSet<Resource>());
    }

    @Override
    public ONTObject<OWLClass> get(OntClass ce) {
        IRI iri = this.toIRI(OntApiException.notNull(ce, "Null class."));
        return ONTObject.create(this.getOWLDataFactory().getOWLClass(iri), ce);
    }

    @Override
    public ONTObject<OWLDatatype> get(OntDT dr) {
        IRI iri = this.toIRI(OntApiException.notNull(dr, "Null datatype."));
        return ONTObject.create(this.getOWLDataFactory().getOWLDatatype(iri), dr);
    }

    @Override
    public ONTObject<OWLObjectProperty> get(OntNOP nop) {
        IRI iri = this.toIRI(OntApiException.notNull(nop, "Null object property."));
        return ONTObject.create(this.getOWLDataFactory().getOWLObjectProperty(iri), nop);
    }

    @Override
    public ONTObject<OWLAnnotationProperty> get(OntNAP nap) {
        IRI iri = this.toIRI(OntApiException.notNull(nap, "Null annotation property."));
        return ONTObject.create(this.getOWLDataFactory().getOWLAnnotationProperty(iri), nap);
    }

    @Override
    public ONTObject<OWLDataProperty> get(OntNDP ndp) {
        IRI iri = this.toIRI(OntApiException.notNull(ndp, "Null data property."));
        return ONTObject.create(this.getOWLDataFactory().getOWLDataProperty(iri), ndp);
    }

    @Override
    public ONTObject<OWLNamedIndividual> get(OntIndividual.Named i) {
        IRI iri = this.toIRI(OntApiException.notNull(i, "Null individual."));
        return ONTObject.create(this.getOWLDataFactory().getOWLNamedIndividual(iri), i);
    }

    @Override
    public ONTObject<? extends OWLObjectPropertyExpression> get(OntOPE ope) {
        OntApiException.notNull(ope, "Null object property.");
        if (ope.isAnon()) {
            OWLObjectProperty op = this.getOWLDataFactory().getOWLObjectProperty(this.toIRI(((OntOPE.Inverse)ope.as(OntOPE.Inverse.class)).getDirect()));
            return ONTObject.create(op.getInverseProperty(), ope);
        }
        return this.get((OntNOP)ope.as(OntNOP.class));
    }

    @Override
    public ONTObject<? extends OWLPropertyExpression> get(OntDOP property) {
        if (property.canAs(OntOPE.class)) {
            return this.get((OntOPE)property.as(OntOPE.class));
        }
        if (property.canAs(OntNDP.class)) {
            return this.get((OntNDP)property.as(OntNDP.class));
        }
        throw new OntApiException("Unsupported property " + property);
    }

    @Override
    public ONTObject<? extends OWLIndividual> get(OntIndividual individual) {
        DataFactory df = this.getOWLDataFactory();
        if (OntApiException.notNull(individual, "Null individual").isURIResource()) {
            return this.get((OntIndividual.Named)individual.as(OntIndividual.Named.class));
        }
        return ONTObject.create(df.getOWLAnonymousIndividual(individual.asNode().getBlankNodeId()), individual);
    }

    @Override
    public ONTObject<OWLLiteral> get(Literal literal) {
        DataFactory df = this.getOWLDataFactory();
        OWLLiteral owl = df.getOWLLiteral(literal.asNode().getLiteral());
        ONTObject<OWLLiteral> res = ONTObject.create(owl);
        OntDT dt = (OntDT)literal.getModel().getResource(literal.getDatatypeURI()).as(OntDT.class);
        if (!dt.isBuiltIn()) {
            if (owl instanceof OWLLiteralImpl) {
                ((OWLLiteralImpl)owl).putOWLDatatype(this.get(dt).getObject());
            }
            return res.append(this.get(dt));
        }
        return res;
    }

    @Override
    public ONTObject<? extends OWLAnnotationValue> get(RDFNode value) {
        if (OntApiException.notNull(value, "Null node").isLiteral()) {
            return this.get(value.asLiteral());
        }
        if (value.isURIResource()) {
            return this.asIRI((OntObject)value.as(OntObject.class));
        }
        if (value.isAnon()) {
            return this.getAnonymous(Models.asAnonymousIndividual(value));
        }
        throw new OntApiException("Not an AnnotationValue " + value);
    }

    @Override
    public ONTObject<? extends OWLAnnotationSubject> get(OntObject subject) {
        if (OntApiException.notNull(subject, "Null resource").isURIResource()) {
            return this.asIRI(subject);
        }
        if (subject.isAnon()) {
            return this.getAnonymous(Models.asAnonymousIndividual((RDFNode)subject));
        }
        throw new OntApiException("Not an AnnotationSubject " + subject);
    }

    public ONTObject<OWLAnonymousIndividual> getAnonymous(OntIndividual.Anonymous individual) {
        return this.get(individual);
    }

    @Override
    public ONTObject<? extends SWRLAtom> get(OntSWRL.Atom atom) {
        return ReadHelper.calcSWRLAtom(atom, this);
    }

    @Override
    public ONTObject<IRI> asIRI(OntObject object) {
        return ONTObject.create(this.toIRI(object), object.canAs(OntEntity.class) ? (OntObject)object.as(OntEntity.class) : object);
    }

    @Override
    public Collection<ONTObject<OWLAnnotation>> get(OntStatement statement, InternalConfig config) {
        return ReadHelper.getAnnotations(statement, config, this);
    }

    @Override
    public DataFactory getOWLDataFactory() {
        return this.factory;
    }
}

