/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.CollectionGraph;
import org.semanticweb.owlapi.model.OWLObject;
import ru.avicomp.ontapi.OntApiException;
import ru.avicomp.ontapi.jena.model.OntObject;
import ru.avicomp.ontapi.jena.model.OntStatement;

public abstract class ONTObject<O extends OWLObject> {
    private final O object;
    private int hashCode;

    protected ONTObject(O object) {
        this.object = (OWLObject)Objects.requireNonNull(object, "Null OWLObject.");
    }

    public O getObject() {
        return this.object;
    }

    public abstract Stream<Triple> triples();

    protected boolean isEmpty() {
        return false;
    }

    public Graph toGraph() {
        return new CollectionGraph((Collection)this.triples().collect(Collectors.toSet()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ONTObject)) {
            return false;
        }
        ONTObject that = (ONTObject)o;
        return this.object.equals(that.object);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.object.hashCode();
        return this.hashCode;
    }

    public String toString() {
        return String.valueOf(this.object);
    }

    public static <O extends OWLObject> ONTObject<O> create(O o) {
        return new ONTObject<O>(o){

            @Override
            public Stream<Triple> triples() {
                return Stream.empty();
            }

            @Override
            public boolean isEmpty() {
                return true;
            }
        };
    }

    public static <O extends OWLObject> ONTObject<O> create(O o, OntStatement root) {
        return ONTObject.create(o, root.asTriple());
    }

    static <O extends OWLObject> ONTObject<O> create(O o, final Triple root) {
        return new ONTObject<O>(o){

            @Override
            public Stream<Triple> triples() {
                return Stream.of(root);
            }
        };
    }

    public static <O extends OWLObject> ONTObject<O> create(O o, final OntObject root) {
        return new ONTObject<O>(o){

            @Override
            public Stream<Triple> triples() {
                return root.spec().map(FrontsTriple::asTriple);
            }
        };
    }

    public ONTObject<O> append(OntObject other) {
        return this.append(() -> other.spec().map(FrontsTriple::asTriple));
    }

    public ONTObject<O> append(ONTObject<? extends OWLObject> other) {
        return this.append(other::triples);
    }

    public <B extends OWLObject> ONTObject<O> append(Collection<ONTObject<B>> others) {
        return this.append(() -> others.stream().flatMap(ONTObject::triples));
    }

    <B extends OWLObject> ONTObject<O> appendWildcards(Collection<ONTObject<? extends B>> others) {
        return this.append(() -> others.stream().flatMap(ONTObject::triples));
    }

    public ONTObject<O> append(final Supplier<Stream<Triple>> triples) {
        return new ONTObject<O>((OWLObject)this.object){

            @Override
            public Stream<Triple> triples() {
                return ONTObject.this.concat((Stream)triples.get());
            }
        };
    }

    private Stream<Triple> concat(Stream<Triple> other) {
        return this.isEmpty() ? other : Stream.concat(this.triples(), other);
    }

    public ONTObject<O> add(Triple triple) {
        return this.append(() -> Stream.of(triple));
    }

    public ONTObject<O> delete(final Triple triple) {
        if (this.isEmpty()) {
            return this;
        }
        return new ONTObject<O>((OWLObject)this.object){

            @Override
            public Stream<Triple> triples() {
                return ONTObject.this.triples().filter(t -> !triple.equals(t));
            }
        };
    }

    public static <O extends OWLObject> Optional<ONTObject<O>> find(Collection<ONTObject<O>> set, O key) {
        int h = OntApiException.notNull(key, "null key").hashCode();
        int t = key.typeIndex();
        return set.stream().filter(Objects::nonNull).filter(o -> o.object.typeIndex() == t).filter(o -> o.hashCode() == h).filter(o -> key.equals(o.object)).findAny();
    }

    public static <O extends OWLObject> Stream<O> objects(Collection<ONTObject<O>> wraps) {
        return wraps.stream().map(ONTObject::getObject);
    }

    public static <O extends OWLObject> Set<O> extract(Collection<ONTObject<O>> wraps) {
        return ONTObject.objects(wraps).collect(Collectors.toSet());
    }

    static <R extends OWLObject> Set<R> extractWildcards(Collection<ONTObject<? extends R>> wraps) {
        return wraps.stream().map(ONTObject::getObject).collect(Collectors.toSet());
    }
}

