/*
 * Decompiled with CFR 0.152.
 */
package ru.avicomp.ontapi.internal;

import java.util.Collection;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import ru.avicomp.ontapi.internal.AxiomTranslator;
import ru.avicomp.ontapi.internal.InternalConfig;
import ru.avicomp.ontapi.internal.InternalDataFactory;
import ru.avicomp.ontapi.internal.ONTObject;
import ru.avicomp.ontapi.internal.WriteHelper;
import ru.avicomp.ontapi.jena.model.OntGraphModel;
import ru.avicomp.ontapi.jena.model.OntIndividual;
import ru.avicomp.ontapi.jena.model.OntOPE;
import ru.avicomp.ontapi.jena.model.OntStatement;
import ru.avicomp.ontapi.jena.utils.Models;

public class ObjectPropertyAssertionTranslator
extends AxiomTranslator<OWLObjectPropertyAssertionAxiom> {
    @Override
    public void write(OWLObjectPropertyAssertionAxiom axiom, OntGraphModel model) {
        OWLObjectPropertyExpression property = ((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous() ? ((OWLObjectPropertyExpression)axiom.getProperty()).getInverseProperty() : (OWLObjectPropertyExpression)axiom.getProperty();
        OWLIndividual subject = ((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous() ? (OWLIndividual)axiom.getObject() : axiom.getSubject();
        OWLIndividual object = ((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous() ? axiom.getSubject() : (OWLIndividual)axiom.getObject();
        WriteHelper.writeAssertionTriple(model, (OWLObject)subject, (OWLPropertyExpression)property, (OWLObject)object, axiom.annotations());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntGraphModel model, InternalConfig config) {
        return Models.listStatements(model, null, null, null).filterKeep(s -> this.testStatement((OntStatement)s, config));
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.isObject() && statement.getSubject().canAs(OntIndividual.class) && statement.getObject().canAs(OntIndividual.class);
    }

    @Override
    public ONTObject<OWLObjectPropertyAssertionAxiom> toAxiom(OntStatement statement, InternalDataFactory reader, InternalConfig config) {
        ONTObject<? extends OWLIndividual> subject = reader.get(statement.getSubject(OntIndividual.class));
        ONTObject<? extends OWLObjectPropertyExpression> property = reader.get((OntOPE)statement.getPredicate().as(OntOPE.class));
        ONTObject<? extends OWLIndividual> object = reader.get((OntIndividual)statement.getObject().as(OntIndividual.class));
        Collection annotations = reader.get(statement, config);
        OWLObjectPropertyAssertionAxiom res = reader.getOWLDataFactory().getOWLObjectPropertyAssertionAxiom(property.getObject(), subject.getObject(), object.getObject(), ONTObject.extract(annotations));
        return ONTObject.create(res, statement).append(annotations).append(subject).append(property).append(object);
    }
}

